/*
 * Decompiled with CFR 0.152.
 */
package com.tynoxs.buildersdelight;

import com.tynoxs.buildersdelight.content.entity.renderer.SitRenderer;
import com.tynoxs.buildersdelight.content.init.BdBlocks;
import com.tynoxs.buildersdelight.content.init.BdConfig;
import com.tynoxs.buildersdelight.content.init.BdContainers;
import com.tynoxs.buildersdelight.content.init.BdDecoration;
import com.tynoxs.buildersdelight.content.init.BdEntities;
import com.tynoxs.buildersdelight.content.init.BdItems;
import com.tynoxs.buildersdelight.content.init.BdSounds;
import com.tynoxs.buildersdelight.content.init.BdTabs;
import com.tynoxs.buildersdelight.content.recipe.ChiselRecipeFactory;
import com.tynoxs.buildersdelight.content.recipe.ClientChiselRecipeFactory;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="buildersdelight")
public class BuildersDelight {
    public static final String CommonConfigFile = "buildersdelight-common.toml";
    public static final String MODID = "buildersdelight";
    private static BuildersDelight instance;
    private ChiselRecipeFactory recipeFactory;
    private BdConfig config;

    public BuildersDelight() {
        instance = this;
        this.recipeFactory = new ChiselRecipeFactory();
        this.config = new BdConfig();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BdConfig.SPEC, CommonConfigFile);
        BdTabs.register(eventBus);
        BdItems.register(eventBus);
        BdBlocks.register(eventBus);
        BdDecoration.register(eventBus);
        BdEntities.register(eventBus);
        BdContainers.register(eventBus);
        BdSounds.register(eventBus);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::addResourceReload);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        this.config.loadConfigValues();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)BdEntities.SIT.get()), SitRenderer::new);
        this.recipeFactory.clear();
        ClientChiselRecipeFactory clientChiselRecipeFactory = new ClientChiselRecipeFactory(this.recipeFactory);
        clientChiselRecipeFactory.loadClientRecipes();
    }

    public void addResourceReload(AddReloadListenerEvent event) {
        this.recipeFactory.clear();
        event.addListener((PreparableReloadListener)this.recipeFactory);
    }

    public ChiselRecipeFactory getRecipeFactory() {
        return this.recipeFactory;
    }

    public static BuildersDelight get() {
        return instance;
    }
}

