/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.platform;

import com.illusivesoulworks.diet.DietConstants;
import com.illusivesoulworks.diet.platform.services.ICapabilityService;
import com.illusivesoulworks.diet.platform.services.IEventService;
import com.illusivesoulworks.diet.platform.services.INetworkService;
import com.illusivesoulworks.diet.platform.services.IPlatformService;
import com.illusivesoulworks.diet.platform.services.IRegistryService;
import java.util.ServiceLoader;

public class Services {
    public static final IPlatformService PLATFORM = Services.load(IPlatformService.class);
    public static final ICapabilityService CAPABILITY = Services.load(ICapabilityService.class);
    public static final IRegistryService REGISTRY = Services.load(IRegistryService.class);
    public static final IEventService EVENT = Services.load(IEventService.class);
    public static final INetworkService NETWORK = Services.load(INetworkService.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        DietConstants.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

