/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.network;

import com.illusivesoulworks.diet.common.network.server.SPacketActivate;
import com.illusivesoulworks.diet.common.network.server.SPacketDiet;
import com.illusivesoulworks.diet.common.network.server.SPacketEaten;
import com.illusivesoulworks.diet.common.network.server.SPacketEffectsInfo;
import com.illusivesoulworks.diet.common.network.server.SPacketGroups;
import com.illusivesoulworks.diet.common.network.server.SPacketSuites;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class DietForgeNetwork {
    private static final String PTC_VERSION = "1";
    public static SimpleChannel instance;
    private static int id;

    public static void setup() {
        instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("diet", "main")).networkProtocolVersion(() -> PTC_VERSION).clientAcceptedVersions(PTC_VERSION::equals).serverAcceptedVersions(PTC_VERSION::equals).simpleChannel();
        DietForgeNetwork.register(SPacketDiet.class, SPacketDiet::encode, SPacketDiet::decode, SPacketDiet::handle);
        DietForgeNetwork.register(SPacketEffectsInfo.class, SPacketEffectsInfo::encode, SPacketEffectsInfo::decode, SPacketEffectsInfo::handle);
        DietForgeNetwork.register(SPacketActivate.class, SPacketActivate::encode, SPacketActivate::decode, SPacketActivate::handle);
        DietForgeNetwork.register(SPacketEaten.class, SPacketEaten::encode, SPacketEaten::decode, SPacketEaten::handle);
        DietForgeNetwork.register(SPacketGroups.class, SPacketGroups::encode, SPacketGroups::decode, SPacketGroups::handle);
        DietForgeNetwork.register(SPacketSuites.class, SPacketSuites::encode, SPacketSuites::decode, SPacketSuites::handle);
    }

    public static <M> void register(Class<M> clazz, BiConsumer<M, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, M> decoder, Consumer<M> handler) {
        instance.registerMessage(id++, clazz, encoder, decoder, (message, contextSupplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSupplier.get();
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> handler.accept(message)));
            context.setPacketHandled(true);
        });
    }

    static {
        id = 0;
    }
}

