/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.data.group;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.illusivesoulworks.diet.DietConstants;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.util.DietColor;
import com.illusivesoulworks.diet.common.data.group.DietGroup;
import com.illusivesoulworks.diet.common.util.DietValueGenerator;
import com.illusivesoulworks.diet.platform.Services;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class DietGroups
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final DietGroups SERVER = Services.CAPABILITY.getGroupsListener();
    public static final DietGroups CLIENT = Services.CAPABILITY.getGroupsListener();
    private Map<String, IDietGroup> groups = new HashMap<String, IDietGroup>();

    public DietGroups() {
        super(GSON, "diet/groups");
    }

    public static Set<IDietGroup> getGroups(Level level) {
        DietGroups instance = level.m_5776_() ? CLIENT : SERVER;
        return ImmutableSet.copyOf(instance.groups.values());
    }

    public static Optional<IDietGroup> getGroup(Level level, String name) {
        DietGroups instance = level.m_5776_() ? CLIENT : SERVER;
        return Optional.ofNullable(instance.groups.get(name));
    }

    public Set<IDietGroup> getGroups() {
        return ImmutableSet.copyOf(this.groups.values());
    }

    public Optional<IDietGroup> getGroup(String name) {
        return Optional.ofNullable(this.groups.get(name));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, IDietGroup> entry : this.groups.entrySet()) {
            tag.m_128365_(entry.getKey(), (Tag)entry.getValue().save());
        }
        return tag;
    }

    public void load(CompoundTag tag) {
        HashMap<String, IDietGroup> loaded = new HashMap<String, IDietGroup>();
        for (String key : tag.m_128431_()) {
            loaded.put(key, DietGroup.load((CompoundTag)Objects.requireNonNull(tag.m_128423_(key))));
        }
        this.groups = loaded;
    }

    public void sync(ServerPlayer player) {
        HashMap<Item, Set<String>> items = new HashMap<Item, Set<String>>();
        for (Map.Entry<Item, Set<IDietGroup>> entry : DietValueGenerator.getAll().entrySet()) {
            HashSet<String> groups = new HashSet<String>();
            for (IDietGroup group : entry.getValue()) {
                groups.add(group.getName());
            }
            items.put(entry.getKey(), groups);
        }
        Services.NETWORK.sendDietGroupsS2C(player, this.save(), items);
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> object, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profilerFiller) {
        ResourceLocation resourcelocation;
        HashMap<String, DietGroup.Builder> map = new HashMap<String, DietGroup.Builder>();
        for (Map.Entry<ResourceLocation, JsonElement> entry2 : object.entrySet()) {
            resourcelocation = entry2.getKey();
            if (!resourcelocation.m_135827_().equals("diet")) continue;
            try {
                this.buildGroup(map.computeIfAbsent(resourcelocation.m_135815_(), DietGroup.Builder::new), GsonHelper.m_13918_((JsonElement)entry2.getValue(), (String)"top element"));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DietConstants.LOG.error("Parsing error loading diet group {}", (Object)resourcelocation, (Object)e);
            }
        }
        for (Map.Entry<ResourceLocation, JsonElement> entry2 : object.entrySet()) {
            resourcelocation = entry2.getKey();
            if (resourcelocation.m_135815_().startsWith("_") || resourcelocation.m_135827_().equals("diet")) continue;
            try {
                this.buildGroup(map.computeIfAbsent(resourcelocation.m_135815_(), DietGroup.Builder::new), GsonHelper.m_13918_((JsonElement)entry2.getValue(), (String)"top element"));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DietConstants.LOG.error("Parsing error loading diet group {}", (Object)resourcelocation, (Object)e);
            }
        }
        this.groups = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((DietGroup.Builder)entry.getValue()).build()));
        DietConstants.LOG.info("Loaded {} diet groups", (Object)map.size());
    }

    private void buildGroup(DietGroup.Builder builder, JsonObject topElement) {
        if (topElement.has("icon")) {
            String icon = GsonHelper.m_13906_((JsonObject)topElement, (String)"icon");
            Services.REGISTRY.getItem(new ResourceLocation(icon)).ifPresent(builder::icon);
        }
        if (topElement.has("color")) {
            String color = GsonHelper.m_13906_((JsonObject)topElement, (String)"color");
            int col = color.startsWith("#") ? Integer.parseInt(color.substring(1), 16) : Integer.parseInt(color);
            int r = col >> 16 & 0xFF;
            int g = col >> 8 & 0xFF;
            int b = col & 0xFF;
            builder.color(new DietColor(r, g, b));
        }
        if (topElement.has("order")) {
            builder.order(GsonHelper.m_13927_((JsonObject)topElement, (String)"order"));
        }
        if (topElement.has("default_value")) {
            builder.defaultValue(GsonHelper.m_13915_((JsonObject)topElement, (String)"default_value"));
        }
        if (topElement.has("gain_multiplier")) {
            builder.gainMultiplier(GsonHelper.m_13915_((JsonObject)topElement, (String)"gain_multiplier"));
        }
        if (topElement.has("decay_multiplier")) {
            builder.decayMultiplier(GsonHelper.m_13915_((JsonObject)topElement, (String)"decay_multiplier"));
        }
        if (topElement.has("beneficial")) {
            builder.beneficial(GsonHelper.m_13912_((JsonObject)topElement, (String)"beneficial"));
        }
    }
}

