/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.capability;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.illusivesoulworks.diet.api.DietApi;
import com.illusivesoulworks.diet.api.type.IDietAttribute;
import com.illusivesoulworks.diet.api.type.IDietCondition;
import com.illusivesoulworks.diet.api.type.IDietEffect;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.type.IDietResult;
import com.illusivesoulworks.diet.api.type.IDietStatusEffect;
import com.illusivesoulworks.diet.api.type.IDietTracker;
import com.illusivesoulworks.diet.common.config.DietConfig;
import com.illusivesoulworks.diet.common.data.effect.DietEffect;
import com.illusivesoulworks.diet.common.data.effect.DietEffectsInfo;
import com.illusivesoulworks.diet.common.data.suite.DietSuites;
import com.illusivesoulworks.diet.common.util.DietResult;
import com.illusivesoulworks.diet.platform.Services;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PlayerDietTracker
implements IDietTracker {
    private static final Map<MobEffect, Integer> EFFECT_DURATION = new HashMap<MobEffect, Integer>();
    private final Player player;
    private final Map<String, Float> values = new HashMap<String, Float>();
    private final Map<Attribute, Set<UUID>> activeModifiers = new HashMap<Attribute, Set<UUID>>();
    private final Set<Item> eatenFood = new HashSet<Item>();
    private boolean active = true;
    private String suite = "builtin";
    private int prevFood = 0;
    private ItemStack captured = ItemStack.f_41583_;

    public PlayerDietTracker(Player player) {
        this.player = player;
        this.initSuite();
    }

    @Override
    public void initSuite() {
        HashMap<String, Float> oldValues = new HashMap<String, Float>(this.values);
        this.values.clear();
        DietSuites.getSuite(this.player.m_9236_(), this.suite).ifPresent(suite -> {
            for (IDietGroup group : suite.getGroups()) {
                String name = group.getName();
                float amount = oldValues.containsKey(name) ? ((Float)oldValues.get(name)).floatValue() : group.getDefaultValue();
                this.values.put(name, Float.valueOf(Mth.m_14036_((float)amount, (float)0.0f, (float)1.0f)));
            }
        });
    }

    @Override
    public void tick() {
        if (!this.player.m_9236_().m_5776_()) {
            if (!this.player.m_7500_() && this.active) {
                int currentFood = this.player.m_36324_().m_38702_();
                if (currentFood < this.prevFood && !Services.EVENT.fireApplyDecayEvent(this.player)) {
                    this.decay(this.prevFood - currentFood);
                }
                this.prevFood = currentFood;
            }
            if (this.player.f_19797_ % 80 == 0) {
                for (Map.Entry<Attribute, Set<UUID>> entry : this.activeModifiers.entrySet()) {
                    Set<UUID> uuids = entry.getValue();
                    AttributeInstance att = this.player.m_21051_(entry.getKey());
                    if (att == null) continue;
                    for (UUID uuid : uuids) {
                        att.m_22120_(uuid);
                    }
                }
                this.activeModifiers.clear();
                if (this.active) {
                    this.applyEffects();
                }
            }
        }
    }

    @Override
    public void consume(ItemStack stack, int healing, float saturationModifier) {
        IDietResult result;
        if (this.active && this.prevFood != this.player.m_36324_().m_38702_() && !Services.EVENT.fireConsumeStackEvent(stack, this.player) && (result = DietApi.getInstance().get(this.player, stack, healing, saturationModifier)) != DietResult.EMPTY) {
            this.addEaten(stack.m_41720_());
            this.apply(result);
        }
    }

    @Override
    public void consume(List<ItemStack> stacks, int healing, float saturationModifier) {
        IDietResult result;
        if (this.active && this.prevFood != this.player.m_36324_().m_38702_() && (result = DietApi.getInstance().get(this.player, stacks, healing, saturationModifier)) != DietResult.EMPTY) {
            this.apply(result);
        }
    }

    @Override
    public void consume(ItemStack stack) {
        IDietResult result;
        if (this.active && this.prevFood != this.player.m_36324_().m_38702_() && !Services.EVENT.fireConsumeStackEvent(stack, this.player) && (result = DietApi.getInstance().get(this.player, stack)) != DietResult.EMPTY) {
            this.addEaten(stack.m_41720_());
            this.apply(result);
        }
    }

    @Override
    public float getValue(String group) {
        return this.values.getOrDefault(group, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void setValue(String group, float amount) {
        this.values.replace(group, Float.valueOf(Mth.m_14036_((float)amount, (float)0.0f, (float)1.0f)));
    }

    @Override
    public Map<String, Float> getValues() {
        return ImmutableMap.copyOf(this.values);
    }

    @Override
    public void setValues(Map<String, Float> entries) {
        for (Map.Entry<String, Float> entry : entries.entrySet()) {
            this.values.replace(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getSuite() {
        return this.suite;
    }

    @Override
    public void setSuite(String name) {
        if (!this.suite.equals(name)) {
            this.suite = name;
            this.initSuite();
        }
    }

    @Override
    public Map<Attribute, Set<UUID>> getModifiers() {
        return ImmutableMap.copyOf(this.activeModifiers);
    }

    @Override
    public void setModifiers(Map<Attribute, Set<UUID>> modifiers) {
        this.activeModifiers.clear();
        this.activeModifiers.putAll(modifiers);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    private void applyEffects() {
        if (Services.EVENT.fireApplyEffectEvent(this.player)) {
            return;
        }
        DietEffectsInfo info = new DietEffectsInfo();
        DietSuites.getSuite(this.player.m_9236_(), this.suite).ifPresent(suite -> {
            for (IDietEffect effect : suite.getEffects()) {
                boolean match = true;
                int multiplier = 0;
                for (IDietCondition condition : effect.getConditions()) {
                    int matches = condition.getMatches(this.player, this.values);
                    if (matches == 0) {
                        match = false;
                        break;
                    }
                    if (condition.getMatchMethod() != DietEffect.MatchMethod.EVERY) continue;
                    multiplier += matches;
                }
                if (!match) continue;
                multiplier = Math.max(1, multiplier);
                for (IDietAttribute attribute : effect.getAttributes()) {
                    AttributeInstance att = this.player.m_21051_(attribute.getAttribute());
                    AttributeModifier mod = new AttributeModifier(effect.getUuid(), "Diet group effect", attribute.getBaseAmount() + (double)(multiplier - 1) * attribute.getIncrement(), attribute.getOperation());
                    if (att == null || att.m_22109_(mod)) continue;
                    att.m_22125_(mod);
                    this.activeModifiers.computeIfAbsent(attribute.getAttribute(), k -> new HashSet()).add(effect.getUuid());
                    info.addModifier(attribute.getAttribute(), mod);
                }
                for (IDietStatusEffect statusEffect : effect.getStatusEffects()) {
                    int duration = EFFECT_DURATION.getOrDefault(statusEffect.getEffect(), 100);
                    MobEffectInstance instance = new MobEffectInstance(statusEffect.getEffect(), duration, statusEffect.getBasePower() + (multiplier - 1) * statusEffect.getIncrement(), true, false);
                    this.player.m_7292_(instance);
                    info.addEffect(instance);
                }
            }
        });
        if (this.player instanceof ServerPlayer) {
            Services.NETWORK.sendEffectsInfoS2C((ServerPlayer)this.player, info);
        }
    }

    private void decay(int foodDiff) {
        HashMap<String, Float> updated = new HashMap<String, Float>();
        long size = this.values.values().stream().filter(val -> val.floatValue() > 0.0f).count();
        if (size <= 0L) {
            return;
        }
        float scale = (float)foodDiff / (float)size;
        float finalScale = scale = (float)((double)scale * Math.pow(1.0f - (float)((Integer)DietConfig.SERVER.decayPenaltyPerGroup.get()).intValue() / 100.0f, size - 1L));
        DietSuites.getSuite(this.player.m_9236_(), this.suite).ifPresent(suite -> {
            for (IDietGroup group : suite.getGroups()) {
                String name = group.getName();
                float value = this.getValue(name);
                float decay = (float)(Math.exp(value) * (double)finalScale * group.getDecayMultiplier() / 100.0);
                if (!(decay > 0.0f)) continue;
                value = Mth.m_14036_((float)(value - decay), (float)0.0f, (float)1.0f);
                this.values.replace(name, Float.valueOf(value));
                updated.put(name, Float.valueOf(value));
            }
        });
        if (!updated.isEmpty()) {
            this.sync(this.suite, updated);
        }
    }

    private void apply(IDietResult result) {
        Map<IDietGroup, Float> entries = result.get();
        HashMap<String, Float> applied = new HashMap<String, Float>();
        for (Map.Entry<IDietGroup, Float> entry : entries.entrySet()) {
            String name = entry.getKey().getName();
            float value = Mth.m_14036_((float)(entry.getValue().floatValue() + this.values.get(name).floatValue()), (float)0.0f, (float)1.0f);
            this.values.replace(name, Float.valueOf(value));
            applied.put(name, Float.valueOf(value));
        }
        if (!applied.isEmpty()) {
            this.sync(this.suite, applied);
        }
    }

    @Override
    public void sync() {
        this.sync(this.suite, this.values);
        this.sync(this.active);
        this.sync(this.eatenFood);
    }

    private void sync(Set<Item> values) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Services.NETWORK.sendEatenS2C(serverPlayer, values);
        }
    }

    private void sync(String suite, Map<String, Float> values) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Services.NETWORK.sendDietS2C(serverPlayer, suite, values);
        }
    }

    private void sync(boolean flag) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Services.NETWORK.sendActivationS2C(serverPlayer, flag);
        }
    }

    @Override
    public void captureStack(ItemStack stack) {
        this.captured = stack;
    }

    @Override
    public ItemStack getCapturedStack() {
        return this.captured;
    }

    @Override
    public void addEaten(Item item) {
        this.eatenFood.add(item);
        this.sync(Sets.newHashSet((Object[])new Item[]{item}));
    }

    @Override
    public Set<Item> getEaten() {
        return this.eatenFood;
    }

    @Override
    public void setEaten(Set<Item> foods) {
        this.eatenFood.clear();
        this.eatenFood.addAll(foods);
    }

    @Override
    public void save(CompoundTag tag) {
        Map<String, Float> values = this.getValues();
        if (values != null) {
            for (Map.Entry<String, Float> group : values.entrySet()) {
                tag.m_128350_(group.getKey(), group.getValue().floatValue());
            }
        }
        ListTag list = new ListTag();
        Map<Attribute, Set<UUID>> modifiers = this.getModifiers();
        if (modifiers != null) {
            for (Map.Entry<Attribute, Set<UUID>> modifier : modifiers.entrySet()) {
                CompoundTag attributeTag = new CompoundTag();
                attributeTag.m_128365_("AttributeName", (Tag)StringTag.m_129297_((String)Objects.requireNonNull(Services.REGISTRY.getAttributeKey(modifier.getKey())).toString()));
                ListTag uuids = new ListTag();
                for (UUID uuid : modifier.getValue()) {
                    uuids.add((Object)StringTag.m_129297_((String)uuid.toString()));
                }
                attributeTag.m_128365_("UUIDs", (Tag)uuids);
                list.add((Object)attributeTag);
            }
        }
        tag.m_128365_("Modifiers", (Tag)list);
        list = new ListTag();
        Set<Item> eaten = this.getEaten();
        if (eaten != null) {
            for (Item item : eaten) {
                ResourceLocation rl = Services.REGISTRY.getItemKey(item);
                if (rl == null) continue;
                list.add((Object)StringTag.m_129297_((String)rl.toString()));
            }
        }
        tag.m_128365_("Eaten", (Tag)list);
        tag.m_128379_("Active", this.isActive());
    }

    @Override
    public void load(CompoundTag tag) {
        HashMap<String, Float> groups = new HashMap<String, Float>();
        DietSuites.getSuite(this.player.m_9236_(), this.suite).ifPresent(suite -> {
            for (IDietGroup group : suite.getGroups()) {
                String name = group.getName();
                float amount = tag.m_128441_(name) ? tag.m_128457_(name) : group.getDefaultValue();
                groups.put(name, Float.valueOf(Mth.m_14036_((float)amount, (float)0.0f, (float)1.0f)));
            }
        });
        ListTag list = tag.m_128437_("Modifiers", 10);
        HashMap<Attribute, Set<UUID>> modifiers = new HashMap<Attribute, Set<UUID>>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag attributeTag = list.m_128728_(i);
            Attribute att = Services.REGISTRY.getAttribute(new ResourceLocation(attributeTag.m_128461_("AttributeName"))).orElse(null);
            if (att == null) continue;
            HashSet<UUID> uuids = new HashSet<UUID>();
            ListTag uuidList = attributeTag.m_128437_("UUIDs", 8);
            for (int j = 0; j < uuidList.size(); ++j) {
                uuids.add(UUID.fromString(uuidList.m_128778_(j)));
            }
            modifiers.put(att, uuids);
        }
        list = tag.m_128437_("Eaten", 8);
        HashSet<Item> eaten = new HashSet<Item>();
        for (int i = 0; i < list.size(); ++i) {
            String s = list.m_128778_(i);
            ResourceLocation rl = new ResourceLocation(s);
            Services.REGISTRY.getItem(rl).ifPresent(eaten::add);
        }
        this.setEaten(eaten);
        this.setModifiers(modifiers);
        this.setValues(groups);
        this.setActive(!tag.m_128441_("Active") || tag.m_128471_("Active"));
    }

    @Override
    public void copy(Player oldPlayer, boolean wasDeath) {
        Services.CAPABILITY.get(this.player).ifPresent(diet -> Services.CAPABILITY.get(oldPlayer).ifPresent(originalDiet -> {
            Map<String, Float> originalValues = originalDiet.getValues();
            DietSuites.getSuite(this.player.m_9236_(), this.suite).ifPresent(suite -> {
                for (IDietGroup group : suite.getGroups()) {
                    float originalValue;
                    String id = group.getName();
                    float newValue = originalValue = originalValues.getOrDefault(id, Float.valueOf(group.getDefaultValue())).floatValue();
                    if (wasDeath) {
                        if (DietConfig.SERVER.deathPenaltyMethod.get() == DietConfig.DeathPenaltyMethod.RESET) {
                            newValue = group.getDefaultValue();
                        } else {
                            float loss = (float)((Integer)DietConfig.SERVER.deathPenaltyLoss.get()).intValue() / 100.0f;
                            newValue = DietConfig.SERVER.deathPenaltyMethod.get() == DietConfig.DeathPenaltyMethod.AMOUNT ? (newValue -= loss) : (newValue *= 1.0f - loss);
                            newValue = Math.min(originalValue, Math.max(newValue, (float)((Integer)DietConfig.SERVER.deathPenaltyMin.get()).intValue() / 100.0f));
                        }
                    }
                    diet.setValue(id, newValue);
                }
            });
            diet.setActive(originalDiet.isActive());
            if (!wasDeath) {
                diet.setModifiers(originalDiet.getModifiers());
            }
        }));
    }

    static {
        EFFECT_DURATION.put(MobEffects.f_19611_, 300);
        EFFECT_DURATION.put(MobEffects.f_19604_, 300);
    }
}

