/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.capability;

import com.illusivesoulworks.diet.DietConstants;
import com.illusivesoulworks.diet.api.type.IDietTracker;
import com.illusivesoulworks.diet.common.capability.DietCapability;
import com.illusivesoulworks.diet.common.capability.PlayerDietTracker;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="diet")
public class DietCapabilityEventsListener {
    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Object object = evt.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            PlayerDietTracker tracker = new PlayerDietTracker(player);
            LazyOptional capability = LazyOptional.of(() -> tracker);
            evt.addCapability(DietCapability.DIET_TRACKER_ID, (ICapabilityProvider)new Provider(tracker, (LazyOptional<IDietTracker>)capability));
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Player original = evt.getOriginal();
            original.reviveCaps();
            DietCapability.get((Player)player2).ifPresent(tracker -> tracker.copy(original, evt.isWasDeath()));
            original.invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void playerRespawned(PlayerEvent.PlayerRespawnEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DietCapability.get((Player)player2).ifPresent(IDietTracker::sync);
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DietCapability.get((Player)player2).ifPresent(IDietTracker::sync);
        }
    }

    @SubscribeEvent
    public static void playerDimensionTravel(PlayerEvent.PlayerChangedDimensionEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DietCapability.get((Player)player2).ifPresent(IDietTracker::sync);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.side == LogicalSide.SERVER && evt.phase == TickEvent.Phase.END) {
            DietCapability.get(evt.player).ifPresent(IDietTracker::tick);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void finishItemUse(LivingEntityUseItemEvent.Finish evt) {
        FoodProperties food;
        ItemStack stack = evt.getItem();
        LivingEntity livingEntity = evt.getEntity();
        if (!livingEntity.m_9236_().m_5776_() && livingEntity instanceof Player && (food = stack.getFoodProperties(livingEntity)) != null) {
            DietCapability.get((Player)livingEntity).ifPresent(diet -> diet.consume(stack));
        }
    }

    private record Provider(IDietTracker instance, LazyOptional<IDietTracker> capability) implements ICapabilitySerializable<Tag>
    {
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (DietCapability.DIET_TRACKER != null) {
                return DietCapability.DIET_TRACKER.orEmpty(cap, this.capability);
            }
            DietConstants.LOG.error("Missing Diet capability!");
            return LazyOptional.empty();
        }

        public Tag serializeNBT() {
            if (this.instance != null) {
                CompoundTag tag = new CompoundTag();
                this.instance.save(tag);
                return tag;
            }
            DietConstants.LOG.error("Missing Diet capability!");
            return new CompoundTag();
        }

        public void deserializeNBT(Tag nbt) {
            if (this.instance != null && nbt instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)nbt;
                this.instance.load(tag);
            } else {
                DietConstants.LOG.error("Missing Diet capability!");
            }
        }
    }
}

