/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.client;

import com.illusivesoulworks.diet.api.type.IDietTracker;
import com.illusivesoulworks.diet.client.screen.DietScreen;
import com.illusivesoulworks.diet.common.data.effect.DietEffectsInfo;
import com.illusivesoulworks.diet.common.data.group.DietGroups;
import com.illusivesoulworks.diet.common.data.suite.DietSuites;
import com.illusivesoulworks.diet.common.network.server.SPacketActivate;
import com.illusivesoulworks.diet.common.network.server.SPacketDiet;
import com.illusivesoulworks.diet.common.network.server.SPacketEaten;
import com.illusivesoulworks.diet.common.util.DietValueGenerator;
import com.illusivesoulworks.diet.platform.Services;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class DietClientPacketReceiver {
    public static void handleActivate(SPacketActivate msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Services.CAPABILITY.get((Player)player).ifPresent(diet -> diet.setActive(msg.flag()));
        }
    }

    public static void handleDiet(SPacketDiet msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Services.CAPABILITY.get((Player)player).ifPresent(diet -> {
                diet.setSuite(msg.suite());
                for (Map.Entry<String, Float> entry : msg.groups().entrySet()) {
                    diet.setValue(entry.getKey(), entry.getValue().floatValue());
                }
            });
        }
    }

    public static void handleEaten(SPacketEaten msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Services.CAPABILITY.get((Player)player).ifPresent(diet -> {
                for (Item item : msg.items()) {
                    diet.addEaten(item);
                }
            });
        }
    }

    public static void handleEffectsInfo(DietEffectsInfo info) {
        DietScreen.tooltip = info;
    }

    public static void handleGroups(CompoundTag groups, Map<Item, Set<String>> generated) {
        DietGroups.CLIENT.load(groups);
        DietValueGenerator.load(generated);
    }

    public static void handleSuites(CompoundTag suites) {
        DietSuites.CLIENT.load(suites);
        Services.CAPABILITY.get((Player)Minecraft.m_91087_().f_91074_).ifPresent(IDietTracker::initSuite);
    }
}

