/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.binocularsmod.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ModNetworking {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("binocularsmod", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    public static void register() {
        INSTANCE.registerMessage(packetId++, BinocularsAnimationMessage.class, BinocularsAnimationMessage::encode, BinocularsAnimationMessage::decode, BinocularsAnimationMessage::handle);
    }

    public static void sendToServer(Object msg) {
        INSTANCE.sendToServer(msg);
    }

    public static void sendToPlayer(Object msg, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }

    public static void sendToAll(Object msg) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), msg);
    }

    public static class BinocularsAnimationMessage {
        private final int playerID;
        private final boolean isUsing;
        private final float zoomLevel;

        public BinocularsAnimationMessage(int playerID, boolean isUsing, float zoomLevel) {
            this.playerID = playerID;
            this.isUsing = isUsing;
            this.zoomLevel = zoomLevel;
        }

        public static void encode(BinocularsAnimationMessage msg, FriendlyByteBuf buf) {
            buf.writeInt(msg.playerID);
            buf.writeBoolean(msg.isUsing);
            buf.writeFloat(msg.zoomLevel);
        }

        public static BinocularsAnimationMessage decode(FriendlyByteBuf buf) {
            return new BinocularsAnimationMessage(buf.readInt(), buf.readBoolean(), buf.readFloat());
        }

        public static void handle(BinocularsAnimationMessage msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Player player;
                if (Minecraft.m_91087_().f_91073_ != null && (player = (Player)Minecraft.m_91087_().f_91073_.m_6815_(msg.playerID)) != null) {
                    if (msg.isUsing) {
                        player.m_6672_(player.m_7655_());
                    } else {
                        player.m_5810_();
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

