/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.binocularsmod.mixin;

import com.keerdm.binocularsmod.registry.ItemRegistry;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public abstract class PlayerModelMixin<T extends LivingEntity>
extends HumanoidModel<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BinocularsMixin");
    private static final float ARMS_FORWARD_ANGLE = -105.0f;
    private static final float ARMS_SPREAD = 15.0f;
    private static final float ARMS_TILT = 5.0f;
    private static final float HEAD_MOVEMENT_FACTOR = 1.0f;
    @Shadow
    public final ModelPart f_103374_;
    @Shadow
    public final ModelPart f_103375_;

    public PlayerModelMixin(ModelPart root) {
        super(root);
        this.f_103374_ = root.m_171324_("left_sleeve");
        this.f_103375_ = root.m_171324_("right_sleeve");
    }

    @Inject(method={"setupAnim"}, at={@At(value="RETURN")})
    private void onSetupAnimEnd(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        Player player;
        ItemStack useItem;
        if (entity instanceof Player && !(useItem = (player = (Player)entity).m_21211_()).m_41619_() && useItem.m_150930_((Item)ItemRegistry.BINOCULARS.get())) {
            LOGGER.debug("Setting up binoculars animation");
            this.f_102811_.f_104203_ = (float)Math.toRadians(-105.0);
            this.f_102811_.f_104204_ = (float)Math.toRadians(-15.0);
            this.f_102811_.f_104205_ = (float)Math.toRadians(5.0);
            this.f_102812_.f_104203_ = (float)Math.toRadians(-105.0);
            this.f_102812_.f_104204_ = (float)Math.toRadians(15.0);
            this.f_102812_.f_104205_ = (float)Math.toRadians(-5.0);
            float pitchAdjustment = headPitch * 1.0f;
            this.f_102811_.f_104203_ += (float)Math.toRadians(pitchAdjustment);
            this.f_102812_.f_104203_ += (float)Math.toRadians(pitchAdjustment);
            this.f_103375_.m_104315_(this.f_102811_);
            this.f_103374_.m_104315_(this.f_102812_);
            this.f_102808_.f_104204_ = 0.0f;
            this.f_102809_.f_104204_ = 0.0f;
            LOGGER.debug("Binoculars position set - Arms forward: {}, spread: {}, tilt: {}, pitch only", new Object[]{Float.valueOf(-105.0f), Float.valueOf(15.0f), Float.valueOf(5.0f)});
        }
    }
}

