/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.binocularsmod.item;

import com.keerdm.binocularsmod.client.BinocularsOverlay;
import com.keerdm.binocularsmod.network.ModNetworking;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinocularsItem
extends Item {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BinocularsItem");

    public BinocularsItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        LOGGER.info("BinocularsItem use() called. Hand: " + hand + ", Player: " + player.m_7755_().getString());
        LOGGER.info("Current item usage state: " + player.m_6117_());
        player.m_5496_(SoundEvents.f_144231_, 0.5f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
        if (level.f_46443_) {
            LOGGER.info("Starting binoculars use on client");
            BinocularsOverlay.startUsingBinoculars();
        } else {
            LOGGER.info("Sending network message from server");
            ModNetworking.sendToAll(new ModNetworking.BinocularsAnimationMessage(player.m_19879_(), true, BinocularsOverlay.getCurrentZoom()));
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (level.f_46443_) {
            LOGGER.info("Use tick - Duration: " + remainingUseDuration);
        }
        super.m_5929_(level, entity, stack, remainingUseDuration);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        LOGGER.info("releaseUsing called. TimeLeft: " + timeLeft);
        if (level.f_46443_) {
            BinocularsOverlay.stopUsingBinoculars();
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.f_46443_) {
                ModNetworking.sendToAll(new ModNetworking.BinocularsAnimationMessage(player.m_19879_(), false, BinocularsOverlay.getCurrentZoom()));
            }
            player.m_5496_(SoundEvents.f_144232_, 0.5f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
        }
    }
}

