/*
 * Decompiled with CFR 0.152.
 */
package com.keerdm.binocularsmod.client;

import com.keerdm.binocularsmod.config.BinocularsConfig;
import com.keerdm.binocularsmod.item.BinocularsItem;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public class BinocularsOverlay {
    private static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("binocularsmod", "textures/gui/binocular_overlay.png");
    private static float currentZoom = 1.0f;
    private static float lastZoomLevel = -1.0f;
    private static boolean isUsingBinoculars = false;
    private static double baseMouseSensitivity;
    private static final double MINIMUM_SENSITIVITY = 1.0E-5;
    private static boolean isInitialized;
    private static final IGuiOverlay BINOCULARS_OVERLAY;
    private static final IGuiOverlay BINOCULARS_TEXT_OVERLAY;

    private static float getDefaultZoom() {
        return ((Double)BinocularsConfig.DEFAULT_ZOOM.get()).floatValue();
    }

    private static float getMinZoom() {
        return ((Double)BinocularsConfig.MIN_ZOOM.get()).floatValue();
    }

    private static float getMaxZoom() {
        return ((Double)BinocularsConfig.MAX_ZOOM.get()).floatValue();
    }

    private static float getZoomStep() {
        return ((Double)BinocularsConfig.ZOOM_STEP.get()).floatValue();
    }

    private static void ensureInitialized() {
        if (!isInitialized) {
            lastZoomLevel = BinocularsOverlay.getDefaultZoom();
            isInitialized = true;
        }
    }

    public static void startUsingBinoculars() {
        if (!isUsingBinoculars) {
            BinocularsOverlay.ensureInitialized();
            Minecraft mc = Minecraft.m_91087_();
            baseMouseSensitivity = Math.max((Double)mc.f_91066_.m_231964_().m_231551_(), 1.0E-5);
            isUsingBinoculars = true;
            currentZoom = lastZoomLevel;
            BinocularsOverlay.updateMouseSensitivity();
        }
    }

    public static void stopUsingBinoculars() {
        if (isUsingBinoculars) {
            lastZoomLevel = currentZoom;
            isUsingBinoculars = false;
            currentZoom = 1.0f;
            Minecraft mc = Minecraft.m_91087_();
            mc.f_91066_.m_231964_().m_231514_((Object)baseMouseSensitivity);
        }
    }

    private static boolean shouldShowOverlay() {
        Minecraft mc = Minecraft.m_91087_();
        return isUsingBinoculars && mc.f_91066_.m_92176_().m_90612_() && mc.f_91074_ != null && (mc.f_91074_.m_21205_().m_41720_() instanceof BinocularsItem || mc.f_91074_.m_21206_().m_41720_() instanceof BinocularsItem);
    }

    private static void updateMouseSensitivity() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_ != null && BinocularsOverlay.shouldShowOverlay()) {
            double sensitivityScale = 1.0 / (double)currentZoom;
            double newSensitivity = Math.max(baseMouseSensitivity * sensitivityScale, 1.0E-5);
            mc.f_91066_.m_231964_().m_231514_((Object)newSensitivity);
        } else if (mc.f_91066_ != null && isUsingBinoculars) {
            mc.f_91066_.m_231964_().m_231514_((Object)baseMouseSensitivity);
        }
    }

    private static String formatSensitivityText() {
        Minecraft mc = Minecraft.m_91087_();
        double currentSensitivity = (Double)mc.f_91066_.m_231964_().m_231551_();
        if (currentSensitivity < 1.0E-5 || baseMouseSensitivity < 1.0E-5) {
            return "Sensitivity: MIN";
        }
        double percentage = currentSensitivity / baseMouseSensitivity * 100.0;
        if (Double.isNaN(percentage) || Double.isInfinite(percentage)) {
            return "Sensitivity: MIN";
        }
        return String.format("Sensitivity: %.1f%%", percentage);
    }

    @SubscribeEvent
    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        if (BinocularsOverlay.shouldShowOverlay()) {
            float oldZoom = currentZoom;
            float zoomChange = (float)(event.getScrollDelta() * (double)BinocularsOverlay.getZoomStep());
            currentZoom = Math.max(BinocularsOverlay.getMinZoom(), Math.min(BinocularsOverlay.getMaxZoom(), currentZoom + zoomChange));
            if (oldZoom != currentZoom) {
                lastZoomLevel = currentZoom;
                BinocularsOverlay.updateMouseSensitivity();
            }
            event.setCanceled(true);
        }
    }

    private static void renderBinocularOverlay(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)OVERLAY_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(OVERLAY_TEXTURE, 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        RenderSystem.disableBlend();
    }

    private static void renderZoomLevel(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        String zoomText = String.format("Zoom: %.1fx", Float.valueOf(currentZoom));
        String sensitivityText = BinocularsOverlay.formatSensitivityText();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(1.0f, 1.0f, 1.0f);
        guiGraphics.m_280488_(mc.f_91062_, zoomText, 5, 5, 0xFFFFFF);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        guiGraphics.m_280488_(mc.f_91062_, sensitivityText, 10, 40, 0xFFFFFF);
        guiGraphics.m_280168_().m_85849_();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onComputeFov(ViewportEvent.ComputeFov event) {
        if (BinocularsOverlay.shouldShowOverlay()) {
            double fov = event.getFOV();
            event.setFOV(fov / (double)currentZoom);
        }
    }

    @SubscribeEvent
    public static void onRenderCrosshair(RenderGuiOverlayEvent.Pre event) {
        if (BinocularsOverlay.shouldShowOverlay() && event.getOverlay().id().toString().equals("minecraft:crosshair")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderHotbar(RenderGuiOverlayEvent.Pre event) {
        if (BinocularsOverlay.shouldShowOverlay() && event.getOverlay().id().toString().equals("minecraft:hotbar")) {
            event.setCanceled(true);
        }
    }

    public static float getCurrentZoom() {
        return currentZoom;
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (isUsingBinoculars) {
            BinocularsOverlay.updateMouseSensitivity();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && isUsingBinoculars) {
                boolean hasBinocularsEquipped;
                boolean bl = hasBinocularsEquipped = mc.f_91074_.m_21205_().m_41720_() instanceof BinocularsItem || mc.f_91074_.m_21206_().m_41720_() instanceof BinocularsItem;
                if (!hasBinocularsEquipped) {
                    BinocularsOverlay.stopUsingBinoculars();
                }
            }
        }
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register(BinocularsOverlay.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            event.registerAbove(ResourceLocation.m_135820_((String)"minecraft:hotbar"), "binoculars", BINOCULARS_OVERLAY);
            event.registerAboveAll("binoculars_text", BINOCULARS_TEXT_OVERLAY);
        });
    }

    static {
        isInitialized = false;
        BINOCULARS_OVERLAY = (gui, guiGraphics, partialTick, width, height) -> {
            if (BinocularsOverlay.shouldShowOverlay() && Minecraft.m_91087_().f_91074_ != null) {
                BinocularsOverlay.renderBinocularOverlay(guiGraphics);
            }
        };
        BINOCULARS_TEXT_OVERLAY = (gui, guiGraphics, partialTick, width, height) -> {
            if (BinocularsOverlay.shouldShowOverlay() && Minecraft.m_91087_().f_91074_ != null) {
                BinocularsOverlay.renderZoomLevel(guiGraphics);
            }
        };
    }
}

