/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.forge;

import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import uk.co.dotcode.asb.ASB;
import uk.co.dotcode.asb.ModUtils;
import uk.co.dotcode.asb.event.TooltipEvent;
import uk.co.dotcode.asb.event.WorldJoinEvent;

public class EventHandler {
    @SubscribeEvent
    public void loadComplete(FMLLoadCompleteEvent event) {
        ASB.init();
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getSide() == LogicalSide.SERVER && event.getTarget() instanceof LivingEntity) {
            ModUtils.checkAndApplyBonusesTo((LivingEntity)event.getEntity(), (LivingEntity)event.getTarget(), "interact");
        }
    }

    @SubscribeEvent
    public void playerAttack(AttackEntityEvent event) {
        if (event.getTarget() instanceof LivingEntity) {
            ModUtils.checkAndApplyBonusesTo((LivingEntity)event.getEntity(), (LivingEntity)event.getTarget(), "attack");
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void itemToolTip(ItemTooltipEvent event) {
        TooltipEvent.modifyTooltip(event.getEntity(), event.getItemStack().m_41720_(), event.getToolTip());
    }

    @SubscribeEvent
    public void onWorldLogin(PlayerEvent.PlayerLoggedInEvent event) {
        WorldJoinEvent.onWorldLogin(event.getEntity());
        ASB.sendConfigIssues(event.getEntity());
    }
}

