/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config.forge;

import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.curios.api.CuriosApi;
import uk.co.dotcode.asb.ModUtils;
import uk.co.dotcode.asb.config.AdditionalSetPiece;
import uk.co.dotcode.asb.config.SetPiece;

public class ArmorSetImpl {
    public static boolean armorSetMatchAdditional(LivingEntity entity, AdditionalSetPiece[] additionalSetPieces) {
        if (additionalSetPieces != null) {
            boolean allCuriosMatch = true;
            for (int i = 0; i < additionalSetPieces.length; ++i) {
                AdditionalSetPiece c = additionalSetPieces[i];
                if (ArmorSetImpl.curioMatches(entity, c)) continue;
                allCuriosMatch = false;
            }
            return allCuriosMatch;
        }
        return true;
    }

    public static int armorSetCountAdditional(LivingEntity entity, AdditionalSetPiece[] additionalSetPieces) {
        int count = 0;
        if (additionalSetPieces != null) {
            for (int i = 0; i < additionalSetPieces.length; ++i) {
                AdditionalSetPiece c = additionalSetPieces[i];
                if (!ArmorSetImpl.curioMatches(entity, c)) continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean isPartOfSetAdditional(String item, AdditionalSetPiece[] additionalSetPieces) {
        if (additionalSetPieces != null) {
            for (int i = 0; i < additionalSetPieces.length; ++i) {
                AdditionalSetPiece c = additionalSetPieces[i];
                if (!c.matchesSimple(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAdditionalValid(AdditionalSetPiece[] additionalSetPieces) {
        boolean valid = true;
        if (additionalSetPieces != null) {
            for (int i = 0; i < additionalSetPieces.length; ++i) {
                AdditionalSetPiece c = additionalSetPieces[i];
                if (!c.itemKey.isEmpty()) continue;
                valid = false;
            }
        }
        return valid;
    }

    public static boolean verifyAdditional(String armorSetName, AdditionalSetPiece[] additionalSetPieces) {
        boolean valid = true;
        if (additionalSetPieces != null) {
            for (int i = 0; i < additionalSetPieces.length; ++i) {
                AdditionalSetPiece c = additionalSetPieces[i];
                if (c.itemKey.isEmpty() || c.verify(armorSetName, "curios-" + c.itemKey)) continue;
                valid = false;
            }
        }
        return valid;
    }

    public static int getAdditionalPieceCount(AdditionalSetPiece[] additionalSetPieces) {
        int count = 0;
        if (additionalSetPieces != null) {
            count = additionalSetPieces.length;
        }
        return count;
    }

    public static boolean curioMatches(LivingEntity entity, SetPiece setPiece) {
        Optional optional = CuriosApi.getCuriosHelper().findFirstCurio(entity, ModUtils.getItem(setPiece.itemKey));
        if (optional.isPresent()) {
            return true;
        }
        if (setPiece.mixAndMatch != null && setPiece.mixAndMatch.length > 0) {
            for (String s : setPiece.mixAndMatch) {
                Optional optionalMix = CuriosApi.getCuriosHelper().findFirstCurio(entity, ModUtils.getItem(s));
                if (!optionalMix.isPresent()) continue;
                return true;
            }
        }
        return false;
    }
}

