/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config.conditions;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import uk.co.dotcode.asb.ComponentManager;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.ModUtils;
import uk.co.dotcode.asb.config.conditions.TriggerCondition;

public class ConditionOnBlock
extends TriggerCondition {
    private transient Block blockUnder = null;
    private transient MutableComponent component = null;

    public ConditionOnBlock(String blockKey, boolean inverted) {
        super("onblock", inverted);
        this.extra = blockKey;
        this.blockUnder = ModUtils.getBlock(this.extra.toLowerCase());
    }

    @Override
    public boolean conditionMet(LivingEntity e) {
        boolean result = false;
        boolean bl = result = e.m_9236_().m_8055_(e.m_20183_().m_7495_()).m_60734_() == this.blockUnder || e.m_9236_().m_8055_(e.m_20183_()).m_60734_() == this.blockUnder;
        return this.inverted ? !result : result;
    }

    @Override
    public boolean isValid() {
        if (this.extra == null || this.extra.isEmpty() || !this.extra.contains(":")) {
            ModLogger.warn("Invalid bonus condition: onblock," + this.extra + ". The 'extra' field has not been defined correctly (it must be a block key for this type).");
            return false;
        }
        this.blockUnder = ModUtils.getBlock(this.extra.toLowerCase());
        if (this.blockUnder == null) {
            ModLogger.warn("Invalid bonus condition: onblock, " + this.extra + ". The specified block does not exist.");
            return false;
        }
        return super.isValid();
    }

    @Override
    public MutableComponent translationText() {
        if (this.component == null) {
            if (this.tooltipDescription != null && !this.tooltipDescription.isEmpty()) {
                this.component = ComponentManager.createComponent(this.tooltipDescription, true);
            } else {
                this.component = this.inverted ? ComponentManager.mergeComponents(new Component[]{ComponentManager.not, ComponentManager.space}) : ComponentManager.empty;
                this.component = ComponentManager.mergeComponents(new Component[]{this.component, ComponentManager.conditionOnBlock, ComponentManager.space, ComponentManager.createComponent(this.blockUnder.m_7705_(), true)});
            }
        }
        return this.component;
    }
}

