/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config.conditions;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import uk.co.dotcode.asb.ComponentManager;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.ModUtils;
import uk.co.dotcode.asb.config.conditions.TriggerCondition;

public class ConditionMoonPhase
extends TriggerCondition {
    private transient MutableComponent component = null;

    public ConditionMoonPhase(String moonPhase, boolean inverted) {
        super("moonPhase", inverted);
        this.extra = moonPhase;
    }

    @Override
    public boolean conditionMet(LivingEntity e) {
        boolean result = false;
        if (e.m_9236_().m_46941_() == ModUtils.convertMoonPhaseToInt(this.extra)) {
            result = true;
        }
        return this.inverted ? !result : result;
    }

    @Override
    public boolean isValid() {
        if (this.extra == null || this.extra.isEmpty() || ModUtils.convertMoonPhaseToInt(this.extra) == -1) {
            ModLogger.warn("Invalid bonus condition: moonPhase," + this.extra + ". The 'extra' field has not been defined correctly. It must be a valid moon phase (see the wiki for guidance)");
            return false;
        }
        return super.isValid();
    }

    @Override
    public MutableComponent translationText() {
        if (this.component == null) {
            this.component = this.tooltipDescription != null && !this.tooltipDescription.isEmpty() ? ComponentManager.createComponent(this.tooltipDescription, true) : (this.inverted ? ComponentManager.mergeComponents(new Component[]{ComponentManager.moonPhaseComponentStartNot, this.getPhaseTextComponent(), ComponentManager.moonPhaseComponentEnd}) : ComponentManager.mergeComponents(new Component[]{ComponentManager.moonPhaseComponentStart, this.getPhaseTextComponent(), ComponentManager.moonPhaseComponentEnd}));
        }
        return this.component;
    }

    private Component getPhaseTextComponent() {
        switch (this.extra.toLowerCase()) {
            default: {
                return ComponentManager.emptyError;
            }
            case "full": {
                return ComponentManager.moonPhaseDescriptionFull;
            }
            case "waninggibbous": {
                return ComponentManager.moonPhaseDescriptionWaningGibbous;
            }
            case "lastquarter": {
                return ComponentManager.moonPhaseDescriptionLastQuarter;
            }
            case "waningcresent": {
                return ComponentManager.moonPhaseDescriptionWaningCresent;
            }
            case "new": {
                return ComponentManager.moonPhaseDescriptionNew;
            }
            case "waxingcresent": {
                return ComponentManager.moonPhaseDescriptionWaxingCresent;
            }
            case "firstquarter": {
                return ComponentManager.moonPhaseDescriptionFirstQuarter;
            }
            case "waxinggibbous": 
        }
        return ComponentManager.moonPhaseDescriptionWaxingGibbous;
    }
}

