/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config.conditions;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import uk.co.dotcode.asb.ComponentManager;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.config.conditions.TriggerCondition;

public class ConditionInDimension
extends TriggerCondition {
    private transient MutableComponent component = null;

    public ConditionInDimension(String dimensionKey, boolean inverted) {
        super("indimension", inverted);
        this.extra = dimensionKey;
    }

    @Override
    public boolean conditionMet(LivingEntity e) {
        boolean result = false;
        if (e.m_9236_().m_46472_().m_135782_().toString().equalsIgnoreCase(this.extra)) {
            result = true;
        }
        return this.inverted ? !result : result;
    }

    @Override
    public boolean isValid() {
        if (this.extra == null || this.extra.isEmpty() || !this.extra.contains(":")) {
            ModLogger.warn("Invalid bonus condition: indimension," + this.extra + ". The 'extra' field has not been defined correctly (it must be a dimension key for this type).");
            return false;
        }
        return super.isValid();
    }

    @Override
    public MutableComponent translationText() {
        if (this.tooltipDescription != null && !this.tooltipDescription.isEmpty()) {
            return ComponentManager.createComponent(this.tooltipDescription, true);
        }
        if (this.component == null) {
            this.component = this.inverted ? ComponentManager.mergeComponents(new Component[]{ComponentManager.not, ComponentManager.space}) : ComponentManager.empty;
            this.component = ComponentManager.mergeComponents(new Component[]{this.component, ComponentManager.conditionInDimension, ComponentManager.space, ComponentManager.createComponent(this.extra.split(":")[1], false)});
        }
        return this.component;
    }
}

