/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.config.ArmorSet;
import uk.co.dotcode.asb.config.Bonus;
import uk.co.dotcode.asb.config.SetPiece;

public class DefaultArmorSets {
    public static ArmorSet leather;
    public static ArmorSet iron;
    public static ArmorSet gold;
    public static ArmorSet diamond;
    public static ArmorSet netherite;

    public static void generateDefaultConfigs(File folder) {
        leather = new ArmorSet("leather", "minecraft:leather_helmet", "minecraft:leather_chestplate", "minecraft:leather_leggings", "minecraft:leather_boots");
        DefaultArmorSets.leather.fullSetBonuses = new Bonus[1];
        DefaultArmorSets.leather.fullSetBonuses[0] = new Bonus("attribute", "minecraft:generic.armor", 3).setUUID("d5a7dc88-9405-4398-b1e5-250b4c6dd218");
        DefaultArmorSets.leather.fullSetBonuses[0].description = "+3 armor";
        SetPiece ironHeadSet = new SetPiece("minecraft:iron_helmet");
        ironHeadSet.mixAndMatch = new String[1];
        ironHeadSet.mixAndMatch[0] = "minecraft:chainmail_helmet";
        SetPiece ironChestSet = new SetPiece("minecraft:iron_chestplate");
        ironChestSet.mixAndMatch = new String[1];
        ironChestSet.mixAndMatch[0] = "minecraft:chainmail_chestplate";
        SetPiece ironLegsSet = new SetPiece("minecraft:iron_leggings");
        ironLegsSet.mixAndMatch = new String[1];
        ironLegsSet.mixAndMatch[0] = "minecraft:chainmail_leggings";
        SetPiece ironBootsSet = new SetPiece("minecraft:iron_boots");
        ironBootsSet.mixAndMatch = new String[1];
        ironBootsSet.mixAndMatch[0] = "minecraft:chainmail_boots";
        iron = new ArmorSet("iron", ironHeadSet, ironChestSet, ironLegsSet, ironBootsSet);
        DefaultArmorSets.iron.fullSetBonuses = new Bonus[1];
        DefaultArmorSets.iron.fullSetBonuses[0] = new Bonus("effect", "minecraft:strength", 0);
        gold = new ArmorSet("gold", "minecraft:golden_helmet", "minecraft:golden_chestplate", "minecraft:golden_leggings", "minecraft:golden_boots");
        DefaultArmorSets.gold.fullSetBonuses = new Bonus[1];
        DefaultArmorSets.gold.fullSetBonuses[0] = new Bonus("effect", "minecraft:haste", 1);
        diamond = new ArmorSet("diamond", "minecraft:diamond_helmet", "minecraft:diamond_chestplate", "minecraft:diamond_leggings", "minecraft:diamond_boots");
        DefaultArmorSets.diamond.fullSetBonuses = new Bonus[1];
        DefaultArmorSets.diamond.fullSetBonuses[0] = new Bonus("attribute", "minecraft:generic.max_health", 4);
        DefaultArmorSets.diamond.fullSetBonuses[0].modifierUUID = "d5a7dc88-9405-4398-b1e5-250b4c6dd218";
        DefaultArmorSets.diamond.fullSetBonuses[0].attributeOperation = 0;
        DefaultArmorSets.diamond.fullSetBonuses[0].description = "+2 hearts";
        netherite = new ArmorSet("netherite", "minecraft:netherite_helmet", "minecraft:netherite_chestplate", "minecraft:netherite_leggings", "minecraft:netherite_boots");
        DefaultArmorSets.netherite.fullSetBonuses = new Bonus[1];
        DefaultArmorSets.netherite.fullSetBonuses[0] = new Bonus("effect", "minecraft:fire_resistance", 0);
        DefaultArmorSets.netherite.partialBonusRequiredAmount = 2;
        DefaultArmorSets.netherite.partialSetBonuses = new Bonus[1];
        DefaultArmorSets.netherite.partialSetBonuses[0] = new Bonus("effect", "minecraft:resistance", 0);
        ArrayList<ArmorSet> armorSets = new ArrayList<ArmorSet>();
        armorSets.add(leather);
        armorSets.add(iron);
        armorSets.add(gold);
        armorSets.add(diamond);
        armorSets.add(netherite);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (ArmorSet as : armorSets) {
            File exportPath = new File(folder, as.armorSetName + ".json");
            try (FileWriter writer = new FileWriter(exportPath);){
                gson.toJson((Object)as, (Appendable)writer);
            }
            catch (IOException e) {
                ModLogger.warn("Failed to create file for defaultarmorset: " + as.armorSetName + ": " + String.valueOf(exportPath));
                e.printStackTrace();
            }
        }
    }
}

