/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import uk.co.dotcode.asb.ComponentManager;
import uk.co.dotcode.asb.ModLogger;
import uk.co.dotcode.asb.ModUtils;
import uk.co.dotcode.asb.config.conditions.TriggerCondition;

public class Bonus {
    public String type;
    public String name;
    public float value;
    public String modifierUUID;
    public String description;
    public Integer attributeOperation;
    public String interactionType;
    public Integer interactionDuration;
    public boolean hideBonusDescription = false;
    public boolean onlyImmuneToNewEffects = false;
    public float percentageChance = 100.0f;
    public TriggerCondition[] conditions;
    private transient MutableComponent conditionsComponent;

    public Bonus(String type, String name, int value) {
        this();
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public Bonus() {
        if (this.interactionType == null || this.interactionType == "") {
            this.interactionType = "self";
        }
        if (this.interactionDuration == null || this.interactionDuration <= 0) {
            this.interactionDuration = 300;
        }
    }

    public void applyBonus(LivingEntity entity, String targetInteractionType) {
        if (this.interactionType.equalsIgnoreCase(targetInteractionType)) {
            boolean shouldApply = false;
            shouldApply = this.percentageChance > 0.0f && this.percentageChance < 100.0f ? ModUtils.random.nextFloat() < this.percentageChance / 100.0f : true;
            if (shouldApply) {
                if (this.type.equalsIgnoreCase("effect")) {
                    if (entity.m_21023_(this.getBonusEffectInstance().m_19544_())) {
                        if (entity.f_19797_ % 90 == 0) {
                            entity.m_7292_(this.getBonusEffectInstance());
                        }
                    } else {
                        entity.m_7292_(this.getBonusEffectInstance());
                    }
                } else if (this.type.equalsIgnoreCase("attribute") && entity instanceof Player) {
                    Attribute a = ModUtils.getAttribute(this.name);
                    Player player = (Player)entity;
                    AttributeModifier.Operation amOperation = this.attributeOperation != null ? AttributeModifier.Operation.m_22236_((int)this.attributeOperation) : AttributeModifier.Operation.ADDITION;
                    AttributeModifier am = new AttributeModifier(UUID.fromString(this.modifierUUID), this.name, (double)this.value, amOperation);
                    if (player.m_21051_(a) != null) {
                        if (!player.m_21051_(a).m_22109_(am)) {
                            player.m_21051_(a).m_22118_(am);
                        }
                    } else {
                        ModLogger.warn("Failed to find attribute " + this.name);
                    }
                }
            }
        }
    }

    public void applyImmunity(LivingEntity entity) {
        MobEffect e;
        if (this.interactionType.equalsIgnoreCase("immunity") && entity.m_21023_(e = ModUtils.getMobEffect(this.name)) && !this.onlyImmuneToNewEffects) {
            entity.m_21195_(e);
        }
    }

    public void removeBonus(LivingEntity entity, String targetInteractionType) {
        if (this.interactionType.equalsIgnoreCase(targetInteractionType) && this.type.equalsIgnoreCase("attribute") && entity instanceof Player) {
            Attribute a = ModUtils.getAttribute(this.name);
            Player player = (Player)entity;
            AttributeModifier.Operation amOperation = this.attributeOperation != null ? AttributeModifier.Operation.m_22236_((int)this.attributeOperation) : AttributeModifier.Operation.ADDITION;
            AttributeModifier am = new AttributeModifier(UUID.fromString(this.modifierUUID), this.name, (double)this.value, amOperation);
            if (player.m_21051_(a) != null) {
                if (player.m_21051_(a).m_22109_(am)) {
                    player.m_21051_(a).m_22120_(UUID.fromString(this.modifierUUID));
                }
            } else {
                ModLogger.warn("Failed to find attribute " + this.name);
            }
        }
    }

    public boolean conditionsMet(LivingEntity entity) {
        if (this.conditions != null && this.conditions.length > 0) {
            for (int i = 0; i < this.conditions.length; ++i) {
                if (this.conditions[i].conditionMet(entity)) continue;
                return false;
            }
        }
        return true;
    }

    public MobEffectInstance getBonusEffectInstance() {
        if (this.type.equalsIgnoreCase("effect")) {
            return new MobEffectInstance(ModUtils.getMobEffect(this.name), this.interactionDuration.intValue(), (int)this.value, false, false, true);
        }
        return null;
    }

    public boolean isValid(String armorSetName) {
        if (this.type.equalsIgnoreCase("effect")) {
            MobEffect effect = ModUtils.getMobEffect(this.name);
            if (effect == null) {
                ModLogger.warn(armorSetName + ": Invalid effect - " + this.name);
                return false;
            }
        } else if (this.type.equalsIgnoreCase("attribute")) {
            Attribute attribute = ModUtils.getAttribute(this.name);
            if (attribute == null) {
                ModLogger.warn(armorSetName + ": Invalid bonus - " + this.type + " - the attribute is invalid");
                return false;
            }
            try {
                UUID.fromString(this.modifierUUID);
            }
            catch (IllegalArgumentException e) {
                ModLogger.warn(armorSetName + ": Invalid bonus - the modifierUUID is invalid - be sure to use the right formatting and that it is unique");
                return false;
            }
        } else if (!this.type.equalsIgnoreCase("immunity")) {
            ModLogger.warn(armorSetName + ": Invalid bonus type - " + this.type);
            return false;
        }
        if (!(this.interactionType.equalsIgnoreCase("self") || this.interactionType.equalsIgnoreCase("attack") || this.interactionType.equalsIgnoreCase("interact") || this.interactionType.equalsIgnoreCase("immunity") || this.interactionType.equalsIgnoreCase("aoe"))) {
            ModLogger.warn(armorSetName + ": Invalid bonus - " + this.type + " - the interactionType is invalid - it can only be: 'self', 'attack', 'interact', 'immunity', 'aoe'.");
            return false;
        }
        if (this.conditions != null && this.conditions.length > 0) {
            boolean validConditions = true;
            for (int i = 0; i < this.conditions.length; ++i) {
                this.conditions[i] = this.conditions[i].parse();
                if (this.conditions[i].isValid()) continue;
                validConditions = false;
            }
            return validConditions;
        }
        return true;
    }

    public MutableComponent getConditionsComponent() {
        if (this.conditions != null && this.conditions.length > 0) {
            if (this.conditionsComponent == null) {
                this.conditionsComponent = ComponentManager.mergeComponents(new Component[]{ComponentManager.space, ComponentManager.when, ComponentManager.space});
                for (int i = 0; i < this.conditions.length; ++i) {
                    if (i > 0 && i != this.conditions.length) {
                        this.conditionsComponent = ComponentManager.mergeComponents(new Component[]{this.conditionsComponent, ComponentManager.comma});
                    } else if (i == this.conditions.length) {
                        this.conditionsComponent = ComponentManager.mergeComponents(new Component[]{this.conditionsComponent, ComponentManager.space, ComponentManager.and, ComponentManager.space});
                    }
                    this.conditionsComponent = ComponentManager.mergeComponents(new Component[]{this.conditionsComponent, this.conditions[i].parse().translationText()});
                }
            }
            return this.conditionsComponent;
        }
        return ComponentManager.empty;
    }

    public MutableComponent getInteractionTypeComponent() {
        switch (this.interactionType.toLowerCase()) {
            case "self": {
                return ComponentManager.interactionSelf;
            }
            case "attack": {
                return ComponentManager.interactionAttack;
            }
            case "interact": {
                return ComponentManager.interactionInteract;
            }
            case "immunity": {
                return ComponentManager.interactionImmunity;
            }
            case "aoe": {
                return ComponentManager.interactionAoe;
            }
        }
        return ComponentManager.emptyError;
    }

    public Bonus setUUID(String uuid) {
        this.modifierUUID = uuid;
        return this;
    }
}

