/*
 * Decompiled with CFR 0.152.
 */
package be.florens.expandability.mixin.swimming;

import be.florens.expandability.EventDispatcher;
import be.florens.expandability.EventResult;
import be.florens.expandability.Util;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyExpressionValue(method={"aiStep"}, require=2, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getFluidHeight(Lnet/minecraft/tags/TagKey;)D")})
    private double setFluidHeight(double original) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            Player player = (Player)livingEntityMixin;
            EventResult shouldSwim = EventDispatcher.onPlayerSwim(player);
            return Util.processEventResult(shouldSwim, Double.valueOf(1.0), Double.valueOf(0.0), original);
        }
        return original;
    }

    @ModifyExpressionValue(method={"travel", "aiStep", "checkFallDamage"}, require=3, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWater()Z")})
    private boolean setInWater(boolean original) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player) {
            Player player = (Player)livingEntityMixin;
            return Util.processEventResult(EventDispatcher.onPlayerSwim(player), original);
        }
        return original;
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    private void resetFallHeight(CallbackInfo info) {
        Player player;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && EventDispatcher.onPlayerSwim(player = (Player)livingEntityMixin) == EventResult.SUCCESS) {
            this.f_19789_ = 0.0f;
        }
    }

    @ModifyExpressionValue(method={"travel"}, allow=2, require=2, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isFree(DDD)Z")})
    private boolean cancelLeaveFluidAssist(boolean original) {
        Player player;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof Player && EventDispatcher.onPlayerSwim(player = (Player)livingEntityMixin) == EventResult.SUCCESS) {
            return false;
        }
        return original;
    }
}

