/*
 * Decompiled with CFR 0.152.
 */
package settingdust.lazyyyyy.forge.core;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import settingdust.lazyyyyy.forge.core.LazyyyyyHacksInjector;
import settingdust.lazyyyyy.forge.core.faster_mixin.ConfigurationReflection;
import settingdust.lazyyyyy.forge.core.faster_mixin.ModuleClassLoaderReflection;
import settingdust.lazyyyyy.forge.core.faster_mixin.ModuleLayerReflection;
import settingdust.lazyyyyy.forge.core.faster_mixin.ModuleReflection;
import settingdust.lazyyyyy.forge.core.faster_mixin.ResolvedModuleReflection;
import settingdust.lazyyyyy.shadow.reflect.Agents;

public class ClassLoaderInjector {
    private static final Path SELF_PATH = (Path)LamdbaExceptionUtils.uncheck(() -> {
        URL jarLocation = ClassLoaderInjector.class.getProtectionDomain().getCodeSource().getLocation();
        return Path.of(jarLocation.toURI());
    });

    public static void injectBootstrap() throws IOException {
        LazyyyyyHacksInjector.LOGGER.info("Injecting bootstrap");
        Path bootstrapJarPath = SELF_PATH.resolve("lazyyyyy-lexforge-bootstrap.jar");
        Path exportedJarPath = Paths.get(".lazyyyyy", "lazyyyyy-lexforge-bootstrap.jar");
        if (Files.notExists(exportedJarPath, new LinkOption[0])) {
            try {
                Files.createDirectory(exportedJarPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Files.copy(bootstrapJarPath, exportedJarPath, new CopyOption[0]);
        }
        JarFile bootstrapJar = new JarFile(exportedJarPath.toFile());
        try {
            Instrumentation instrumentation;
            try {
                instrumentation = Agents.getInstrumentation();
            }
            catch (Throwable t) {
                LazyyyyyHacksInjector.LOGGER.debug("No dummy agent, the bootstrap jar can't be injected", t);
                bootstrapJar.close();
                return;
            }
            instrumentation.appendToBootstrapClassLoaderSearch(bootstrapJar);
        }
        finally {
            try {
                bootstrapJar.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public static void injectMcBootstrap() {
        LazyyyyyHacksInjector.LOGGER.info("Injecting mc bootstrap");
        Path mcBootstrapJar = SELF_PATH.resolve("lazyyyyy-lexforge-mc-bootstrap.jar");
        SecureJar mixinJar = SecureJar.from((Path[])new Path[]{mcBootstrapJar});
        JarModuleFinder jarModuleFinder = JarModuleFinder.of((SecureJar[])new SecureJar[]{mixinJar});
        ModuleClassLoader mcBootClassLoader = (ModuleClassLoader)Launcher.class.getClassLoader();
        Configuration bootConfiguration = ModuleClassLoaderReflection.getConfiguration(mcBootClassLoader);
        Configuration configuration = bootConfiguration.resolve((ModuleFinder)jarModuleFinder, (ModuleFinder)JarModuleFinder.of((SecureJar[])new SecureJar[0]), Set.of("lazyyyyy.lexforge.mc.bootstrap"));
        ResolvedModule resolvedModule = configuration.findModule("lazyyyyy.lexforge.mc.bootstrap").orElseThrow();
        ClassLoaderInjector.mergeConfigurations(bootConfiguration, configuration);
        ModuleLayer moduleLayer = (ModuleLayer)Launcher.INSTANCE.findLayerManager().flatMap(it -> it.getLayer(IModuleLayerManager.Layer.BOOT)).orElseThrow();
        Module module = ModuleReflection.construct(moduleLayer, (ClassLoader)mcBootClassLoader, resolvedModule.reference().descriptor(), resolvedModule.reference().location().orElse(null));
        ModuleLayerReflection.getNameToModule(moduleLayer).put(resolvedModule.name(), module);
        ClassLoaderInjector.class.getModule().addReads(module);
        for (ResolvedModule resolvedModule2 : ConfigurationReflection.getGraph(configuration).get(resolvedModule)) {
            ModuleReflection.implAddRead(module, moduleLayer.findModule(resolvedModule2.name()).orElseThrow());
        }
        ResolvedModuleReflection.setConfiguration(resolvedModule, bootConfiguration);
        HashMap<String, ResolvedModule> packageLookup = new HashMap<String, ResolvedModule>(ModuleClassLoaderReflection.getPackageLookup(mcBootClassLoader));
        for (String pkg : mixinJar.getPackages()) {
            packageLookup.put(pkg, resolvedModule);
        }
        ModuleClassLoaderReflection.setPackageLookup(mcBootClassLoader, new HashMap<String, ResolvedModule>(packageLookup));
        HashMap<String, ModuleReference> hashMap = new HashMap<String, ModuleReference>(ModuleClassLoaderReflection.getResolvedRoots(mcBootClassLoader));
        hashMap.put(resolvedModule.reference().descriptor().name(), resolvedModule.reference());
        ModuleClassLoaderReflection.setResolvedRoots(mcBootClassLoader, new HashMap<String, ModuleReference>(hashMap));
    }

    private static void mergeConfigurations(Configuration to, Configuration from) {
        ConfigurationReflection.getGraph(to).putAll(ConfigurationReflection.getGraph(from));
        HashSet<ResolvedModule> modules = new HashSet<ResolvedModule>(ConfigurationReflection.getModules(to));
        modules.addAll(ConfigurationReflection.getModules(from));
        ConfigurationReflection.setModules(to, modules);
        HashMap<String, ResolvedModule> nameToModule = new HashMap<String, ResolvedModule>(ConfigurationReflection.getNameToModule(to));
        nameToModule.putAll(ConfigurationReflection.getNameToModule(from));
        ConfigurationReflection.setNameToModule(to, nameToModule);
    }
}

