/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class Config {
    public static final Common COMMON;
    public static final ForgeConfigSpec commonSpec;
    private static final HashMap<GameRules.Key<?>, String> COMMENTS;
    private static final Converter<String, String> RULE_CONVERTER;

    static {
        COMMENTS = new HashMap();
        RULE_CONVERTER = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE);
        COMMENTS.put(GameRules.f_46131_, "Whether fire should spread and naturally extinguish");
        COMMENTS.put(GameRules.f_46132_, "Whether creepers, zombies, endermen, ghasts, withers, ender dragons, rabbits, sheep, villagers, silverfish, snow golems, and end crystals should be able to change blocks, and whether mobs can pick up items. When mobGriefing is disabled, piglins do not pick up gold ingots, but a player can still barter with them by using the item on the mob. Similarly, villagers do not pick up food items but can still breed until they run out of any food already in their inventory. This also affects the capability of zombie-like creatures like zombified piglins and drowned to pathfind to turtle eggs.");
        COMMENTS.put(GameRules.f_46133_, "Whether the player should keep items and experience in their inventory after death .");
        COMMENTS.put(GameRules.f_46134_, "Whether mobs should naturally spawn. Does not affect monster spawners.");
        COMMENTS.put(GameRules.f_46135_, "Whether mobs should drop items and experience orbs.");
        COMMENTS.put(GameRules.f_46136_, "Whether blocks should have drops.");
        COMMENTS.put(GameRules.f_46137_, "Whether entities that are not mobs should have drops.");
        COMMENTS.put(GameRules.f_46138_, "Whether command blocks should notify admins when they perform commands.");
        COMMENTS.put(GameRules.f_46139_, "Whether the player can regenerate health naturally if their hunger is full enough (doesn't affect external healing, such as golden apples, the Regeneration effect, etc.)");
        COMMENTS.put(GameRules.f_46140_, "Whether the daylight cycle and moon phases progress.");
        COMMENTS.put(GameRules.f_46141_, "Whether to log admin commands to server log.");
        COMMENTS.put(GameRules.f_46142_, "Whether death messages are put into chat when a player dies. Also affects whether a message is sent to the pet's owner when the pet dies.");
        COMMENTS.put(GameRules.f_46143_, "How often a random block tick occurs (such as plant growth, leaf decay, etc.) per chunk section per game tick. 0 and negative values disables random ticks, higher numbers increase random ticks. Setting to a high integer results in high speeds of decay and growth. Numbers over 4096 make plant growth or leaf decay instantaneous.");
        COMMENTS.put(GameRules.f_46144_, "Whether the feedback from commands executed by a player should show up in chat. Also affects the default behavior of whether command blocks store their output text.");
        COMMENTS.put(GameRules.f_46145_, "Whether the debug screen shows all or reduced information; and whether the effects of F3+B (entity hitboxes) and F3+G (chunk boundaries) are shown.");
        COMMENTS.put(GameRules.f_46146_, "Whether players in spectator mode can generate chunks");
        COMMENTS.put(GameRules.f_46147_, "The number of blocks outward from the world spawn coordinates that a player spawns in when first joining a server or when dying without a personal spawnpoint. Has no effect on servers where the default game mode is Adventure.");
        COMMENTS.put(GameRules.f_46148_, "Whether the server should skip checking player speed when the player is wearing elytra. Often helps with jittering due to lag in multiplayer.");
        COMMENTS.put(GameRules.f_46149_, "The maximum number of pushable entities a mob or player can push, before taking 6 (\u2665\u2665\u2665) entity cramming damage per half-second. Setting to 0 or lower disables the rule. Damage affects Survival-mode or Adventure-mode players, and all mobs but bats. Pushable entities include non-Spectator-mode players, any mob except bats, as well as boats and minecarts.");
        COMMENTS.put(GameRules.f_46150_, "Whether the weather can change naturally. The /weather command can still change weather.");
        COMMENTS.put(GameRules.f_46151_, "Whether players can craft only those recipes that they have unlocked.");
        COMMENTS.put(GameRules.f_46152_, "The maximum length of a chain of commands that can be executed during one tick. Applies to command blocks and functions.");
        COMMENTS.put(GameRules.f_263760_, "Controls the maximum number of blocks changed when using /clone, /fill, or /fillbiome.");
        COMMENTS.put(GameRules.f_46153_, "Whether advancements should be announced in chat.");
        COMMENTS.put(GameRules.f_46154_, "Whether raids are disabled.");
        COMMENTS.put(GameRules.f_46155_, "Whether phantoms can spawn in the nighttime.");
        COMMENTS.put(GameRules.f_46156_, "Players respawn immediately without showing the death screen.");
        COMMENTS.put(GameRules.f_46121_, "Whether the player should take damage when drowning.");
        COMMENTS.put(GameRules.f_46122_, "Whether the player should take fall damage.");
        COMMENTS.put(GameRules.f_46123_, "Whether the player should take damage in fire, lava, campfires, or on magma blocks.");
        COMMENTS.put(GameRules.f_151485_, "Whether the player should take damage when inside powder snow.");
        COMMENTS.put(GameRules.f_46124_, "Whether patrols can spawn.");
        COMMENTS.put(GameRules.f_46125_, "Whether wandering traders can spawn.");
        COMMENTS.put(GameRules.f_220347_, "Whether wardens can spawn.");
        COMMENTS.put(GameRules.f_46126_, "Makes angered neutral mobs stop being angry when the targeted player dies nearby.");
        COMMENTS.put(GameRules.f_46127_, "Makes angered neutral mobs attack any nearby player, not just the player that angered them. Works best if forgiveDeadPlayers is disabled.");
        COMMENTS.put(GameRules.f_151486_, "What percentage of players must sleep to skip the night.");
        COMMENTS.put(GameRules.f_254629_, "Whether block loot is dropped by all blocks (false) or randomly (true) depending on how far the block is from the center of a block explosion (e.g. clicking a bed in dimensions other than the Overworld).");
        COMMENTS.put(GameRules.f_254692_, "Whether block loot is dropped by all blocks (false) or randomly (true) depending on how far the block is from the center of a mob explosion (e.g. Creeper explosion).");
        COMMENTS.put(GameRules.f_254705_, "Whether block loot is dropped by all blocks (false) or randomly (true) depending on how far the block is from the center of a TNT explosion.");
        COMMENTS.put(GameRules.f_254637_, "The maximum number of snow layers that can be accumulated on each block.");
        COMMENTS.put(GameRules.f_254725_, "Whether new sources of water are allowed to form.");
        COMMENTS.put(GameRules.f_254672_, "Whether new sources of lava are allowed to form.");
        COMMENTS.put(GameRules.f_254630_, "Whether certain sound events are heard by all players regardless of location.");
        COMMENTS.put(GameRules.f_268705_, "Whether vines can spread to other blocks. Cave vines, weeping vines, and twisting vines are not affected.");
        Pair configSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)configSpecPair.getRight();
        COMMON = (Common)configSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue setDifficulty;
        public final ForgeConfigSpec.EnumValue<Difficulty> difficulty;
        public final ForgeConfigSpec.BooleanValue enforceHardcore;
        public final ForgeConfigSpec.BooleanValue hardcore;
        public final ForgeConfigSpec.BooleanValue lockDifficulty;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> defaultCommands;
        public final ForgeConfigSpec.BooleanValue saveGameRules;
        public final ForgeConfigSpec.BooleanValue useAsDefaultsOnly;
        public final ForgeConfigSpec.ConfigValue<com.electronwill.nightconfig.core.Config> modGameRules;
        public final Map<GameRules.Key<?>, ForgeConfigSpec.ConfigValue<?>> gameRules;

        Common(final ForgeConfigSpec.Builder builder) {
            builder.comment("Gamerules that are set when a world is loaded").push("gamerules");
            this.gameRules = new HashMap();
            GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

                public <T extends GameRules.Value<T>> void m_6889_(// Could not load outer class - annotation placement on inner may be incorrect
                @NotNull GameRules.Key<T> key, // Could not load outer class - annotation placement on inner may be incorrect
                @NotNull GameRules.Type<T> type) {
                    GameRules.Value t = type.m_46352_();
                    String name = (String)RULE_CONVERTER.convert((Object)key.m_46328_());
                    if (name != null && (t instanceof GameRules.BooleanValue || t instanceof GameRules.IntegerValue)) {
                        String comment = COMMENTS.get(key);
                        if (comment == null) {
                            return;
                        }
                        String category = key.m_46332_().toString().toLowerCase();
                        builder.push(category);
                        ForgeConfigSpec.Builder ruleBuilder = builder.comment(comment);
                        if (t instanceof GameRules.BooleanValue) {
                            GameRules.BooleanValue booleanValue = (GameRules.BooleanValue)t;
                            gameRules.put(key, (ForgeConfigSpec.ConfigValue<?>)ruleBuilder.define(name, booleanValue.m_46223_()));
                        } else {
                            gameRules.put(key, (ForgeConfigSpec.ConfigValue<?>)ruleBuilder.defineInRange(name, ((GameRules.IntegerValue)t).m_46288_(), Integer.MIN_VALUE, Integer.MAX_VALUE));
                        }
                        builder.pop();
                    }
                }
            });
            this.modGameRules = builder.comment(new String[]{"Modded gamerules", "The modded gamerules should be populated after loading the game, only integer and boolean values are valid"}).define("modded", this::getDefaultModdedGamerules, this::validateModdedGamerules);
            builder.pop().comment("Configs related to difficulty changes").push("difficulty");
            this.setDifficulty = builder.comment(new String[]{"If the difficulty should be set on world load", "If true difficulty changes in game will also be saved to the config"}).define("set_difficulty", false);
            this.difficulty = builder.comment("The difficulty to set if 'set_difficulty' is true, respects if the difficulty is locked or not for the world").defineEnum("difficulty", (Enum)Difficulty.NORMAL);
            this.enforceHardcore = builder.comment(new String[]{"If true the 'hardcore' setting is enforced", "If false the 'hardcore' setting isn't checked against the setting of a world"}).define("enforce_hardcore", true);
            this.hardcore = builder.comment(new String[]{"If true the world will be set to hardcore, difficultly will be set to hard independent to the 'difficulty' config", "Setting it to hardcore auto locks the difficulty while this is true"}).define("hardcore", false);
            this.lockDifficulty = builder.comment(new String[]{"If a world's difficulty should be locked when loaded, if world already is locked it can't be changed", "If the global world difficulty is enabled it's set first"}).define("lock_difficulty", false);
            builder.pop().comment("A collection of misc configs").push("misc");
            this.saveGameRules = builder.comment("If gamerules should be saved to config on world unload").define("save_gamerules", true);
            this.useAsDefaultsOnly = builder.comment(new String[]{"If gamerules and settings only should be used as the defaults when creating a world", "This will also block saving of changes to the config"}).define("use_as_defaults_only", false);
            this.defaultCommands = builder.comment(new String[]{"A comma separated list of commands to run on world join, @p is replaced with joining player name, command is run by the server", "Example: default_commands = [\"/tellraw @p [\\\"\\\",{\\\"text\\\":\\\"Hi \\\"},{\\\"text\\\":\\\"@p\\\",\\\"color\\\":\\\"aqua\\\"}]\"]"}).defineList("default_commands", ArrayList::new, o -> !Strings.isNullOrEmpty((String)String.valueOf(o)) && String.valueOf(o).startsWith("/"));
            builder.pop();
        }

        private com.electronwill.nightconfig.core.Config getDefaultModdedGamerules() {
            return com.electronwill.nightconfig.core.Config.inMemory();
        }

        private boolean validateModdedGamerules(Object obj) {
            if (obj instanceof com.electronwill.nightconfig.core.Config) {
                com.electronwill.nightconfig.core.Config config = (com.electronwill.nightconfig.core.Config)obj;
                return config.isEmpty() || config.valueMap().values().stream().allMatch(o -> {
                    com.electronwill.nightconfig.core.Config cfg;
                    return o instanceof Integer || o instanceof Boolean || o instanceof com.electronwill.nightconfig.core.Config && this.validateModdedGamerules(cfg = (com.electronwill.nightconfig.core.Config)o);
                });
            }
            return false;
        }

        public boolean updateModdedGamerules(final GameRules rules) {
            final com.electronwill.nightconfig.core.Config cfg = (com.electronwill.nightconfig.core.Config)this.modGameRules.get();
            final boolean hasRules = rules != null;
            final AtomicBoolean dirty = new AtomicBoolean(false);
            GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

                public <T extends GameRules.Value<T>> void m_6889_(@NotNull GameRules.Key<T> key, @NotNull GameRules.Type<T> type) {
                    block7: {
                        GameRules.IntegerValue iVal;
                        String name;
                        block8: {
                            GameRules.Value t;
                            Object old;
                            block5: {
                                GameRules.BooleanValue bVal;
                                block6: {
                                    if (COMMENTS.containsKey(key)) {
                                        return;
                                    }
                                    String category = key.m_46332_().toString().toLowerCase();
                                    name = category + "." + key.m_46328_();
                                    old = cfg.get(name);
                                    if (old != null && !hasRules) {
                                        return;
                                    }
                                    t = rules != null ? rules.m_46170_(key) : type.m_46352_();
                                    if (!(t instanceof GameRules.BooleanValue)) break block5;
                                    bVal = (GameRules.BooleanValue)t;
                                    if (old == null) break block6;
                                    if (!(old instanceof Boolean)) break block5;
                                    Boolean oldBool = (Boolean)old;
                                    if (bVal.m_46223_() == oldBool.booleanValue()) break block5;
                                }
                                cfg.set(name, (Object)bVal.m_46223_());
                                dirty.set(true);
                                break block7;
                            }
                            if (!(t instanceof GameRules.IntegerValue)) break block7;
                            iVal = (GameRules.IntegerValue)t;
                            if (old == null) break block8;
                            if (!(old instanceof Integer)) break block7;
                            Integer oldInt = (Integer)old;
                            if (iVal.m_46288_() == oldInt.intValue()) break block7;
                        }
                        cfg.set(name, (Object)iVal.m_46288_());
                        dirty.set(true);
                    }
                }
            });
            if (dirty.get() && !hasRules) {
                commonSpec.save();
            }
            return dirty.get();
        }
    }
}

