/*
 * Decompiled with CFR 0.152.
 */
package dev.tr3ymix.cfm_wap.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.ElectricitySourceLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.NodeSearchResult;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import dev.tr3ymix.cfm_wap.Config;
import dev.tr3ymix.cfm_wap.block.CircuitBreakerBlock;
import dev.tr3ymix.cfm_wap.blockentity.CircuitBreakerCache;
import dev.tr3ymix.cfm_wap.blockentity.IProcessingCircuitBreakerBlock;
import dev.tr3ymix.cfm_wap.energy.CommonEnergyStorage;
import dev.tr3ymix.cfm_wap.inventory.CircuitBreakerMenu;
import dev.tr3ymix.cfm_wap.registry.ModBlockEntities;
import dev.tr3ymix.cfm_wap.util.Utils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CircuitBreakerBlockEntity
extends ElectricitySourceLootBlockEntity
implements IProcessingCircuitBreakerBlock,
IPowerSwitch {
    protected final Vec3 centerPosition;
    protected boolean enabled;
    protected int nodeCount;
    protected final ContainerData data = new BuildableContainerData(builder -> {
        builder.add(Integer.valueOf(0), this::getEnergy, value -> {});
        builder.add(Integer.valueOf(1), this::getMaxEnergy, value -> {});
        builder.add(Integer.valueOf(2), () -> this.enabled ? 1 : 0, value -> {});
        builder.add(Integer.valueOf(3), () -> this.overloaded ? 1 : 0, value -> {});
        builder.add(Integer.valueOf(4), () -> this.isNodePowered() ? 1 : 0, value -> {});
        builder.add(Integer.valueOf(5), () -> this.nodeCount, value -> {});
    });
    public final CommonEnergyStorage ENERGY_STORAGE = new CommonEnergyStorage(1000, 50);
    int ENERGY_RATE = 10;

    public CircuitBreakerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.CIRCUIT_BREAKER.get(), pos, state);
    }

    public CircuitBreakerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 1);
        this.centerPosition = pos.m_252807_();
    }

    public int getNodeMaximumConnections() {
        return (Integer)Config.SERVER.electricity.maximumLinksPerCircuitBreaker.get();
    }

    @NotNull
    protected Component m_6820_() {
        return Utils.translation("container", "circuit_breaker", new Object[0]);
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int i, Inventory inventory) {
        if (!this.enabled) {
            this.searchNodeNetwork(false);
        }
        return new CircuitBreakerMenu(i, inventory, (Container)this, this.data);
    }

    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        if (menu instanceof CircuitBreakerMenu) {
            CircuitBreakerMenu circuitBreaker = (CircuitBreakerMenu)menu;
            return circuitBreaker.getContainer() == this;
        }
        return false;
    }

    public boolean isNodePowered() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)CircuitBreakerBlock.POWERED) ? (Boolean)state.m_61143_((Property)CircuitBreakerBlock.POWERED) : false;
    }

    public void setNodePowered(boolean powered) {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)CircuitBreakerBlock.POWERED)) {
            assert (this.f_58857_ != null);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)CircuitBreakerBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    public void togglePower() {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            NodeSearchResult result = this.searchNodeNetwork(false);
            if (!result.overloaded()) {
                if (this.overloaded) {
                    this.overloaded = false;
                }
            } else {
                this.enabled = false;
            }
        }
        this.m_6596_();
    }

    public void onNodeOverloaded() {
        this.enabled = false;
        this.m_6596_();
    }

    public NodeSearchResult searchNodeNetwork(boolean cancelAtLimit) {
        List nodes = IElectricityNode.searchNodes((IElectricityNode)this, (int)((Integer)Config.SERVER.electricity.maximumNodesInCircuitBreakerNetwork.get()), (boolean)cancelAtLimit, node -> !node.isSourceNode() && node.canPowerTraverseNode(), node -> !node.isSourceNode());
        boolean overloaded = nodes.size() > (Integer)Config.SERVER.electricity.maximumNodesInCircuitBreakerNetwork.get();
        NodeSearchResult result = new NodeSearchResult(overloaded, nodes);
        this.nodeCount = result.nodes().size();
        return result;
    }

    public int getEnergy() {
        return this.ENERGY_STORAGE.getEnergy();
    }

    @Override
    public int getMaxEnergy() {
        return this.ENERGY_STORAGE.getCapacity();
    }

    @Override
    public int getEnergyRate() {
        return this.ENERGY_RATE;
    }

    public void addEnergy(int amount) {
        this.ENERGY_STORAGE.setEnergy(amount);
        this.m_6596_();
    }

    @Override
    public void removeEnergy(int amount) {
        this.ENERGY_STORAGE.extractEnergy(amount, false);
    }

    public boolean requiresEnergy() {
        return true;
    }

    public int retrieveEnergy(boolean simulate) {
        if (!simulate) {
            return this.ENERGY_STORAGE.insertEnergy(this.ENERGY_RATE, false);
        }
        return 0;
    }

    public int updateAndGetTotalProcessingTime() {
        return this.getTotalProcessingTime();
    }

    public int getTotalProcessingTime() {
        return 1;
    }

    public int getProcessingTime() {
        return 0;
    }

    public void setProcessingTime(int time) {
        if (this.isNodePowered()) {
            if (time == 0) {
                this.setNodePowered(false);
            }
        } else if (time == 1) {
            this.setNodePowered(true);
        }
    }

    public void onCompleteProcess() {
    }

    public boolean canProcess() {
        return this.enabled && !this.isNodeOverloaded();
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (!level.f_46443_) {
            CircuitBreakerCache.add(level, this.m_58899_());
        }
    }

    public void m_7651_() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            CircuitBreakerCache.remove(this.f_58857_, this.m_58899_());
        }
        super.m_7651_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Enabled", 1)) {
            this.enabled = tag.m_128471_("Enabled");
        }
        if (tag.m_128425_("Energy", 3)) {
            this.ENERGY_STORAGE.setEnergy(tag.m_128451_("Energy"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Enabled", this.enabled);
        tag.m_128405_("Energy", this.ENERGY_STORAGE.getEnergy());
    }

    public void earlyNodeTick(Level level) {
        if (!level.f_46443_) {
            this.processTick();
        }
        super.earlyNodeTick(level);
    }

    public void onOpen(Level level, BlockPos pos, BlockState state) {
        level.m_6263_(null, this.centerPosition.f_82479_, this.centerPosition.f_82480_, this.centerPosition.f_82481_, (SoundEvent)ModSounds.BLOCK_STOVE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.f_46441_.m_188501_());
        this.setDoorState(state, true);
    }

    public void onClose(Level level, BlockPos pos, BlockState state) {
        level.m_6263_(null, this.centerPosition.f_82479_, this.centerPosition.f_82480_, this.centerPosition.f_82481_, (SoundEvent)ModSounds.BLOCK_MICROWAVE_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 0.9f + 0.1f * level.f_46441_.m_188501_());
        this.setDoorState(state, false);
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.m_58904_();
        if (level != null) {
            level.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)CircuitBreakerBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

