/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.BaseWeapons;

import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsMutations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.Nullable;

public interface SporeWeaponData {
    public static final String BASE_TAG = "agent";
    public static final String MELEE_TAG = "mutant_damage";
    public static final String MELEE_DURABILITY = "mutant_durability";
    public static final String MAX_DURABILITY = "mutant_max_durability";
    public static final String ENCHANTING = "mutant_enchanting";
    public static final String MUTATION = "mutation";

    default public boolean tooHurt(ItemStack stack) {
        return stack.m_41773_() < stack.m_41776_() - 10;
    }

    default public double calculateTrueDamage(ItemStack stack, double meleeDamage) {
        double value = this.getAdditionalDamage(stack) * 0.01;
        if (value > 0.0) {
            return meleeDamage + meleeDamage * value;
        }
        return meleeDamage;
    }

    default public void setAdditionalDamage(double value, ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        tag.m_128347_(MELEE_TAG, value);
    }

    default public double getAdditionalDamage(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41698_(BASE_TAG);
        return tag.m_128459_(MELEE_TAG);
    }

    default public int getMaxAdditionalDurability(ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        return tag.m_128451_(MAX_DURABILITY);
    }

    default public void setMaxAdditionalDurability(int value, ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        tag.m_128405_(MAX_DURABILITY, value);
    }

    default public int getAdditionalDurability(ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        return tag.m_128451_(MELEE_DURABILITY);
    }

    default public void setAdditionalDurability(int value, ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        tag.m_128405_(MELEE_DURABILITY, value);
    }

    default public void hurtTool(ItemStack stack, LivingEntity entity, int value) {
        int lostDurability = this.calculateDurabilityLostForMutations(value, stack);
        if (this.getAdditionalDurability(stack) > 0) {
            this.hurtExtraDurability(stack, lostDurability, entity);
        } else {
            stack.m_41622_(lostDurability, entity, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    default public int calculateDurabilityLostForMutations(int value, ItemStack stack) {
        if (this.getVariant(stack) == SporeToolsMutations.TOXIC) {
            return value * 2;
        }
        if (this.getVariant(stack) == SporeToolsMutations.ROTTEN) {
            return value * 2;
        }
        return value;
    }

    default public void hurtExtraDurability(ItemStack stack, int value, @Nullable LivingEntity living) {
        this.setAdditionalDurability(this.getAdditionalDurability(stack) - value, stack);
    }

    default public void setLuck(int value, ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        tag.m_128347_(ENCHANTING, (double)value);
    }

    default public int getLuck(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41698_(BASE_TAG);
        return tag.m_128451_(ENCHANTING);
    }

    default public SporeToolsMutations getVariant(ItemStack stack) {
        return SporeToolsMutations.byId(this.getTypeVariant(stack) & 0xFF);
    }

    default public int getTypeVariant(ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        return tag.m_128451_(MUTATION);
    }

    default public void setVariant(SporeToolsMutations variant, ItemStack stack) {
        CompoundTag tag = stack.m_41698_(BASE_TAG);
        tag.m_128405_(MUTATION, variant.getId() & 0xFF);
    }

    default public boolean doesExtraKnockBack() {
        return false;
    }

    default public boolean reversedKnockback() {
        return false;
    }

    default public void doEntityHurtAfterEffects(ItemStack stack, LivingEntity victim, LivingEntity entity) {
        if (this.reversedKnockback()) {
            victim.m_147240_((double)1.2f, (double)(-Mth.m_14031_((float)(entity.m_146908_() * ((float)Math.PI / 180)))), (double)Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180))));
        }
        if (this.doesExtraKnockBack()) {
            victim.m_147240_((double)2.2f, (double)Mth.m_14031_((float)(entity.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180)))));
        }
        if (this.getVariant(stack) == SporeToolsMutations.TOXIC) {
            victim.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 1));
        }
        if (this.getVariant(stack) == SporeToolsMutations.ROTTEN) {
            victim.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 1));
        }
        if (this.getVariant(stack) == SporeToolsMutations.CALCIFIED) {
            victim.f_19864_ = true;
            double knockback = this.reversedKnockback() ? (double)(-Mth.m_14031_((float)(entity.m_146908_() * ((float)Math.PI / 180)))) : (double)Mth.m_14031_((float)(entity.m_146908_() * ((float)Math.PI / 180)));
            double knockback2 = this.reversedKnockback() ? (double)Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180) * ((float)Math.PI / 180))) : (double)(-Mth.m_14089_((float)(entity.m_146908_() * ((float)Math.PI / 180))));
            victim.m_147240_(1.5, knockback, knockback2);
        }
        if (this.getVariant(stack) == SporeToolsMutations.VAMPIRIC && entity.m_21223_() < entity.m_21233_()) {
            entity.m_5634_(2.0f);
        }
        if (this.getVariant(stack) == SporeToolsMutations.BEZERK && Math.random() < 0.3) {
            if (Math.random() < 0.5) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 0));
            } else if (Math.random() < 0.5) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 60, 0));
            } else {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 60, 0));
            }
        }
    }

    default public double modifyDamage(ItemStack stack, double value) {
        float sharpness = (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)stack) * 0.5f + 1.0f;
        return (double)sharpness + (this.getVariant(stack) == SporeToolsMutations.VAMPIRIC ? this.calculateTrueDamage(stack, value) * -0.2 : 0.0);
    }

    default public double modifyRange(ItemStack stack) {
        return 0.0;
    }

    default public double modifyRecharge(ItemStack stack) {
        return this.getVariant(stack) == SporeToolsMutations.CALCIFIED ? -0.5 : 0.0;
    }

    default public int getMaxTrueAdditionalDurability(ItemStack stack) {
        return (int)((double)stack.m_41776_() * ((double)this.getMaxAdditionalDurability(stack) * 0.01));
    }

    default public void healTool(ItemStack stack, int value) {
        if (stack.m_41773_() < stack.m_41776_()) {
            stack.m_41721_(stack.m_41773_() - value);
        }
        if (this.getMaxTrueAdditionalDurability(stack) > this.getAdditionalDurability(stack)) {
            this.setAdditionalDurability(this.getAdditionalDurability(stack) + value, stack);
        }
    }

    default public void abstractMutationBuffs(LivingEntity victim, LivingEntity owner, ItemStack stack, SporeWeaponData data) {
        if (data.getVariant(stack) == SporeToolsMutations.TOXIC) {
            victim.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 1));
        }
        if (data.getVariant(stack) == SporeToolsMutations.ROTTEN) {
            victim.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 1));
        }
        if (data.getVariant(stack) == SporeToolsMutations.VAMPIRIC && owner.m_21223_() < owner.m_21233_()) {
            owner.m_5634_(2.0f);
        }
        if (data.getVariant(stack) == SporeToolsMutations.BEZERK && Math.random() < 0.3) {
            if (Math.random() < 0.5) {
                owner.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, 0));
            } else if (Math.random() < 0.5) {
                owner.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 60, 0));
            } else {
                owner.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 60, 0));
            }
        }
    }
}

