/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Ssounds;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class NukeEntity
extends Entity {
    private static final EntityDataAccessor<Float> INIT_RANGE = SynchedEntityData.m_135353_(NukeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> RANGE = SynchedEntityData.m_135353_(NukeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> INIT_DURATION = SynchedEntityData.m_135353_(NukeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(NukeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(NukeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public Predicate<LivingEntity> livingEntityPredicate = entity -> true;

    public NukeEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.setInitRange(1.0f);
        this.setRange(6.0f);
        this.setInitDuration(0);
        this.setDuration(600);
        this.setDamage(10.0f);
    }

    public void setInitRange(float value) {
        this.f_19804_.m_135381_(INIT_RANGE, (Object)Float.valueOf(value));
    }

    public void setRange(float value) {
        this.f_19804_.m_135381_(RANGE, (Object)Float.valueOf(value));
    }

    public void setInitDuration(int value) {
        this.f_19804_.m_135381_(INIT_DURATION, (Object)value);
    }

    public void setDuration(int value) {
        this.f_19804_.m_135381_(DURATION, (Object)value);
    }

    public void setDamage(float value) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(value));
    }

    public float getInitRange() {
        return ((Float)this.f_19804_.m_135370_(INIT_RANGE)).floatValue();
    }

    public float getRange() {
        return ((Float)this.f_19804_.m_135370_(RANGE)).floatValue();
    }

    public int getInitDuration() {
        return (Integer)this.f_19804_.m_135370_(INIT_DURATION);
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(DURATION);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(INIT_RANGE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(RANGE, (Object)Float.valueOf(6.0f));
        this.f_19804_.m_135372_(INIT_DURATION, (Object)0);
        this.f_19804_.m_135372_(DURATION, (Object)600);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(10.0f));
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.setInitRange(compoundTag.m_128457_("init_range"));
        this.setRange(compoundTag.m_128457_("range"));
        this.setInitDuration(compoundTag.m_128451_("init_duration"));
        this.setDuration(compoundTag.m_128451_("duration"));
        this.setDamage(compoundTag.m_128457_("damage"));
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128350_("init_range", this.getInitRange());
        compoundTag.m_128350_("range", this.getRange());
        compoundTag.m_128405_("init_duration", this.getInitDuration());
        compoundTag.m_128405_("duration", this.getDuration());
        compoundTag.m_128350_("damage", this.getDamage());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            this.calculateRange();
            if (this.getInitDuration() >= this.getDuration()) {
                this.m_146870_();
            }
            if (this.f_19797_ % 10 == 0) {
                this.hurtEntities();
                this.damageAround(this.m_9236_(), this.getInitRange() + 4.0f, this.m_20097_());
            }
            if (this.getInitDuration() == 1) {
                this.playNukeSound();
            }
        }
        super.m_8119_();
    }

    private void calculateRange() {
        int remainingDuration;
        if (this.getDuration() > this.getInitDuration()) {
            this.setInitDuration(this.getInitDuration() + 1);
        }
        if ((remainingDuration = this.getDuration() - this.getInitDuration()) > 0) {
            this.setInitRange(this.getInitRange() + this.getRange() / (float)remainingDuration);
        } else {
            this.setInitRange(this.getInitRange());
        }
    }

    public void hurtEntities() {
        AABB aabb = this.m_20191_().m_82400_((double)(this.getInitRange() + 5.0f));
        List entities = this.m_9236_().m_6249_((Entity)this, aabb, entity -> entity instanceof LivingEntity);
        for (Entity entity2 : entities) {
            LivingEntity living;
            if (!(entity2 instanceof LivingEntity) || !this.livingEntityPredicate.test(living = (LivingEntity)entity2)) continue;
            living.m_20254_(10);
            this.addEffect(living);
            living.m_6469_(this.m_269291_().m_269387_(), this.getDamage());
            living.f_20916_ = 10;
            living.f_19802_ = 10;
        }
    }

    public void addEffect(LivingEntity living) {
        if (ModList.get().isLoaded("alexscaves")) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("alexscaves:irradiated"));
            if (effect != null) {
                living.m_7292_(new MobEffectInstance(effect, 1200, 1));
            }
        } else {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 1200, 1));
        }
    }

    public void playNukeSound() {
        AABB aabb = this.m_20191_().m_82400_(32.0);
        List players = this.m_9236_().m_6249_((Entity)this, aabb, entity -> entity instanceof ServerPlayer);
        for (Entity entity2 : players) {
            if (!(entity2 instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)entity2;
            serverPlayer.m_6330_((SoundEvent)Ssounds.NUKE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    private void damageAround(Level level, double range, BlockPos pos) {
        int i = 0;
        while ((double)i <= 2.0 * range) {
            int j = 0;
            while ((double)j <= 2.0 * range) {
                int k = 0;
                while ((double)k <= 2.0 * range) {
                    double distance = Mth.m_14116_((float)((float)(((double)i - range) * ((double)i - range) + ((double)j - range) * ((double)j - range) + ((double)k - range) * ((double)k - range))));
                    if (distance < range + 0.5) {
                        BlockPos blockpos = pos.m_7918_(i - (int)range, j - (int)range, k - (int)range);
                        BlockState blockstate = level.m_8055_(blockpos);
                        if (blockstate.m_60713_(Blocks.f_49990_)) {
                            level.m_46597_(blockpos, Blocks.f_50016_.m_49966_());
                        } else if (Math.random() < 0.1 && blockstate.m_60804_((BlockGetter)level, blockpos) && level.m_8055_(blockpos.m_7494_()).m_60795_()) {
                            BlockState state = Math.random() < 0.5 ? Blocks.f_50083_.m_49966_() : ((Block)Sblocks.ACID.get()).m_49966_();
                            level.m_7731_(blockpos.m_7494_(), state, 3);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

