/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.EvolvedInfected;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.Carrier;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class Howler
extends EvolvedInfected {
    private boolean scream;

    public Howler(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    @Override
    protected void addRegularGoals() {
        super.addRegularGoals();
        this.f_21345_.m_25352_(2, (Goal)new HowlerAttackGoal((Mob)this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.how_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.how_damage.get() * (Double)SConfig.SERVER.global_damage.get()).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.how_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22282_, 3.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.INF_PILLAGER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public void m_8119_() {
        if (this.m_6084_() && this.scream) {
            this.m_216990_((SoundEvent)Ssounds.HOWLER_GROWL.get());
            this.scream = false;
        }
        super.m_8119_();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.inf_howler_loot.get();
    }

    public void ScreamAOE(Entity origin) {
        AABB area = origin.m_20191_().m_82400_(12.0);
        List targets = origin.m_9236_().m_6249_(origin, area, EntitySelector.f_20406_);
        for (Entity target : targets) {
            if (target instanceof Infected) {
                Infected infected = (Infected)target;
                infected.m_7292_(new MobEffectInstance((MobEffect)Seffects.MARKER.get(), 400, 0));
                continue;
            }
            if (!(target instanceof Player)) continue;
            Player player = (Player)target;
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0));
        }
    }

    public void ScreamBuffInfected(Entity origin) {
        AABB area = origin.m_20191_().m_82400_(6.0);
        List allies = origin.m_9236_().m_45933_(origin, area);
        int duration = switch (origin.m_9236_().m_46791_()) {
            case Difficulty.EASY -> 100;
            case Difficulty.NORMAL -> 200;
            case Difficulty.HARD -> 400;
            default -> 0;
        };
        int amplifier = origin.m_9236_().m_46791_() == Difficulty.HARD ? 1 : 0;
        List buffs = (List)SConfig.SERVER.howler_effects_buff.get();
        String randomBuff = (String)buffs.get(this.f_19796_.m_188503_(buffs.size()));
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(randomBuff));
        if (effect != null) {
            for (Entity ally : allies) {
                if (!(ally instanceof Infected)) continue;
                Infected infected = (Infected)ally;
                infected.m_7292_(new MobEffectInstance(effect, duration, amplifier));
            }
        }
        this.scream = true;
    }

    public void SummonScream(LivingEntity caster) {
        Mob summoned;
        ServerLevelAccessor levelAccessor = (ServerLevelAccessor)caster.m_9236_();
        Level level = caster.m_9236_();
        int dx = this.f_19796_.m_216339_(-8, 9);
        int dz = this.f_19796_.m_216339_(-8, 9);
        int dy = this.f_19796_.m_216339_(0, 2);
        List summonPool = (List)SConfig.SERVER.howler_summon.get();
        String chosen = (String)summonPool.get(this.f_19796_.m_188503_(summonPool.size()));
        ResourceLocation entityId = new ResourceLocation(chosen);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
        if (entityType != null && (summoned = (Mob)entityType.m_20615_(level)) != null) {
            summoned.m_246847_(caster.m_20185_() + (double)dx, caster.m_20186_() + 0.5 + (double)dy, caster.m_20189_() + (double)dz);
            summoned.m_6518_(levelAccessor, level.m_6436_(BlockPos.m_274446_((Position)caster.m_20182_())), MobSpawnType.NATURAL, null, null);
            level.m_7967_((Entity)summoned);
            this.scream = true;
        }
    }

    public boolean checkForInfected(Entity origin) {
        AABB area = origin.m_20191_().m_82400_(4.0);
        List nearby = origin.m_9236_().m_6249_(origin, area, EntitySelector.f_20406_);
        for (Entity entity : nearby) {
            if (!(entity instanceof Infected) || ((List)SConfig.SERVER.support.get()).contains(entity.m_20078_()) || entity instanceof Carrier) continue;
            return true;
        }
        return false;
    }

    private class HowlerAttackGoal
    extends Goal {
        private final Mob mob;
        private final double speed;
        private int screamTimer = 0;

        private HowlerAttackGoal(Mob mob, double speedModifier) {
            this.mob = mob;
            this.speed = speedModifier;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null;
        }

        public void m_8037_() {
            LivingEntity target;
            if (this.screamTimer > 0) {
                --this.screamTimer;
            }
            if ((target = this.mob.m_5448_()) == null) {
                return;
            }
            this.mob.m_21563_().m_24960_((Entity)target, 10.0f, (float)this.mob.m_8132_());
            double dist = this.mob.m_20280_((Entity)target);
            if (dist > 120.0) {
                this.mob.m_21573_().m_5624_((Entity)target, this.speed);
            } else if (this.screamTimer <= 0) {
                if (Howler.this.checkForInfected((Entity)this.mob)) {
                    Howler.this.ScreamAOE((Entity)this.mob);
                    Howler.this.ScreamBuffInfected((Entity)this.mob);
                } else {
                    int summons = Howler.this.f_19796_.m_216339_(1, 3);
                    for (int i = 0; i < summons; ++i) {
                        Howler.this.SummonScream((LivingEntity)this.mob);
                    }
                }
                this.screamTimer = 120;
            }
        }
    }
}

