/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.Calamities.Hohlfresser;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;

public class HohlMultipart
extends CalamityMultipart {
    private final Vec3 desiredLocation;
    private final float inflation;

    public HohlMultipart(Calamity parent, String name, float s, float s2, Vec3 desiredLocation, float inflation) {
        super(parent, name, s, s2);
        this.desiredLocation = desiredLocation;
        this.inflation = inflation;
        this.m_20219_(parent.m_20182_());
    }

    public Vec3 calculateSpinVector(Vec3 spin) {
        float yaw = 0.0f;
        Calamity calamity = this.parentMob;
        if (calamity instanceof Hohlfresser) {
            Hohlfresser f = (Hohlfresser)calamity;
            yaw = f.getBufferedYRot();
        } else {
            yaw = this.parentMob.m_146908_();
        }
        return spin.m_82524_(-yaw * ((float)Math.PI / 180) - 1.5707964f);
    }

    public float getInflation() {
        return this.inflation;
    }

    public Vec3 calculatedLocation(Vec3 localOffset) {
        Vec3 vec3 = this.calculateSpinVector(localOffset);
        return new Vec3(this.parentMob.m_20185_() + vec3.f_82479_, this.parentMob.m_20186_() + vec3.f_82480_, this.parentMob.m_20189_() + vec3.f_82481_);
    }

    public Vec3 getDesiredLocation() {
        return this.desiredLocation;
    }

    public void tickMovement(int time, int segmentIndex, @Nullable HohlMultipart previousSegment) {
        Vec3 targetPos;
        if (this.m_20182_().equals((Object)Vec3.f_82478_)) {
            this.m_20219_(this.parentMob.m_20182_());
        }
        float frequency = 0.15f;
        float amplitude = 0.2f;
        float wave = (float)Math.sin((float)time * frequency - (float)segmentIndex * 0.5f) * amplitude;
        Vec3 waveOffset = new Vec3(0.0, (double)wave, 0.0);
        Vec3 idealPos = this.calculatedLocation(this.desiredLocation).m_82549_(waveOffset);
        if (previousSegment != null) {
            float followStrength = 0.35f;
            targetPos = idealPos.m_165921_(previousSegment.m_20182_(), (double)followStrength);
        } else {
            targetPos = idealPos;
        }
        double maxDistance = 2.5;
        if (this.m_20182_().m_82554_(targetPos) > maxDistance) {
            this.m_20219_(targetPos);
        } else {
            float smoothFactor = 0.1f + (float)segmentIndex * 0.1f;
            this.m_20219_(this.m_20182_().m_165921_(targetPos, (double)smoothFactor));
        }
    }
}

