/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sblocks;

import com.Harbinger.Spore.Core.SblockEntities;
import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.SBlockEntities.CDUBlockEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CDUBlock
extends BaseEntityBlock {
    public CDUBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60913_(6.0f, 20.0f));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CDUBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_214162_(BlockState state, Level level, BlockPos blockPos, RandomSource randomSource) {
        CDUBlockEntity blockEntity;
        super.m_214162_(state, level, blockPos, randomSource);
        BlockEntity entity = level.m_7702_(blockPos);
        if (entity instanceof CDUBlockEntity && (blockEntity = (CDUBlockEntity)entity).getFuel() > 0) {
            for (int i = 0; i < 360; ++i) {
                if (i % 20 != 0) continue;
                double yy = Math.sin(i) * Math.cos(i) * 0.25;
                level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, (double)blockPos.m_123341_() + 0.47, (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_() + 0.47, Math.cos(i) * 0.15, yy, Math.sin(i) * 0.15);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(world, pos);
        return CDUBlock.m_49796_((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)16.0, (double)15.9).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        super.m_6227_(state, level, pos, player, hand, result);
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof CDUBlockEntity) {
            CDUBlockEntity blockEntity = (CDUBlockEntity)entity;
            ItemStack item = player.m_21120_(hand);
            if (item.m_41720_() == Sitems.ICE_CANISTER.get()) {
                if (blockEntity.getFuel() > 0) {
                    player.m_5661_((Component)Component.m_237113_((String)("Current fuel " + blockEntity.getFuel() + "/" + blockEntity.maxFuel)), true);
                } else {
                    level.m_245747_(pos, (SoundEvent)Ssounds.CDU_INSERT.get(), SoundSource.BLOCKS, 2.0f, 2.0f, true);
                    level.m_245747_(pos, (SoundEvent)Ssounds.CDU_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
                    blockEntity.setFuel(blockEntity.maxFuel);
                    item.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!level.f_46443_) {
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)blockEntity, (BlockPos)pos);
                    return InteractionResult.SUCCESS;
                }
            }
            player.m_5661_((Component)Component.m_237113_((String)("Current fuel " + blockEntity.getFuel() + "/" + blockEntity.maxFuel)), true);
        }
        return InteractionResult.SUCCESS;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState p_153274_, BlockEntityType<T> type) {
        return CDUBlock.createCDUTicker(level, type, (BlockEntityType<? extends CDUBlockEntity>)((BlockEntityType)SblockEntities.CDU.get()));
    }

    public int getEntityFuel(Level level, BlockPos pos) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof CDUBlockEntity) {
            CDUBlockEntity blockEntity = (CDUBlockEntity)entity;
            return blockEntity.getFuel();
        }
        return 0;
    }

    @javax.annotation.Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createCDUTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends CDUBlockEntity> p_151990_) {
        return level.f_46443_ ? null : CDUBlock.m_152132_(type, p_151990_, CDUBlockEntity::serverTick);
    }

    public void setFuelTag(ItemStack stack, int value) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("fuel", value);
    }

    public int getFuelTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_("fuel");
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_5871_(stack, getter, components, tooltipFlag);
        components.add((Component)Component.m_237115_((String)"cdu.line").m_130940_(ChatFormatting.BLUE));
        components.add(((Item)Sitems.ICE_CANISTER.get()).m_41466_());
        components.add((Component)Component.m_237113_((String)(this.getFuelTag(stack) + "/12000")).m_130940_(ChatFormatting.DARK_BLUE));
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setFuelTag(stack, this.getEntityFuel(level, pos));
        ItemEntity item = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
        level.m_7967_((Entity)item);
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CDUBlockEntity) {
            CDUBlockEntity cduBlockEntity = (CDUBlockEntity)blockEntity;
            CompoundTag tag = stack.m_41784_();
            cduBlockEntity.setFuel(tag.m_128451_("fuel"));
        }
    }
}

