/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.Core.SblockEntities;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Recipes.SurgeryRecipe;
import com.Harbinger.Spore.Screens.SurgeryMenu;
import com.Harbinger.Spore.Sitems.Agents.MutationAgents;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorData;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurgeryTableBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(21);
    public final TagKey<Item> stringLikeItem = ItemTags.create((ResourceLocation)new ResourceLocation("spore:stitches"));
    public static final int STRING_SLOT = 16;
    public static final int AGENT_SLOT_1 = 17;
    public static final int AGENT_SLOT_2 = 18;
    public static final int AGENT_SLOT_3 = 19;
    public static final int OUTPUT_SLOT = 20;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new SimpleContainerData(20);

    public SurgeryTableBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)SblockEntities.SURGERY_TABLE_ENTITY.get(), p_155229_, p_155230_);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"spore.surgery_table_menu");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory inventory, Player player) {
        return new SurgeryMenu(pContainerId, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void drops() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public Optional<SurgeryRecipe> getCurrentRecipe() {
        Optional recipe;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < 16; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional optional = recipe = this.f_58857_ != null ? this.f_58857_.m_7465_().m_44015_((RecipeType)SurgeryRecipe.SurgeryRecipeType.INSTANCE, (Container)inventory, this.f_58857_) : null;
        if (recipe.isPresent()) {
            System.out.println("Found matching recipe: " + ((SurgeryRecipe)recipe.get()).m_6423_());
        } else {
            System.out.println("No matching recipe found.");
        }
        return recipe;
    }

    public void consumeItems() {
        Optional<SurgeryRecipe> match = this.getCurrentRecipe();
        match.ifPresent(recipe -> {
            for (int i = 0; i < 16; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                this.itemHandler.extractItem(i, 1, false);
            }
            this.itemHandler.extractItem(16, 1, false);
        });
        if (this.f_58857_ != null) {
            this.f_58857_.m_245747_(this.m_58899_(), (SoundEvent)Ssounds.SURGERY.get(), SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    public void assembleWeapon(Player player, ItemStack stack) {
        int mutation = 15;
        int[] e = new int[]{17, 18, 19};
        ArrayList<MutationAgents> mutagens = new ArrayList<MutationAgents>();
        for (int i : e) {
            ItemStack itemStack = this.itemHandler.getStackInSlot(i);
            Item item = itemStack.m_41720_();
            if (!(item instanceof MutationAgents)) continue;
            MutationAgents mutationAgents = (MutationAgents)item;
            mutagens.add(mutationAgents);
            itemStack.m_41774_(1);
        }
        if (stack.m_41720_() instanceof SporeWeaponData || stack.m_41720_() instanceof SporeArmorData) {
            Item item;
            Object item2;
            Item item3;
            Object object = mutagens.iterator();
            while (object.hasNext()) {
                MutationAgents mutagen = (MutationAgents)((Object)object.next());
                mutagen.mutateWeapon(stack);
                mutation += mutagen.getMutationChance();
            }
            if (Math.random() < (double)mutation * 0.01 && (item3 = stack.m_41720_()) instanceof SporeWeaponData) {
                item2 = (SporeWeaponData)item3;
                item2.setVariant(SporeToolsMutations.byId(player.m_217043_().m_188503_(SporeToolsMutations.values().length)), stack);
            }
            if (Math.random() < (double)mutation * 0.01 && (item = stack.m_41720_()) instanceof SporeArmorData) {
                item2 = (SporeArmorData)item;
                item2.setVariant(SporeArmorMutations.byId(player.m_217043_().m_188503_(SporeArmorMutations.values().length)), stack);
            }
            stack.m_41721_(player.m_217043_().m_188503_(stack.m_41776_()));
        }
    }

    public boolean canInsertIntoOutputSlot(ItemStack stack) {
        ItemStack outputStack = this.itemHandler.getStackInSlot(20);
        return outputStack.m_41619_();
    }

    public void updateOutputSlot() {
        if (this.itemHandler.getStackInSlot(16) == ItemStack.f_41583_) {
            this.itemHandler.setStackInSlot(20, ItemStack.f_41583_);
            return;
        }
        Optional<SurgeryRecipe> match = this.getCurrentRecipe();
        if (match.isPresent()) {
            ItemStack stack = match.get().m_8043_(null);
            if (this.canInsertIntoOutputSlot(stack)) {
                this.itemHandler.insertItem(20, stack.m_41777_(), false);
            }
        } else {
            this.itemHandler.setStackInSlot(20, ItemStack.f_41583_);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SurgeryTableBlockEntity entity) {
        entity.updateOutputSlot();
    }
}

