/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.SblockEntities;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Screens.CDUMenu;
import com.Harbinger.Spore.Sentities.Utility.InfectionTendril;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CDUBlockEntity
extends BlockEntity
implements MenuProvider {
    public final int maxFuel;
    public int fuel;
    private final List<StoreDouble> blockMap;
    private final List<BlockState> biomass;

    public CDUBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SblockEntities.CDU.get(), pos, state);
        this.maxFuel = (Integer)SConfig.DATAGEN.cryo_time.get();
        this.blockMap = this.fabricateBlocks();
        this.biomass = this.stateList();
    }

    private List<StoreDouble> fabricateBlocks() {
        ArrayList<StoreDouble> blocks = new ArrayList<StoreDouble>();
        for (String str : (List)SConfig.DATAGEN.block_cleaning.get()) {
            String[] string = str.split("\\|");
            Block blockCon1 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string[0]));
            Block blockCon2 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string[1]));
            if (blockCon1 == null || blockCon2 == null) continue;
            blocks.add(new StoreDouble(blockCon1, blockCon2));
        }
        return blocks;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("fuel", this.getFuel());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setFuel(tag.m_128451_("fuel"));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void setFuel(int i) {
        this.fuel = i;
    }

    public int getFuel() {
        return this.fuel;
    }

    public List<BlockState> stateList() {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        states.add(((Block)Sblocks.BIOMASS_BLOCK.get()).m_49966_());
        states.add(((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).m_49966_());
        states.add(((Block)Sblocks.CALCIFIED_BIOMASS_BLOCK.get()).m_49966_());
        states.add(((Block)Sblocks.MEMBRANE_BLOCK.get()).m_49966_());
        states.add(((Block)Sblocks.ROOTED_BIOMASS.get()).m_49966_());
        states.add(((Block)Sblocks.GASTRIC_BIOMASS.get()).m_49966_());
        states.add(((Block)Sblocks.ROOTED_MYCELIUM.get()).m_49966_());
        return states;
    }

    public void cleanInfection(BlockPos blockPos) {
        int range = 2 * (Integer)SConfig.DATAGEN.cryo_range.get();
        AABB aabb = AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)range, (double)range, (double)range);
        List entities = this.f_58857_.m_45976_(LivingEntity.class, aabb);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState state = this.f_58857_.m_8055_(blockpos);
            if (state.m_204336_(TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation("spore", "removable_foliage"))) && Math.random() < 0.2) {
                this.f_58857_.m_7471_(blockpos, false);
            }
            if (state == ((Block)Sblocks.REMAINS.get()).m_49966_()) {
                this.f_58857_.m_7731_(blockpos, ((Block)Sblocks.FROZEN_REMAINS.get()).m_49966_(), 3);
            }
            if (Math.random() < 0.2 && !this.blockMap.isEmpty()) {
                for (StoreDouble storeDouble : this.blockMap) {
                    if (storeDouble.value1 != state.m_60734_()) continue;
                    this.f_58857_.m_7731_(blockpos, storeDouble.value2.m_49966_(), 3);
                }
            }
            if (Math.random() < 0.1) {
                if (this.biomass.contains(state)) {
                    this.f_58857_.m_7731_(blockpos, ((Block)Sblocks.FROST_BURNED_BIOMASS.get()).m_49966_(), 3);
                }
                if (state == ((LiquidBlock)Sblocks.BILE.get()).m_49966_()) {
                    this.f_58857_.m_7731_(blockpos, ((Block)Sblocks.CRUSTED_BILE.get()).m_49966_(), 3);
                }
            }
            if (!(Math.random() < 0.001) || !((Boolean)SConfig.DATAGEN.cryo_snow.get()).booleanValue()) continue;
            BlockState blockState1 = this.f_58857_.m_8055_(blockpos.m_7494_());
            if (!state.m_60804_((BlockGetter)this.f_58857_, blockPos) || !blockState1.m_60795_()) continue;
            RandomSource randomSource = RandomSource.m_216327_();
            int layer = randomSource.m_216339_(1, 4);
            BlockState snowState = Blocks.f_50125_.m_49966_();
            Property property = snowState.m_60734_().m_49965_().m_61081_("layers");
            if (!(property instanceof IntegerProperty)) continue;
            IntegerProperty property2 = (IntegerProperty)property;
            this.f_58857_.m_7731_(blockpos.m_7494_(), (BlockState)snowState.m_61124_((Property)property2, (Comparable)Integer.valueOf(layer)), 3);
        }
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6095_().m_204039_(EntityTypeTags.f_144295_)) {
                livingEntity.m_146917_(livingEntity.m_146888_() + 100);
                livingEntity.m_6469_(livingEntity.m_269291_().m_269109_(), (float)((Double)SConfig.DATAGEN.cryo_damage.get() * 1.0));
            }
            if (!(entity instanceof ScentEntity) && !(entity instanceof InfectionTendril)) continue;
            entity.m_146870_();
        }
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, CDUBlockEntity e) {
        if (e.getFuel() > 0 && !level.f_46443_) {
            --e.fuel;
            if (e.getFuel() % 100 == 0) {
                e.cleanInfection(blockPos);
            }
            if (e.getFuel() % 80 == 0) {
                level.m_5594_(null, blockPos, (SoundEvent)Ssounds.CDU_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.spore.cdu");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new CDUMenu(i, inventory);
    }

    record StoreDouble(Block value1, Block value2) {
    }
}

