/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings;

import com.Harbinger.Spore.Core.SAttributes;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.ExtremelySusThings.BooleanCache;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class Utilities {
    public static final Predicate<LivingEntity> TARGET_SELECTOR_PREDICATE = entity -> {
        if (entity instanceof Infected || entity instanceof UtilityEntity) {
            return false;
        }
        if ((entity instanceof AbstractFish || entity instanceof Animal) && !((Boolean)SConfig.SERVER.at_an.get()).booleanValue()) {
            return false;
        }
        if (!((List)SConfig.SERVER.blacklist.get()).isEmpty()) {
            for (String string : (List)SConfig.SERVER.blacklist.get()) {
                String[] iterations;
                String[] mod;
                if (!string.endsWith(":") || entity.m_20078_() == null || !Objects.equals((mod = string.split(":"))[0], (iterations = entity.m_20078_().split(":"))[0])) continue;
                return false;
            }
            return !((List)SConfig.SERVER.blacklist.get()).contains(entity.m_20078_());
        }
        return true;
    };
    public static BooleanCache<LivingEntity> TARGET_SELECTOR = new BooleanCache<LivingEntity>(8, TARGET_SELECTOR_PREDICATE);

    public static void explodeCircle(ServerLevel level, Entity owner, BlockPos pos, double range, float damage, double blockHardness, Predicate<Entity> predicate) {
        Utilities.explodeCircle(level, owner, pos, range, damage, (ParticleOptions)ParticleTypes.f_123812_, false, blockHardness, predicate);
    }

    public static void explodeCircle(ServerLevel level, Entity owner, BlockPos pos, double range, float damage, ParticleOptions particleTypes, boolean dropItems, double blockHardness, Predicate<Entity> predicate) {
        int i = 0;
        while ((double)i <= 2.0 * range) {
            int j = 0;
            while ((double)j <= 2.0 * range) {
                int k = 0;
                while ((double)k <= 2.0 * range) {
                    double distance = Mth.m_14116_((float)((float)(((double)i - range) * ((double)i - range) + ((double)j - range) * ((double)j - range) + ((double)k - range) * ((double)k - range))));
                    if ((Math.abs(i) != 2 || Math.abs(j) != 2 || Math.abs(k) != 2) && distance < range + 0.5) {
                        BlockPos blockpos = pos.m_7918_(i - (int)range, j - (int)range, k - (int)range);
                        RandomSource source = RandomSource.m_216327_();
                        BlockState state = level.m_8055_(blockpos);
                        if ((double)state.m_60800_((BlockGetter)level, blockpos) <= blockHardness && state.m_60800_((BlockGetter)level, blockpos) >= 0.0f && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)owner)) {
                            level.m_7471_(blockpos, dropItems);
                            if (Math.random() < 0.3) {
                                float value = source.m_188501_() * 0.05f;
                                level.m_8767_(particleTypes, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), 1, (double)value, 0.0, (double)value, 1.0);
                            }
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        AABB searchbox = AABB.m_165882_((Vec3)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (double)(range * 2.0), (double)(range * 2.0), (double)(range * 2.0));
        List entities = level.m_6249_(owner, searchbox, predicate);
        for (Entity entity : entities) {
            entity.m_6469_(level.m_269111_().m_269333_((LivingEntity)owner), damage);
        }
        level.m_247517_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS);
    }

    public static void convertBlocks(ServerLevel level, Entity owner, BlockPos pos, double range, BlockState state) {
        int i = 0;
        while ((double)i <= 2.0 * range) {
            int j = 0;
            while ((double)j <= 2.0 * range) {
                int k = 0;
                while ((double)k <= 2.0 * range) {
                    double distance = Mth.m_14116_((float)((float)(((double)i - range) * ((double)i - range) + ((double)j - range) * ((double)j - range) + ((double)k - range) * ((double)k - range))));
                    if ((Math.abs(i) != 2 || Math.abs(j) != 2 || Math.abs(k) != 2) && distance < range + 0.5) {
                        BlockPos blockpos = pos.m_7918_(i - (int)range, j - (int)range, k - (int)range);
                        if (ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)owner) && Math.random() < (double)0.2f && level.m_8055_(blockpos).m_60795_() && level.m_8055_(blockpos.m_7495_()).m_60804_((BlockGetter)level, blockpos)) {
                            level.m_7731_(blockpos, state, 3);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static List<Item> helmetList() {
        ArrayList<Item> values = new ArrayList<Item>();
        for (String string : (List)SConfig.SERVER.gas_masks.get()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string));
            if (item == null) continue;
            values.add(item);
        }
        return values;
    }

    public static List<BlockState> biomass() {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        states.add(((Block)Sblocks.BIOMASS_BLOCK.get()).m_49966_());
        states.add(((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).m_49966_());
        states.add(((Block)Sblocks.CALCIFIED_BIOMASS_BLOCK.get()).m_49966_());
        states.add(((Block)Sblocks.MEMBRANE_BLOCK.get()).m_49966_());
        states.add(((Block)Sblocks.ROOTED_BIOMASS.get()).m_49966_());
        states.add(((Block)Sblocks.ROOTED_MYCELIUM.get()).m_49966_());
        states.add(((Block)Sblocks.GASTRIC_BIOMASS.get()).m_49966_());
        return states;
    }

    public static Vec3 generatePositionAway(Vec3 origin, double distance) {
        Random random = new Random();
        double theta = random.nextDouble() * 2.0 * Math.PI;
        double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
        double offsetX = Math.sin(phi) * Math.cos(theta) * distance;
        double offsetY = Math.sin(phi) * Math.sin(theta) * distance;
        double offsetZ = Math.cos(phi) * distance;
        return new Vec3(origin.f_82479_ + offsetX, origin.f_82480_ + offsetY, origin.f_82481_ + offsetZ);
    }

    public static List<Item> getItemsFromTag(String namespace, String tagName) {
        TagKey tagKey = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation(namespace, tagName));
        return BuiltInRegistries.f_257033_.m_203431_(tagKey).map(holderSet -> holderSet.m_203614_().map(Holder::m_203334_).collect(Collectors.toList())).orElse(List.of());
    }

    public static void doCustomModifiersAfterEffects(LivingEntity attacker, LivingEntity victim) {
        AttributeInstance grind;
        AttributeInstance local;
        AttributeInstance toxic;
        if (attacker == null || victim == null) {
            return;
        }
        AttributeInstance corrosion = attacker.m_21051_((Attribute)SAttributes.CORROSIVES.get());
        if (corrosion != null && corrosion.m_22135_() >= 1.0) {
            int level = (int)corrosion.m_22135_() - 1;
            victim.m_147207_(new MobEffectInstance((MobEffect)Seffects.CORROSION.get(), 300, level), (Entity)attacker);
        }
        if ((toxic = attacker.m_21051_((Attribute)SAttributes.TOXICITY.get())) != null && toxic.m_22135_() >= 1.0) {
            int level = (int)toxic.m_22135_() - 1;
            victim.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 400, level), (Entity)attacker);
        }
        if ((local = attacker.m_21051_((Attribute)SAttributes.LOCALIZATION.get())) != null && local.m_22135_() >= 1.0) {
            int level = (int)local.m_22135_() - 1;
            victim.m_147207_(new MobEffectInstance((MobEffect)Seffects.MARKER.get(), 600, level), (Entity)attacker);
        }
        if ((grind = attacker.m_21051_((Attribute)SAttributes.GRINDING.get())) != null && grind.m_22135_() >= 1.0) {
            double level = grind.m_22135_();
            victim.m_6168_().forEach(itemStack -> itemStack.m_41721_(itemStack.m_41773_() + (int)(10.0 * level)));
        }
    }

    public static int mixColors(Map<Integer, Float> colorsAndWeights) {
        float totalWeight = 0.0f;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (Map.Entry<Integer, Float> entry : colorsAndWeights.entrySet()) {
            int color = entry.getKey();
            float weight = entry.getValue().floatValue();
            r += (float)(color >> 16 & 0xFF) * weight;
            g += (float)(color >> 8 & 0xFF) * weight;
            b += (float)(color & 0xFF) * weight;
            totalWeight += weight;
        }
        if (totalWeight == 0.0f) {
            return 0xFFFFFF;
        }
        int finalColor = (int)(r /= totalWeight) << 16 | (int)(g /= totalWeight) << 8 | (int)(b /= totalWeight);
        return finalColor;
    }
}

