/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.ExtremelySusThings.Package;

import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class AdvancementGivingPackage {
    private final String advancement;
    private final int id;

    public AdvancementGivingPackage(String advancement, int id) {
        this.advancement = advancement;
        this.id = id;
    }

    public AdvancementGivingPackage(FriendlyByteBuf buffer) {
        this.advancement = buffer.m_130277_();
        this.id = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.advancement);
        buffer.writeInt(this.id);
    }

    public static void handle(AdvancementGivingPackage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null || !player.m_6084_()) {
                System.err.println("[Spore] Invalid player when handling advancement package.");
                return;
            }
            MinecraftServer server = player.f_8924_;
            if (server == null || server.m_129889_() == null) {
                System.err.println("[Spore] Server advancements are null!");
                return;
            }
            Advancement advancement = server.m_129889_().m_136041_(new ResourceLocation(message.advancement));
            if (advancement == null) {
                System.err.println("[Spore] Advancement not found: " + message.advancement);
                return;
            }
            AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
            if (progress.m_8193_()) {
                return;
            }
            for (String criterion : progress.m_8219_()) {
                player.m_8960_().m_135988_(advancement, criterion);
            }
        });
        context.get().setPacketHandled(true);
    }
}

