/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.TentacleSegmentModel;
import com.Harbinger.Spore.Client.Renderers.OrganoidMobRenderer;
import com.Harbinger.Spore.Client.TentacleSegment;
import com.Harbinger.Spore.Sentities.Organoids.Tentacle;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class TentacleRenderer
extends OrganoidMobRenderer<Tentacle, EntityModel<Tentacle>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/blank.png");

    public TentacleRenderer(EntityRendererProvider.Context context) {
        super(context, new TentacleSegmentModel(), 0.2f);
    }

    @Override
    public void render(Tentacle type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int value3) {
        super.render(type, value1, value2, stack, bufferSource, value3);
        this.renderTentacle(stack, bufferSource, type.getSegments(), type.m_20182_());
    }

    public void renderTentacle(PoseStack stack, MultiBufferSource buffer, List<TentacleSegment> segments, Vec3 basePosition) {
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
        PoseStack.Pose pose = stack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        for (TentacleSegment segment : segments) {
            Vec3 pos = segment.position.m_82546_(basePosition);
            float size = 0.5f;
            float x1 = (float)(pos.f_82479_ - (double)size);
            float x2 = (float)(pos.f_82479_ + (double)size);
            float y1 = (float)(pos.f_82480_ - (double)size);
            float y2 = (float)(pos.f_82480_ + (double)size);
            float z1 = (float)(pos.f_82481_ - (double)size);
            float z2 = (float)(pos.f_82481_ + (double)size);
            this.drawFace(vertexConsumer, matrix, stack.m_85850_(), x1, y1, z1, x2, y1, z1, x2, y2, z1, x1, y2, z1, 0, 240, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, -1.0f);
            this.drawFace(vertexConsumer, matrix, stack.m_85850_(), x1, y1, z2, x2, y1, z2, x2, y2, z2, x1, y2, z2, 0, 240, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
            this.drawFace(vertexConsumer, matrix, stack.m_85850_(), x1, y1, z1, x1, y1, z2, x1, y2, z2, x1, y2, z1, 0, 240, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 0.0f, 0.0f);
            this.drawFace(vertexConsumer, matrix, stack.m_85850_(), x2, y1, z1, x2, y1, z2, x2, y2, z2, x2, y2, z1, 0, 240, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
            this.drawFace(vertexConsumer, matrix, stack.m_85850_(), x1, y2, z1, x2, y2, z1, x2, y2, z2, x1, y2, z2, 0, 240, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f);
            this.drawFace(vertexConsumer, matrix, stack.m_85850_(), x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2, 0, 240, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, -1.0f, 0.0f);
        }
    }

    private void drawFace(VertexConsumer vertexConsumer, Matrix4f matrix, PoseStack.Pose pose, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, int overlay, int lightmap, float red, float green, float blue, float alpha, float normalX, float normalY, float normalZ) {
        vertexConsumer.m_252986_(matrix, x1, y1, z1).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(pose.m_252943_(), normalX, normalY, normalZ).m_5752_();
        vertexConsumer.m_252986_(matrix, x2, y2, z2).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(pose.m_252943_(), normalX, normalY, normalZ).m_5752_();
        vertexConsumer.m_252986_(matrix, x3, y3, z3).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(pose.m_252943_(), normalX, normalY, normalZ).m_5752_();
        vertexConsumer.m_252986_(matrix, x4, y4, z4).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(pose.m_252943_(), normalX, normalY, normalZ).m_5752_();
    }

    public ResourceLocation getTextureLocation(Tentacle tentacle) {
        return TEXTURE;
    }
}

