/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.IncubatorModel;
import com.Harbinger.Spore.Client.Special.BaseBlockEntityRenderer;
import com.Harbinger.Spore.SBlockEntities.IncubatorBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class IncubatorRenderer
extends BaseBlockEntityRenderer<IncubatorBlockEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/block/incubator/incubator.png");
    private static final ResourceLocation GLASS = new ResourceLocation("spore", "textures/block/incubator/incubator_glass.png");
    private static final ResourceLocation BUTTONS = new ResourceLocation("spore", "textures/block/incubator/incubator_buttons.png");

    public IncubatorRenderer() {
        super(new IncubatorModel());
    }

    @Override
    public ResourceLocation getTexture(IncubatorBlockEntity block) {
        return TEXTURE;
    }

    public void render(@NotNull IncubatorBlockEntity blockEntity, float partialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        super.m_6922_(blockEntity, partialTicks, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        if (this.unRenderBlock(blockEntity)) {
            if (blockEntity.m_8020_(0) != ItemStack.f_41583_ && blockEntity.m_58904_() != null) {
                this.renderItem(pPoseStack, blockEntity.m_8020_(0), pBuffer, (float)blockEntity.getTicks() + partialTicks, blockEntity.m_58904_(), blockEntity.m_58899_());
            }
            this.renderGlassTransparency(blockEntity, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            this.renderActiveButtons(blockEntity, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        }
    }

    public void renderGlassTransparency(IncubatorBlockEntity blockEntity, PoseStack stack, MultiBufferSource bufferSource, int pPackedLight, int pPackedOverlay) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)GLASS));
        this.setModelScale(stack, blockEntity);
        this.getModel().m_7695_(stack, vertexConsumer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderActiveButtons(IncubatorBlockEntity blockEntity, PoseStack stack, MultiBufferSource bufferSource, int pPackedLight, int pPackedOverlay) {
        VertexConsumer vertexConsumer = bufferSource.m_6299_(blockEntity.isActive() ? RenderType.m_110488_((ResourceLocation)BUTTONS) : RenderType.m_110452_((ResourceLocation)BUTTONS));
        this.getModel().m_7695_(stack, vertexConsumer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderItem(PoseStack stack, ItemStack itemStack, MultiBufferSource source, float value, Level level, BlockPos pos) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        RandomSource random = RandomSource.m_216327_();
        float vibrationValue = random.m_188501_() * 0.02f;
        stack.m_85836_();
        stack.m_85837_(0.5 + (double)vibrationValue, (double)(0.5f + Mth.m_14089_((float)(value / 8.0f)) / 10.0f), 0.5 + (double)vibrationValue);
        stack.m_85841_(0.5f, 0.5f, 0.5f);
        stack.m_252781_(Axis.f_252436_.m_252977_(value));
        itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIXED, this.getLight(level, pos), OverlayTexture.f_118083_, stack, source, level, 1);
        stack.m_85849_();
    }

    private int getLight(Level level, BlockPos pos) {
        int a = level.m_45517_(LightLayer.BLOCK, pos);
        int b = level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)a, (int)b);
    }

    @Override
    public void setModelScale(PoseStack pPoseStack, IncubatorBlockEntity block) {
        int e = block.getSide();
        this.setModelScale(pPoseStack, block, e);
    }
}

