/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.WormSegmentModel;
import com.Harbinger.Spore.Client.Models.WormTailModel;
import com.Harbinger.Spore.Client.Models.hohlfresserHeadModel;
import com.Harbinger.Spore.Client.Special.CalamityRenderer;
import com.Harbinger.Spore.Sentities.BaseEntities.HohlMultipart;
import com.Harbinger.Spore.Sentities.Calamities.Hohlfresser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class HohlRenderer<Type extends Hohlfresser>
extends CalamityRenderer<Type, EntityModel<Type>> {
    private final WormSegmentModel<Type> segments;
    private final WormTailModel<Type> tail;
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/hohl_head.png");
    private static final ResourceLocation INNARDS = new ResourceLocation("spore", "textures/entity/worm_innards.png");
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/hohl_head.png");

    public HohlRenderer(EntityRendererProvider.Context context) {
        super(context, new hohlfresserHeadModel(context.m_174023_(hohlfresserHeadModel.LAYER_LOCATION)), 4.0f);
        this.segments = new WormSegmentModel(context.m_174023_(WormSegmentModel.LAYER_LOCATION));
        this.tail = new WormTailModel(context.m_174023_(WormTailModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    public void render(Type type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int light) {
        super.m_7392_(type, value1, value2, stack, bufferSource, light);
        float i = type.m_6080_();
        HohlMultipart previous = null;
        for (int e = 0; e < ((Hohlfresser)type).getSubEntities().size(); ++e) {
            HohlMultipart segment = ((Hohlfresser)type).getSubEntities().get(e);
            this.renderSegment(type, segment, previous, stack, bufferSource, light, i, value2, e == ((Hohlfresser)type).getSubEntities().size() - 1);
            previous = segment;
        }
        if (!((Hohlfresser)type).getSubEntities().isEmpty()) {
            this.renderConnectionHead(type, ((Hohlfresser)type).getSubEntities().get(0), stack, bufferSource, value2);
        }
    }

    private void renderSegment(Type parent, HohlMultipart entity, HohlMultipart previous, PoseStack stack, MultiBufferSource bufferSource, int packedLight, float y, float age, boolean isLast) {
        EntityModel proper_model = isLast ? this.tail : this.segments;
        float limbSwing = ((Hohlfresser)parent).f_267362_.m_267756_();
        float limbSwingAmount = ((Hohlfresser)parent).f_267362_.m_267731_();
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
        Vec3 vec3 = parent.m_20182_().m_82546_(entity.m_20182_()).m_82490_(-1.5);
        stack.m_85836_();
        stack.m_85841_(entity.getInflation(), entity.getInflation(), entity.getInflation());
        stack.m_85837_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - y));
        stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        stack.m_85837_(0.0, -1.5, 0.0);
        proper_model.m_6973_(parent, limbSwing, limbSwingAmount, age, parent.m_146908_(), parent.m_146909_());
        proper_model.m_7695_(stack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
        if (previous != null) {
            this.renderConnection(parent, previous, entity, stack, bufferSource, age);
        }
    }

    public ResourceLocation GET_TEXTURE(Entity entity) {
        return INNARDS;
    }

    private void renderConnection(Type parent, HohlMultipart from, HohlMultipart to, PoseStack stack, MultiBufferSource buffer, float partialTick) {
        Vec3 start = from.m_20318_(partialTick);
        Vec3 end = to.m_20318_(partialTick);
        Vec3 direction = end.m_82546_(start);
        float length = (float)direction.m_82553_();
        direction = direction.m_82541_();
        float yaw = (float)Math.atan2(direction.f_82479_, direction.f_82481_);
        float pitch = (float)(-Math.asin(direction.f_82480_));
        stack.m_85836_();
        Vec3 vec3 = parent.m_20182_().m_82546_(from.m_20182_()).m_82490_(-1.0);
        stack.m_85837_(vec3.f_82479_, vec3.f_82480_ + 1.0, vec3.f_82481_);
        stack.m_252781_(Axis.f_252436_.m_252961_(yaw));
        stack.m_252781_(Axis.f_252529_.m_252961_(pitch));
        float startWidth = from.m_20205_() * from.getInflation() * 0.5f;
        float startHeight = from.m_20206_() * from.getInflation() * 0.5f;
        float endWidth = to.m_20205_() * to.getInflation() * 0.5f;
        float endHeight = to.m_20206_() * to.getInflation() * 0.5f;
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.GET_TEXTURE((Entity)parent)));
        PoseStack.Pose pose = stack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        this.drawTaperedConnection(vertexConsumer, matrix, pose.m_252943_(), startWidth, startHeight, endWidth, endHeight, length, OverlayTexture.f_118083_, 0xF000F0, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
    }

    private void renderConnectionHead(Type parent, HohlMultipart to, PoseStack stack, MultiBufferSource buffer, float partialTick) {
        Vec3 start = parent.m_20318_(partialTick);
        Vec3 end = to.m_20318_(partialTick);
        Vec3 direction = end.m_82546_(start);
        float length = (float)direction.m_82553_();
        direction = direction.m_82541_();
        float yaw = (float)Math.atan2(direction.f_82479_, direction.f_82481_);
        float pitch = (float)(-Math.asin(direction.f_82480_));
        stack.m_85836_();
        Vec3 vec3 = parent.m_20182_().m_82546_(to.m_20182_()).m_82490_(-0.3);
        stack.m_85837_(vec3.f_82479_, vec3.f_82480_ + 1.0, vec3.f_82481_);
        stack.m_252781_(Axis.f_252436_.m_252961_(yaw));
        stack.m_252781_(Axis.f_252529_.m_252961_(pitch));
        float startWidth = parent.m_20205_() * 0.6f;
        float startHeight = parent.m_20206_() * 0.6f;
        float endWidth = to.m_20205_() * to.getInflation() * 0.6f;
        float endHeight = to.m_20206_() * to.getInflation() * 0.6f;
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.GET_TEXTURE((Entity)parent)));
        PoseStack.Pose pose = stack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        this.drawTaperedConnection(vertexConsumer, matrix, pose.m_252943_(), startWidth, startHeight, endWidth, endHeight, length, OverlayTexture.f_118083_, 0xF000F0, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
    }

    private void drawTaperedConnection(VertexConsumer vertexConsumer, Matrix4f matrix, Matrix3f normal, float startWidth, float startHeight, float endWidth, float endHeight, float length, int overlay, int lightmap, float red, float green, float blue, float alpha) {
        float hwStart = startWidth / 2.0f;
        float hhStart = startHeight / 2.0f;
        float hwEnd = endWidth / 2.0f;
        float hhEnd = endHeight / 2.0f;
        vertexConsumer.m_252986_(matrix, -hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
    }
}

