/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.particle;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoParticle;
import com.tacz.guns.entity.EntityKineticBullet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class AmmoParticleSpawner {
    public static void addParticle(EntityKineticBullet bullet) {
        TimelessAPI.getGunDisplay(bullet.getGunDisplayId(), bullet.getGunId()).ifPresent(gunIndex -> {
            AmmoParticle gunParticle = gunIndex.getParticle();
            if (gunParticle == null) {
                TimelessAPI.getClientAmmoIndex(bullet.getAmmoId()).ifPresent(ammoIndex -> {
                    AmmoParticle ammoParticle = ammoIndex.getParticle();
                    if (ammoParticle == null) {
                        return;
                    }
                    AmmoParticleSpawner.spawnParticle(bullet, ammoParticle);
                });
            } else {
                AmmoParticleSpawner.spawnParticle(bullet, gunParticle);
            }
        });
    }

    private static void spawnParticle(EntityKineticBullet bullet, AmmoParticle particle) {
        ParticleOptions particleOptions = particle.getParticleOptions();
        if (particleOptions == null) {
            return;
        }
        int count = particle.getCount();
        Vector3f delta = particle.getDelta();
        float particleSpeed = particle.getSpeed();
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        if (count == 0) {
            double xSpeed = particleSpeed * delta.x();
            double ySpeed = particleSpeed * delta.y();
            double zSpeed = particleSpeed * delta.z();
            Particle result = particleEngine.m_107370_(particleOptions, bullet.m_20185_(), bullet.m_20186_(), bullet.m_20189_(), xSpeed, ySpeed, zSpeed);
            if (result != null) {
                result.m_107257_(particle.getLifeTime());
            }
        } else {
            RandomSource random = bullet.getRandom();
            Entity owner = bullet.m_19749_();
            for (int i = 0; i < count; ++i) {
                AmmoParticleSpawner.createParticle(bullet, particle, random, delta, particleSpeed, owner, particleEngine, particleOptions);
            }
        }
    }

    private static void createParticle(EntityKineticBullet bullet, AmmoParticle particle, RandomSource random, Vector3f delta, float particleSpeed, Entity owner, ParticleEngine particleEngine, ParticleOptions particleOptions) {
        Particle result;
        Vec3 deltaMovement = bullet.m_20184_();
        double deltaMovementRandom = random.m_188500_();
        double offsetX = random.m_188583_() * (double)delta.x() + deltaMovementRandom * deltaMovement.f_82479_;
        double offsetY = random.m_188583_() * (double)delta.y() + deltaMovementRandom * deltaMovement.f_82480_;
        double offsetZ = random.m_188583_() * (double)delta.z() + deltaMovementRandom * deltaMovement.f_82481_;
        double xSpeed = random.m_188583_() * (double)particleSpeed;
        double ySpeed = random.m_188583_() * (double)particleSpeed;
        double zSpeed = random.m_188583_() * (double)particleSpeed;
        double posX = bullet.m_20185_() + offsetX;
        double posY = bullet.m_20186_() + offsetY;
        double posZ = bullet.m_20189_() + offsetZ;
        if ((owner == null || owner.m_20275_(posX, posY, posZ) > 9.0) && (result = particleEngine.m_107370_(particleOptions, posX, posY, posZ, xSpeed, ySpeed, zSpeed)) != null) {
            result.m_107257_(particle.getLifeTime());
        }
    }
}

