/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.resource.pojo.display.gun.AmmoCountStyle;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import java.text.DecimalFormat;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class GunHudOverlay
implements IGuiOverlay {
    private static final ResourceLocation SEMI = new ResourceLocation("tacz", "textures/hud/fire_mode_semi.png");
    private static final ResourceLocation AUTO = new ResourceLocation("tacz", "textures/hud/fire_mode_auto.png");
    private static final ResourceLocation BURST = new ResourceLocation("tacz", "textures/hud/fire_mode_burst.png");
    private static final ResourceLocation HEATBAR = new ResourceLocation("tacz", "textures/hud/heat_bar.png");
    private static final ResourceLocation HEATBASE = new ResourceLocation("tacz", "textures/hud/heat_base.png");
    private static final DecimalFormat CURRENT_AMMO_FORMAT = new DecimalFormat("000");
    private static final DecimalFormat CURRENT_AMMO_FORMAT_PERCENT = new DecimalFormat("000%");
    private static final DecimalFormat INVENTORY_AMMO_FORMAT = new DecimalFormat("0000");
    private static long checkAmmoTimestamp = -1L;
    private static int cacheMaxAmmoCount = 0;
    private static int cacheInventoryAmmoCount = 0;
    private static final int MAX_AMMO_COUNT = 9999;

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        String inventoryAmmoCountText;
        boolean overheatLocked;
        if (!((Boolean)RenderConfig.GUN_HUD_ENABLE.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (!(player instanceof IClientPlayerGunOperator)) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(stack);
        GunData gunData = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getGunData).orElse(null);
        GunDisplayInstance display = TimelessAPI.getGunDisplay(stack).orElse(null);
        if (gunData == null || display == null) {
            return;
        }
        boolean useInventoryAmmo = iGun.useInventoryAmmo(stack);
        boolean useDummyAmmo = iGun.useDummyAmmo(stack);
        boolean bl = overheatLocked = gunData.hasHeatData() && iGun.isOverheatLocked(stack);
        int ammoCount = useInventoryAmmo ? cacheInventoryAmmoCount + (iGun.hasBulletInBarrel(stack) && gunData.getBolt() != Bolt.OPEN_BOLT ? 1 : 0) : iGun.getCurrentAmmoCount(stack) + (iGun.hasBulletInBarrel(stack) && gunData.getBolt() != Bolt.OPEN_BOLT ? 1 : 0);
        int ammoCountColor = (double)(ammoCount = Math.min(ammoCount, 9999)) < (double)cacheMaxAmmoCount * 0.25 && ammoCount < 10 || overheatLocked ? 0xFF5555 : (useInventoryAmmo && useDummyAmmo ? 0x55FFFF : (useInventoryAmmo ? 0xFFFF55 : 0xFFFFFF));
        int inventoryAmmoCountColor = !useInventoryAmmo && useDummyAmmo ? 0x55FFFF : 0xAAAAAA;
        String currentAmmoCountText = display.getAmmoCountStyle() == AmmoCountStyle.PERCENT ? CURRENT_AMMO_FORMAT_PERCENT.format((float)ammoCount / (cacheMaxAmmoCount == 0 ? 1.0f : (float)cacheMaxAmmoCount)) : CURRENT_AMMO_FORMAT.format(ammoCount);
        String string = inventoryAmmoCountText = useInventoryAmmo ? "" : INVENTORY_AMMO_FORMAT.format(cacheInventoryAmmoCount);
        if (!useInventoryAmmo && gunData.getReloadData().isInfinite()) {
            inventoryAmmoCountText = "\u221e";
        }
        GunHudOverlay.handleCacheCount(player, stack, gunData, iGun, useInventoryAmmo);
        graphics.m_280509_(width - 75, height - 43, width - 74, height - 25, -1);
        PoseStack poseStack = graphics.m_280168_();
        Font font = mc.f_91062_;
        poseStack.m_85836_();
        poseStack.m_85841_(1.5f, 1.5f, 1.0f);
        graphics.drawString(font, currentAmmoCountText, (float)(width - 70) / 1.5f, (float)(height - 43) / 1.5f, ammoCountColor, false);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(0.8f, 0.8f, 1.0f);
        graphics.drawString(font, inventoryAmmoCountText, ((float)(width - 68) + (float)mc.f_91062_.m_92895_(currentAmmoCountText) * 1.5f) / 0.8f, (float)(height - 43) / 0.8f, inventoryAmmoCountColor, false);
        poseStack.m_85849_();
        String minecraftVersion = SharedConstants.m_183709_().m_132493_();
        String modVersion = ModList.get().getModFileById("tacz").versionString();
        String debugInfo = String.format("%s-%s", minecraftVersion, modVersion);
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 1.0f);
        graphics.m_280488_(font, debugInfo, (int)((float)(width - 70) / 0.5f), (int)(((float)height - 29.0f) / 0.5f), -5592406);
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ResourceLocation hudTexture = display.getHUDTexture();
        @Nullable ResourceLocation hudEmptyTexture = display.getHudEmptyTexture();
        if (ammoCount <= 0 || overheatLocked) {
            if (hudEmptyTexture == null) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                hudTexture = hudEmptyTexture;
            }
        }
        graphics.m_280163_(hudTexture, width - 117, height - 44, 0.0f, 0.0f, 39, 13, 39, 13);
        FireMode fireMode = IGun.getMainHandFireMode((LivingEntity)player);
        ResourceLocation fireModeTexture = switch (fireMode) {
            case FireMode.AUTO -> AUTO;
            case FireMode.BURST -> BURST;
            default -> SEMI;
        };
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280163_(fireModeTexture, (int)((double)width - 68.5 + (double)mc.f_91062_.m_92895_(currentAmmoCountText) * 1.5), height - 38, 0.0f, 0.0f, 10, 10, 10, 10);
    }

    private static void handleCacheCount(LocalPlayer player, ItemStack stack, GunData gunData, IGun iGun, boolean useInventoryAmmo) {
        if (System.currentTimeMillis() - checkAmmoTimestamp > 50L) {
            checkAmmoTimestamp = System.currentTimeMillis();
            cacheMaxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(stack, gunData);
            if (IGunOperator.fromLivingEntity((LivingEntity)player).needCheckAmmo()) {
                if (iGun.useDummyAmmo(stack)) {
                    cacheInventoryAmmoCount = iGun.getDummyAmmoAmount(stack);
                } else {
                    GunHudOverlay.handleInventoryAmmo(stack, player.m_150109_());
                }
            } else {
                cacheInventoryAmmoCount = 9999;
            }
            if (useInventoryAmmo) {
                iGun.setCurrentAmmoCount(stack, cacheInventoryAmmoCount);
            }
        }
    }

    private static void handleInventoryAmmo(ItemStack stack, Inventory inventory) {
        cacheInventoryAmmoCount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            IAmmoBox iAmmoBox;
            IAmmo iAmmo;
            ItemStack inventoryItem = inventory.m_8020_(i);
            Item item = inventoryItem.m_41720_();
            if (item instanceof IAmmo && (iAmmo = (IAmmo)item).isAmmoOfGun(stack, inventoryItem)) {
                cacheInventoryAmmoCount += inventoryItem.m_41613_();
            }
            if (!((item = inventoryItem.m_41720_()) instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)item).isAmmoBoxOfGun(stack, inventoryItem)) continue;
            if (iAmmoBox.isAllTypeCreative(inventoryItem) || iAmmoBox.isCreative(inventoryItem)) {
                cacheInventoryAmmoCount = 9999;
                return;
            }
            cacheInventoryAmmoCount += iAmmoBox.getAmmoCount(inventoryItem);
        }
    }
}

