/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.animation.third;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.other.ThirdPersonManager;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.compat.playeranimator.PlayerAnimatorCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;

public class InnerThirdPersonManager {
    public static void setRotationAnglesHead(LivingEntity entityIn, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head, float limbSwingAmount) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_ == entityIn && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
            PlayerAnimatorCompat.stopAllAnimation(entityIn, 0);
            return;
        }
        if (entityIn instanceof IGunOperator) {
            IGunOperator operator = (IGunOperator)entityIn;
            ItemStack mainHandItem = entityIn.m_21205_();
            IGun iGun = IGun.getIGunOrNull(mainHandItem);
            if (iGun == null) {
                PlayerAnimatorCompat.stopAllAnimation(entityIn);
                return;
            }
            if (entityIn.m_20089_() == Pose.SLEEPING || entityIn.m_6147_() || entityIn.m_6069_() || entityIn.m_20089_() == Pose.FALL_FLYING) {
                PlayerAnimatorCompat.stopAllAnimation(entityIn);
                return;
            }
            TimelessAPI.getGunDisplay(mainHandItem).ifPresent(display -> {
                if (PlayerAnimatorCompat.hasPlayerAnimator3rd(entityIn, display)) {
                    PlayerAnimatorCompat.playAnimation(entityIn, display, limbSwingAmount);
                } else {
                    InnerThirdPersonManager.playVanillaAnimation(entityIn, rightArm, leftArm, body, head, operator, display);
                }
            });
        }
    }

    private static void playVanillaAnimation(LivingEntity entityIn, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head, IGunOperator operator, GunDisplayInstance display) {
        String animation = display.getThirdPersonAnimation();
        float aimingProgress = operator.getSynAimingProgress();
        if (aimingProgress <= 0.0f) {
            ThirdPersonManager.getAnimation(animation).animateGunHold(entityIn, rightArm, leftArm, body, head);
        } else {
            ThirdPersonManager.getAnimation(animation).animateGunAim(entityIn, rightArm, leftArm, body, head, aimingProgress);
        }
    }
}

