/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IGun;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface AmmoItemDataAccessor
extends IAmmo {
    public static final String AMMO_ID_TAG = "AmmoId";

    @Override
    @Nonnull
    default public ResourceLocation getAmmoId(ItemStack ammo) {
        CompoundTag nbt = ammo.m_41784_();
        if (nbt.m_128425_(AMMO_ID_TAG, 8)) {
            ResourceLocation gunId = ResourceLocation.m_135820_((String)nbt.m_128461_(AMMO_ID_TAG));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_AMMO_ID);
        }
        return DefaultAssets.EMPTY_AMMO_ID;
    }

    @Override
    default public void setAmmoId(ItemStack ammo, @Nullable ResourceLocation ammoId) {
        CompoundTag nbt = ammo.m_41784_();
        if (ammoId != null) {
            nbt.m_128359_(AMMO_ID_TAG, ammoId.toString());
            return;
        }
        nbt.m_128359_(AMMO_ID_TAG, DefaultAssets.DEFAULT_AMMO_ID.toString());
    }

    @Override
    default public boolean isAmmoOfGun(ItemStack gun, ItemStack ammo) {
        Item item = gun.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            item = ammo.m_41720_();
            if (item instanceof IAmmo) {
                IAmmo iAmmo = (IAmmo)item;
                ResourceLocation gunId = iGun.getGunId(gun);
                ResourceLocation ammoId = iAmmo.getAmmoId(ammo);
                return TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> gunIndex.getGunData().getAmmoId().equals((Object)ammoId)).orElse(false);
            }
        }
        return false;
    }
}

