/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render.modifiers;

import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class NegativeFilmPixelModifier
implements IPixelModifier {
    public final boolean simulateFilmTransparency;

    public NegativeFilmPixelModifier(boolean simulateFilmTransparency) {
        this.simulateFilmTransparency = simulateFilmTransparency;
    }

    @Override
    public String getIdSuffix() {
        return this.simulateFilmTransparency ? "_negative_film" : "_negative";
    }

    @Override
    public int modifyPixel(int ABGR) {
        int alpha = FastColor.ABGR32.m_266503_((int)ABGR);
        int blue = FastColor.ABGR32.m_266247_((int)ABGR);
        int green = FastColor.ABGR32.m_266446_((int)ABGR);
        int red = FastColor.ABGR32.m_266313_((int)ABGR);
        if (this.simulateFilmTransparency) {
            int brightness = (blue + green + red) / 3;
            int opacity = (int)Mth.m_14036_((float)((float)brightness * 1.5f), (float)0.0f, (float)255.0f);
            alpha = alpha * opacity / 255;
        }
        blue = 255 - blue;
        green = 255 - green;
        red = 255 - red;
        return FastColor.ABGR32.m_266248_((int)alpha, (int)blue, (int)green, (int)red);
    }

    public String toString() {
        return "NegativeFilmPixelModifier{simulateTransparency=" + this.simulateFilmTransparency + "}";
    }
}

