/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.network;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.bettercombat.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.bettercombat.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.bettercombat.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.TargetHelper;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.logic.knockback.ConfigurableKnockback;
import net.bettercombat.mixin.LivingEntityAccessor;
import net.bettercombat.network.Packets;
import net.bettercombat.utils.MathHelper;
import net.bettercombat.utils.SoundHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.slf4j.Logger;

public class ServerNetwork {
    static final Logger LOGGER = LogUtils.getLogger();
    private static FriendlyByteBuf configSerialized = PacketByteBufs.create();
    private static final UUID COMBO_DAMAGE_MODIFIER_ID = UUID.randomUUID();
    private static final UUID DUAL_WIELDING_MODIFIER_ID = UUID.randomUUID();
    private static final UUID SWEEPING_MODIFIER_ID = UUID.randomUUID();

    public static void initializeHandlers() {
        configSerialized = Packets.ConfigSync.write(BetterCombat.config);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            sender.sendPacket(Packets.WeaponRegistrySync.ID, WeaponRegistry.getEncodedRegistry());
            sender.sendPacket(Packets.ConfigSync.ID, configSerialized);
        });
        ServerPlayNetworking.registerGlobalReceiver(Packets.AttackAnimation.ID, (server, player, handler, buf, responseSender) -> {
            ServerLevel world = (ServerLevel)Iterables.tryFind((Iterable)server.m_129785_(), element -> element == player.m_9236_()).orNull();
            if (world == null || world.f_46443_) {
                return;
            }
            Packets.AttackAnimation packet = Packets.AttackAnimation.read(buf);
            FriendlyByteBuf forwardBuffer = new Packets.AttackAnimation(player.m_19879_(), packet.animatedHand(), packet.animationName(), packet.length(), packet.upswing()).write();
            try {
                if (ServerPlayNetworking.canSend(player, Packets.AttackAnimation.ID)) {
                    ServerPlayNetworking.send(player, Packets.AttackAnimation.ID, forwardBuffer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            PlayerLookup.tracking((Entity)player).forEach(serverPlayer -> {
                try {
                    if (ServerPlayNetworking.canSend(serverPlayer, Packets.AttackAnimation.ID)) {
                        ServerPlayNetworking.send(serverPlayer, Packets.AttackAnimation.ID, forwardBuffer);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(Packets.C2S_AttackRequest.ID, (server, player, handler, buf, responseSender) -> {
            ServerLevel world = (ServerLevel)Iterables.tryFind((Iterable)server.m_129785_(), element -> element == player.m_9236_()).orNull();
            if (world == null || world.f_46443_) {
                return;
            }
            Packets.C2S_AttackRequest request = Packets.C2S_AttackRequest.read(buf);
            AttackHand hand = PlayerAttackHelper.getCurrentAttack((Player)player, request.comboCount());
            if (hand == null) {
                LOGGER.error("Server handling Packets.C2S_AttackRequest - No current attack hand!");
                LOGGER.error("Combo count: " + request.comboCount() + " is dual wielding: " + PlayerAttackHelper.isDualWielding((Player)player));
                LOGGER.error("Main-hand stack: " + player.m_21205_());
                LOGGER.error("Off-hand stack: " + player.m_21206_());
                LOGGER.error("Selected slot server: " + player.m_150109_().f_35977_ + " | client: " + request.selectedSlot());
                return;
            }
            WeaponAttributes.Attack attack = hand.attack();
            WeaponAttributes attributes = hand.attributes();
            boolean useVanillaPacket = Packets.C2S_AttackRequest.UseVanillaPacket;
            world.m_7654_().m_201446_(() -> {
                ((PlayerAttackProperties)player).setComboCount(request.comboCount());
                HashMultimap comboAttributes = null;
                HashMultimap dualWieldingAttributes = null;
                HashMultimap sweepingModifiers = HashMultimap.create();
                double range = 18.0;
                if (attributes != null && attack != null) {
                    range = attributes.attackRange();
                    comboAttributes = HashMultimap.create();
                    double comboMultiplier = attack.damageMultiplier() - 1.0;
                    comboAttributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(COMBO_DAMAGE_MODIFIER_ID, "COMBO_DAMAGE_MULTIPLIER", comboMultiplier, AttributeModifier.Operation.MULTIPLY_BASE));
                    player.m_21204_().m_22178_((Multimap)comboAttributes);
                    float dualWieldingMultiplier = PlayerAttackHelper.getDualWieldingAttackDamageMultiplier((Player)player, hand) - 1.0f;
                    if (dualWieldingMultiplier != 0.0f) {
                        dualWieldingAttributes = HashMultimap.create();
                        dualWieldingAttributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(DUAL_WIELDING_MODIFIER_ID, "DUAL_WIELDING_DAMAGE_MULTIPLIER", (double)dualWieldingMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
                        player.m_21204_().m_22178_((Multimap)dualWieldingAttributes);
                    }
                    if (hand.isOffHand()) {
                        PlayerAttackHelper.setAttributesForOffHandAttack((Player)player, true);
                    }
                    SoundHelper.playSound(world, (Entity)player, attack.swingSound());
                    if (BetterCombat.config.allow_reworked_sweeping && request.entityIds().length > 1) {
                        boolean playEffects;
                        double multiplier = 1.0 - (double)(BetterCombat.config.reworked_sweeping_maximum_damage_penalty / (float)BetterCombat.config.reworked_sweeping_extra_target_count * (float)Math.min(BetterCombat.config.reworked_sweeping_extra_target_count, request.entityIds().length - 1));
                        int sweepingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)hand.itemStack());
                        double sweepingSteps = (double)BetterCombat.config.reworked_sweeping_enchant_restores / (double)Enchantments.f_44983_.m_6586_();
                        multiplier += (double)sweepingLevel * sweepingSteps;
                        multiplier = Math.min(multiplier, 1.0);
                        sweepingModifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(SWEEPING_MODIFIER_ID, "SWEEPING_DAMAGE_MODIFIER", multiplier - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
                        player.m_21204_().m_22178_((Multimap)sweepingModifiers);
                        boolean bl = playEffects = !BetterCombat.config.reworked_sweeping_sound_and_particles_only_for_swords || hand.itemStack().m_41720_() instanceof SwordItem;
                        if (BetterCombat.config.reworked_sweeping_plays_sound && playEffects) {
                            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
                        }
                        if (BetterCombat.config.reworked_sweeping_emits_particles && playEffects) {
                            player.m_36346_();
                        }
                    }
                }
                float attackCooldown = PlayerAttackHelper.getAttackCooldownTicksCapped((Player)player);
                float knockbackMultiplier = BetterCombat.config.knockback_reduced_for_fast_attacks ? MathHelper.clamp(attackCooldown / 12.5f, 0.1f, 1.0f) : 1.0f;
                int lastAttackedTicks = ((LivingEntityAccessor)player).getLastAttackedTicks();
                if (!useVanillaPacket) {
                    player.m_20260_(request.isSneaking());
                }
                for (int entityId : request.entityIds()) {
                    LivingEntity livingEntity;
                    boolean isBossPart = false;
                    Entity entity = world.m_6815_(entityId);
                    if (entity == null) {
                        isBossPart = true;
                        entity = world.m_143317_(entityId);
                    }
                    if (entity == null || entity.equals((Object)player.m_20202_()) && !TargetHelper.isAttackableMount(entity) || entity instanceof ArmorStand && ((ArmorStand)entity).m_31677_()) continue;
                    if (entity instanceof LivingEntity) {
                        livingEntity = (LivingEntity)entity;
                        if (BetterCombat.config.allow_fast_attacks) {
                            livingEntity.f_19802_ = 0;
                        }
                        if (knockbackMultiplier != 1.0f) {
                            ((ConfigurableKnockback)livingEntity).setKnockbackMultiplier_BetterCombat(knockbackMultiplier);
                        }
                    }
                    ((LivingEntityAccessor)player).setLastAttackedTicks(lastAttackedTicks);
                    if (!isBossPart && useVanillaPacket) {
                        ServerboundInteractPacket vanillaAttackPacket = ServerboundInteractPacket.m_179605_((Entity)entity, (boolean)request.isSneaking());
                        handler.m_6946_(vanillaAttackPacket);
                    } else {
                        if (entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity instanceof AbstractArrow || entity == player) {
                            handler.m_9942_((Component)Component.m_237115_((String)"multiplayer.disconnect.invalid_entity_attacked"));
                            LOGGER.warn("Player {} tried to attack an invalid entity", (Object)player.m_7755_().getString());
                            return;
                        }
                        player.m_5706_(entity);
                    }
                    if (!(entity instanceof LivingEntity)) continue;
                    livingEntity = (LivingEntity)entity;
                    if (knockbackMultiplier == 1.0f) continue;
                    ((ConfigurableKnockback)livingEntity).setKnockbackMultiplier_BetterCombat(1.0f);
                }
                if (!useVanillaPacket) {
                    player.m_9243_();
                }
                if (comboAttributes != null) {
                    player.m_21204_().m_22161_((Multimap)comboAttributes);
                    if (hand.isOffHand()) {
                        PlayerAttackHelper.setAttributesForOffHandAttack((Player)player, false);
                    }
                }
                if (dualWieldingAttributes != null) {
                    player.m_21204_().m_22161_(dualWieldingAttributes);
                }
                if (!sweepingModifiers.isEmpty()) {
                    player.m_21204_().m_22161_((Multimap)sweepingModifiers);
                }
                ((PlayerAttackProperties)player).setComboCount(-1);
            });
        });
    }
}

