/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.server;

import bogdan.refueled.RefueledMain;
import bogdan.refueled.Utils;
import bogdan.refueled.common.accessors.IVehicleAccess;
import bogdan.refueled.config.ServerConfig;
import bogdan.refueled.server.FuelTypeArgument;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class RefueledCommands {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"refueled").requires(commandSource -> commandSource.m_6761_(2));
        ((LiteralArgumentBuilder)command.then(Commands.m_82127_((String)"vehicle").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"fuel").then(Commands.m_82129_((String)"type", (ArgumentType)FuelTypeArgument.id()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(commandContext -> {
            Entity vehicle = EntityArgument.m_91452_((CommandContext)commandContext, (String)"entity");
            if (Utils.isCar(vehicle)) {
                int amount = (Integer)commandContext.getArgument("amount", Integer.class);
                ResourceLocation fluid = (ResourceLocation)commandContext.getArgument("type", ResourceLocation.class);
                ((IVehicleAccess)vehicle).refuel$setFuelType(fluid.toString());
                ((IVehicleAccess)vehicle).refuel$setFuel(amount);
                try {
                    ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237110_((String)"message.command.set.fuel.success", (Object[])new Object[]{vehicle.m_5446_().getString(), ForgeRegistries.FLUIDS.getHolder(fluid).map(holder -> ((Fluid)holder.get()).getFluidType().getDescriptionId()).orElse("null"), amount}), false);
                }
                catch (NullPointerException e) {
                    RefueledMain.LOGGER.debug("Fluid forge registry is null when trying to use the set fuel command on entity {} ({})", (Object)vehicle.m_5446_(), (Object)vehicle.m_20149_());
                }
                return 1;
            }
            ((CommandSourceStack)commandContext.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.fail.entity"));
            return 0;
        }))))).then(Commands.m_82127_((String)"health").then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(commandContext -> {
            Entity vehicle = EntityArgument.m_91452_((CommandContext)commandContext, (String)"vehicle");
            if (Utils.isCar(vehicle)) {
                float health = ((Double)commandContext.getArgument("amount", Double.class)).floatValue();
                ((IVehicleAccess)vehicle).refuel$setHealth(health);
                if (health <= 0.0f) {
                    ((IVehicleAccess)vehicle).refuel$kill();
                }
                ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237110_((String)"message.command.set.health.success", (Object[])new Object[]{vehicle.m_5446_().getString(), Float.valueOf(health)}), false);
                return 1;
            }
            ((CommandSourceStack)commandContext.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.fail.entity"));
            return 0;
        })))).then(Commands.m_82127_((String)"energy").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(commandContext -> {
            Entity vehicle = EntityArgument.m_91452_((CommandContext)commandContext, (String)"vehicle");
            if (Utils.isCar(vehicle)) {
                int energy = (Integer)commandContext.getArgument("amount", Integer.class);
                ((IVehicleAccess)vehicle).refuel$setBattery(energy);
                ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237110_((String)"message.command.set.energy.success", (Object[])new Object[]{vehicle.m_5446_().getString(), energy}), false);
                return 1;
            }
            ((CommandSourceStack)commandContext.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.fail.entity"));
            return 0;
        })))).then(Commands.m_82127_((String)"temperature").then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).executes(commandContext -> {
            Entity vehicle = EntityArgument.m_91452_((CommandContext)commandContext, (String)"vehicle");
            if (Utils.isCar(vehicle)) {
                float heat = ((Double)commandContext.getArgument("amount", Double.class)).floatValue();
                ((IVehicleAccess)vehicle).refuel$setTemperature(heat);
                if ((double)heat <= -273.15) {
                    ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237110_((String)"message.command.set.heat.success.abszero", (Object[])new Object[]{vehicle.m_5446_().getString()}), false);
                } else {
                    ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237110_((String)"message.command.set.heat.success", (Object[])new Object[]{vehicle.m_5446_().getString(), Float.valueOf(heat)}), false);
                }
                return 1;
            }
            ((CommandSourceStack)commandContext.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.fail.entity"));
            return 0;
        }))))))).then(Commands.m_82127_((String)"serverconfig").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"type", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)context)).then(Commands.m_82129_((String)"efficiency", (ArgumentType)DoubleArgumentType.doubleArg()).executes(commandContext -> {
            BlockInput input = (BlockInput)commandContext.getArgument("type", BlockInput.class);
            ResourceLocation type = ForgeRegistries.FLUIDS.getKey((Object)input.m_114669_().m_60819_().m_76152_());
            if (type != null) {
                ArrayList<List<String>> newList = new ArrayList<List<String>>((Collection)ServerConfig.fuelEff.get());
                Double efficiency = (Double)commandContext.getArgument("efficiency", Double.class);
                for (int i = 0; i < newList.size(); ++i) {
                    List keyValue = (List)newList.get(i);
                    if (!Objects.equals(keyValue.get(0), type.toString())) continue;
                    if (efficiency == Double.parseDouble((String)keyValue.get(1))) {
                        ((CommandSourceStack)commandContext.getSource()).m_81352_((Component)Component.m_237110_((String)"message.command.fail.config.exists", (Object[])new Object[]{ForgeRegistries.FLUIDS.getHolder(type).map(holder -> ((Fluid)holder.get()).getFluidType().getDescriptionId()).orElse("null"), String.valueOf(efficiency)}));
                        return 0;
                    }
                    if (efficiency > 0.0) {
                        newList.set(i, List.of(type.toString(), String.valueOf(efficiency)));
                        ServerConfig.fuelEff.set(newList);
                        ServerConfig.fuelEff.save();
                        ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237110_((String)"message.command.success.config", (Object[])new Object[]{ForgeRegistries.FLUIDS.getHolder(type).map(holder -> ((Fluid)holder.get()).getFluidType().getDescriptionId()).orElse("null"), efficiency}), false);
                        return 1;
                    }
                    ((CommandSourceStack)commandContext.getSource()).m_81352_((Component)Component.m_237110_((String)"message.command.fail.config.efficiency", (Object[])new Object[]{efficiency}));
                    return 0;
                }
                if (efficiency > 0.0) {
                    newList.add(List.of(type.toString(), String.valueOf(efficiency)));
                    ServerConfig.fuelEff.set(newList);
                    ServerConfig.fuelEff.save();
                    ((CommandSourceStack)commandContext.getSource()).m_288197_(() -> Component.m_237110_((String)"message.command.success.config", (Object[])new Object[]{ForgeRegistries.FLUIDS.getHolder(type).map(holder -> ((Fluid)holder.get()).getFluidType().getDescriptionId()).orElse("null"), efficiency}), false);
                    return 1;
                }
                ((CommandSourceStack)commandContext.getSource()).m_81352_((Component)Component.m_237110_((String)"message.command.fail.config.efficiency", (Object[])new Object[]{efficiency}));
            } else {
                ((CommandSourceStack)commandContext.getSource()).m_81352_((Component)Component.m_237110_((String)"message.command.fail.config.location", (Object[])new Object[]{input.m_114669_().m_60734_().m_49954_()}));
            }
            return 0;
        })))));
        dispatcher.register(command);
    }

    @SubscribeEvent
    public void registerCommand(RegisterCommandsEvent event) {
        this.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }
}

