/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.mixin.common.car;

import bogdan.refueled.RefueledRegistry;
import bogdan.refueled.Utils;
import bogdan.refueled.common.accessors.IVehicleAccess;
import bogdan.refueled.common.gui.CarGUI;
import bogdan.refueled.common.gui.TruckGUI;
import bogdan.refueled.common.network.ControlVehicle;
import bogdan.refueled.common.network.RefueledChannel;
import bogdan.refueled.common.network.VehicleCrash;
import bogdan.refueled.common.network.VehicleGUI;
import bogdan.refueled.config.ServerConfig;
import bogdan.refueled.mixin.common.accessor.IBiomeAccess;
import bogdan.refueled.mixin.common.accessor.IEntityAccess;
import bogdan.refueled.mixin.common.accessor.IHeightAccess;
import com.dragn0007.dragnvehicles.registry.ItemRegistry;
import com.dragn0007.dragnvehicles.vehicle.car.Car;
import com.dragn0007.dragnvehicles.vehicle.classic.Classic;
import com.dragn0007.dragnvehicles.vehicle.motorcycle.Motorcycle;
import com.dragn0007.dragnvehicles.vehicle.sportcar.SportCar;
import com.dragn0007.dragnvehicles.vehicle.suv.SUV;
import com.dragn0007.dragnvehicles.vehicle.truck.Truck;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Car.class, Classic.class, Truck.class, SUV.class, SportCar.class, Motorcycle.class})
public abstract class CarMixin
extends Entity
implements IVehicleAccess,
MenuProvider {
    @Unique
    private static final int refuel$type = List.of(Car.class, Classic.class, Truck.class, SUV.class, SportCar.class, Motorcycle.class).indexOf(CarMixin.class);
    @Unique
    private static final EntityDataAccessor<String> refuel$FUEL_TYPE = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    @Unique
    private static final EntityDataAccessor<Float> refuel$TEMPERATURE = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Unique
    private static final EntityDataAccessor<Float> refuel$SPEED = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Unique
    private static final EntityDataAccessor<Integer> refuel$FUEL_AMOUNT = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Integer> refuel$BATTERY_LEVEL = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Integer> refuel$STARTING_TIME = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Boolean> refuel$STARTING = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> refuel$STARTED = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> refuel$FORWARD = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> refuel$BACKWARD = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> refuel$LEFT = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> refuel$RIGHT = SynchedEntityData.m_135353_(CarMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    public LazyOptional<IFluidHandler> refuel$lazyFluid;
    @Unique
    public LazyOptional<IEnergyStorage> refuel$lazyEnergy;
    @Unique
    public Container refuel$internalInventory;
    @Shadow(remap=false)
    public SimpleContainer inventory;
    @Shadow(remap=false)
    @Final
    private static EntityDataAccessor<Float> HEALTH;
    @Unique
    private static boolean refuel$carStopped;
    @Unique
    private static boolean refuel$carStarted;
    @Unique
    public float refuel$deltaRotation = 0.0f;
    @Unique
    private final boolean[] refuel$lastInputs = new boolean[4];
    @Unique
    private final boolean[] refuel$lastTickInputs = new boolean[4];
    @Unique
    private boolean[] refuel$randomInputs = new boolean[2];
    @Unique
    private int[] refuel$drunkTicks = new int[4];
    @Unique
    private int refuel$timeToStart;
    @Unique
    private int refuel$timeSinceStarted;
    @Unique
    private boolean refuel$killed = false;
    @Unique
    private final BlockingQueue<Runnable> refuel$tasks = new LinkedBlockingQueue<Runnable>();
    @Unique
    private int refuel$sinceCollided;

    public CarMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void refuel$addInit(EntityType<?> entityType, Level level, CallbackInfo ci) {
        this.refuel$internalInventory = new SimpleContainer(27);
        this.refuel$lazyFluid = LazyOptional.of(() -> new IFluidHandler(){

            public int getTanks() {
                return 1;
            }

            @Nonnull
            public FluidStack getFluidInTank(int tank) {
                return tank == 0 ? new FluidStack(CarMixin.this.refuel$getFluid(), CarMixin.this.refuel$getFuel()) : FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                return CarMixin.this.refuel$getMaxFuel();
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                if (CarMixin.this.refuel$getFluid() != Fluids.f_76191_) {
                    return CarMixin.this.refuel$getFluid() == stack.getFluid();
                }
                return ServerConfig.getFuelEfficiency(stack.getFluid()) > 0.0f;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                Fluid fluid = CarMixin.this.refuel$getFluid();
                if (!this.isFluidValid(0, resource)) {
                    return 0;
                }
                ResourceLocation fluidKey = ForgeRegistries.FLUIDS.getKey((Object)resource.getFluid());
                if (fluidKey == null) {
                    return 0;
                }
                int fuel = CarMixin.this.refuel$getFuel();
                int maxFuel = CarMixin.this.refuel$getMaxFuel();
                int amount = Math.min(resource.getAmount(), maxFuel - fuel);
                if (action.execute()) {
                    int i = fuel + amount;
                    if (i > maxFuel) {
                        i = maxFuel;
                    }
                    if (fluid == Fluids.f_76191_) {
                        CarMixin.this.f_19804_.m_135381_(refuel$FUEL_TYPE, (Object)fluidKey.toString());
                    }
                    CarMixin.this.refuel$setFuel(i);
                }
                return amount;
            }

            @Nonnull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (!this.isFluidValid(0, resource)) {
                    return FluidStack.EMPTY;
                }
                return this.drain(resource.getAmount(), action);
            }

            @Nonnull
            public FluidStack drain(int toDrain, IFluidHandler.FluidAction action) {
                Fluid fluid = CarMixin.this.refuel$getFluid();
                if (fluid == Fluids.f_76191_) {
                    return FluidStack.EMPTY;
                }
                int fuel = CarMixin.this.refuel$getFuel();
                int actuallyDrained = Math.min(toDrain, fuel);
                if (action.execute()) {
                    CarMixin.this.refuel$setFuel(fuel - actuallyDrained);
                }
                return new FluidStack(fluid, actuallyDrained);
            }
        });
        this.refuel$lazyEnergy = LazyOptional.of(() -> new IEnergyStorage(){

            public int receiveEnergy(int amount, boolean simulate) {
                if (amount <= 0) {
                    return 0;
                }
                int energy = CarMixin.this.refuel$getBattery();
                int input = Math.min(CarMixin.this.refuel$getMaxBattery() - energy, amount);
                if (!simulate) {
                    CarMixin.this.refuel$setBattery(energy + input);
                }
                return input;
            }

            public int extractEnergy(int amount, boolean simulate) {
                if (amount <= 0) {
                    return 0;
                }
                int energy = CarMixin.this.refuel$getBattery();
                int extracted = Math.min(energy, amount);
                if (!simulate) {
                    CarMixin.this.refuel$setBattery(energy - extracted);
                }
                return extracted;
            }

            public int getEnergyStored() {
                return CarMixin.this.refuel$getBattery();
            }

            public int getMaxEnergyStored() {
                return CarMixin.this.refuel$getMaxBattery();
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return true;
            }
        });
    }

    @Inject(method={"interact*"}, at={@At(value="HEAD")}, cancellable=true)
    private void refuel$injectMoreInteraction(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        LazyOptional lazy;
        ItemStack item = player.m_21120_(hand);
        if (Utils.isCar(item.m_41720_())) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
            return;
        }
        if (player.m_6144_() && (item.m_41720_() == Items.f_42574_ || item.m_204131_().anyMatch(tag -> tag.f_203868_().toString().equals("forge:tools/wrench")))) {
            this.refuel$convertIntoItems();
            ItemStack egg = this.refuel$getEgg();
            if (player.m_150109_().m_36054_(egg)) {
                player.m_36176_(egg, true);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_));
            return;
        }
        if (item.m_41720_() == Items.f_42656_) {
            this.m_6593_(item.m_41786_());
            item.m_41774_(1);
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_));
            return;
        }
        LazyOptional lazyItem = item.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (player.m_6144_() && lazyItem.isPresent() && (lazy = this.getCapability(ForgeCapabilities.FLUID_HANDLER)).isPresent()) {
            BucketItem bucket;
            FluidStack fuel;
            IFluidHandler handler = (IFluidHandler)lazy.resolve().get();
            IFluidHandlerItem itemHandler = (IFluidHandlerItem)lazyItem.resolve().get();
            Item item2 = item.m_41720_();
            if (item2 instanceof BucketItem && handler.fill(fuel = new FluidStack((bucket = (BucketItem)item2).getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                handler.fill(fuel, IFluidHandler.FluidAction.EXECUTE);
                player.m_21008_(hand, BucketItem.m_40699_((ItemStack)item, (Player)player));
            }
            FluidStack ourStored = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            FluidStack itemStored = itemHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            if (itemStored.isEmpty()) {
                if (itemHandler.fill(ourStored, IFluidHandler.FluidAction.SIMULATE) > 0) {
                    int filled = itemHandler.fill(ourStored, IFluidHandler.FluidAction.EXECUTE);
                    handler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_));
                } else {
                    cir.setReturnValue((Object)InteractionResult.FAIL);
                }
            } else if (handler.fill(itemStored, IFluidHandler.FluidAction.SIMULATE) > 0) {
                int filled = handler.fill(ourStored, IFluidHandler.FluidAction.EXECUTE);
                itemHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_));
            } else {
                cir.setReturnValue((Object)InteractionResult.FAIL);
            }
        }
    }

    @Shadow(remap=false)
    protected abstract Vec3 calcOffset(double var1, double var3, double var5);

    public void m_19956_(@NotNull Entity entity, @NotNull Entity.MoveFunction moveFunction) {
        int i = this.m_20197_().indexOf(entity);
        if (i == -1) {
            return;
        }
        entity.m_146884_(this.calcOffset(this.refuel$getSeatPositions()[i].f_82479_, this.refuel$getSeatPositions()[i].f_82480_, this.refuel$getSeatPositions()[i].f_82481_));
        float sizeMod = this instanceof Motorcycle ? sizeFactor.floatValue() * 1.33f : sizeFactor.floatValue();
        float offset = entity.m_6972_((Pose)Pose.SITTING).f_20377_ * 0.5f * (1.0f - sizeMod);
        AABB oldBB = entity.m_20191_();
        entity.m_20011_(new AABB(oldBB.f_82288_ + (double)offset, oldBB.f_82289_ + (double)entity.m_20206_() * 0.3515625 * (double)sizeMod, oldBB.f_82290_ + (double)offset, oldBB.f_82291_ - (double)offset, oldBB.f_82292_ - (double)entity.m_20206_() * (1.0 - (double)sizeMod), oldBB.f_82293_ - (double)offset));
        ((IHeightAccess)entity).setEyeHeight(entity.m_20236_(Pose.SITTING) * sizeMod);
        entity.m_146922_(entity.m_146908_() + this.refuel$deltaRotation);
        entity.m_5616_(entity.m_6080_() + this.refuel$deltaRotation);
    }

    public void m_7340_(@NotNull Entity entityToUpdate) {
        if (((Boolean)ServerConfig.correctYaw.get()).booleanValue()) {
            this.refuel$applyYawToEntity(entityToUpdate);
        }
    }

    @Unique
    public void refuel$applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = (Boolean)ServerConfig.restrictYaw.get() != false ? Mth.m_14036_((float)f, (float)-135.0f, (float)135.0f) : f;
        entityToUpdate.f_19859_ += f1 - f;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + f1 - f);
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void refuel$saveDataToNBT(CompoundTag tag, CallbackInfo ci) {
        tag.m_128350_("temperature", ((Float)this.f_19804_.m_135370_(refuel$TEMPERATURE)).floatValue());
        tag.m_128405_("energy", ((Integer)this.f_19804_.m_135370_(refuel$BATTERY_LEVEL)).intValue());
        Utils.saveInventory(tag, "internalInventory", this.refuel$internalInventory);
        tag.m_128365_("Fluid", (Tag)new FluidStack(this.refuel$getFluid(), this.refuel$getFuel()).writeToNBT(new CompoundTag()));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void refuel$readDataFromNBT(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("temperature")) {
            this.f_19804_.m_135381_(refuel$TEMPERATURE, (Object)Float.valueOf(tag.m_128457_("temperature")));
        }
        if (tag.m_128441_("energy")) {
            this.f_19804_.m_135381_(refuel$BATTERY_LEVEL, (Object)tag.m_128451_("energy"));
        }
        if (tag.m_128441_("internalInventory")) {
            Utils.readInventory(tag, "internalInventory", this.refuel$internalInventory);
        }
        if (tag.m_128441_("Fluid")) {
            float efficiency;
            FluidStack temp = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Fluid"));
            if (temp.isEmpty()) {
                temp = FluidStack.EMPTY;
            }
            if ((efficiency = ServerConfig.getFuelEfficiency(temp.getFluid())) > 0.0f) {
                this.f_19804_.m_135381_(refuel$FUEL_AMOUNT, (Object)temp.getAmount());
                this.f_19804_.m_135381_(refuel$FUEL_TYPE, (Object)tag.m_128469_("Fluid").m_128461_("FluidName"));
            }
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void refuel$syncData(CallbackInfo ci) {
        this.f_19804_.m_135372_(refuel$FUEL_TYPE, (Object)"");
        this.f_19804_.m_135372_(refuel$SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(refuel$TEMPERATURE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(refuel$FUEL_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(refuel$BATTERY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(refuel$STARTING_TIME, (Object)0);
        this.f_19804_.m_135372_(refuel$STARTING, (Object)false);
        this.f_19804_.m_135372_(refuel$STARTED, (Object)false);
        this.f_19804_.m_135372_(refuel$FORWARD, (Object)false);
        this.f_19804_.m_135372_(refuel$BACKWARD, (Object)false);
        this.f_19804_.m_135372_(refuel$LEFT, (Object)false);
        this.f_19804_.m_135372_(refuel$RIGHT, (Object)false);
    }

    @Inject(remap=false, method={"getCapability"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true)
    private void refuel$addFluidCapability(@NotNull Capability<?> cap, @Nullable Direction side, CallbackInfoReturnable<LazyOptional<?>> cir) {
        if (this.m_6084_() && cap == ForgeCapabilities.FLUID_HANDLER) {
            cir.setReturnValue((Object)this.refuel$lazyFluid.cast());
        }
        if (this.m_6084_() && cap == ForgeCapabilities.ENERGY) {
            cir.setReturnValue((Object)this.refuel$lazyEnergy.cast());
        }
    }

    @Inject(remap=false, method={"invalidateCaps"}, at={@At(value="TAIL")})
    private void refuel$removeCap(CallbackInfo ci) {
        if (this.refuel$lazyFluid != null) {
            this.refuel$lazyFluid.invalidate();
        }
        if (this.refuel$lazyEnergy != null) {
            this.refuel$lazyEnergy.invalidate();
        }
    }

    @Override
    public Container refuel$getContainer() {
        return this.refuel$internalInventory;
    }

    @Override
    public float refuel$getSpeed() {
        return ((Float)this.f_19804_.m_135370_(refuel$SPEED)).floatValue();
    }

    @Unique
    public void refuel$setSpeed(float speed) {
        this.f_19804_.m_135381_(refuel$SPEED, (Object)Float.valueOf(speed));
    }

    @Override
    public float refuel$getHealth() {
        return ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue();
    }

    @Override
    public void refuel$setHealth(float health) {
        if (health > this.refuel$getMaxHealth()) {
            health = this.refuel$getMaxHealth();
        } else if (health <= 0.0f) {
            health = 0.0f;
        }
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(health));
    }

    @Unique
    public void refuel$addDamage(float damage) {
        float newHealth = this.refuel$getHealth() - damage;
        this.refuel$setHealth(newHealth);
        if (newHealth <= 0.0f) {
            this.refuel$kill();
        }
    }

    @Override
    @Unique
    public int refuel$getFuel() {
        return (Integer)this.f_19804_.m_135370_(refuel$FUEL_AMOUNT);
    }

    @Override
    public void refuel$setFuel(int fuel) {
        if (fuel < 0) {
            fuel = 0;
            this.f_19804_.m_135381_(refuel$FUEL_TYPE, (Object)"");
        }
        fuel = Math.min(fuel, this.refuel$getMaxFuel());
        this.f_19804_.m_135381_(refuel$FUEL_AMOUNT, (Object)fuel);
    }

    @Override
    public Fluid refuel$getFluid() {
        ResourceLocation key = ResourceLocation.m_135820_((String)((String)this.f_19804_.m_135370_(refuel$FUEL_TYPE)));
        if (key == null) {
            return Fluids.f_76191_;
        }
        return ForgeRegistries.FLUIDS.getHolder(key).map(Holder::get).orElse(Fluids.f_76191_);
    }

    @Override
    public void refuel$setFuelType(String type) {
        this.f_19804_.m_135381_(refuel$FUEL_TYPE, (Object)type);
    }

    @Override
    public int refuel$getBattery() {
        return (Integer)this.f_19804_.m_135370_(refuel$BATTERY_LEVEL);
    }

    @Override
    public void refuel$setBattery(int level) {
        this.f_19804_.m_135381_(refuel$BATTERY_LEVEL, (Object)Mth.m_14045_((int)level, (int)0, (int)this.refuel$getMaxBattery()));
    }

    @Override
    public float refuel$getTemperature() {
        return ((Float)this.f_19804_.m_135370_(refuel$TEMPERATURE)).floatValue();
    }

    @Override
    public void refuel$setTemperature(float heat) {
        this.f_19804_.m_135381_(refuel$TEMPERATURE, (Object)Float.valueOf(heat));
    }

    @Override
    public boolean refuel$isStarted() {
        return (Boolean)this.f_19804_.m_135370_(refuel$STARTED);
    }

    @Override
    public void refuel$setStarting(boolean starting, boolean playFailSound) {
        if (starting) {
            if (this.refuel$getBattery() <= 0) {
                return;
            }
            if (this.refuel$isStarted()) {
                this.refuel$setStarted(false, true, false);
                refuel$carStopped = true;
                return;
            }
        } else {
            if (refuel$carStarted || refuel$carStopped) {
                refuel$carStopped = false;
                refuel$carStarted = false;
                return;
            }
            if (playFailSound && this.refuel$getBattery() > 0) {
                this.refuel$playFailSound();
            }
        }
        this.f_19804_.m_135381_(refuel$STARTING, (Object)starting);
    }

    @Unique
    private void refuel$setStarted(boolean started, boolean playStopSound, boolean playFailSound) {
        if (!started && playStopSound) {
            this.refuel$playStopSound();
        } else if (!started && playFailSound) {
            this.refuel$playFailSound();
        }
        this.f_19804_.m_135381_(refuel$STARTED, (Object)started);
    }

    @Unique
    public void refuel$playStopSound() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_6263_(null, (double)this.m_20183_().m_123341_() + 0.5, (double)this.m_20183_().m_123342_() + 0.5, (double)this.m_20183_().m_123343_() + 0.5, SoundEvents.f_11744_, SoundSource.MASTER, 1.0f, 0.0f);
        }
    }

    @Unique
    public void refuel$playFailSound() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_6263_(null, (double)this.m_20183_().m_123341_() + 0.5, (double)this.m_20183_().m_123342_() + 0.5, (double)this.m_20183_().m_123343_() + 0.5, SoundEvents.f_11937_, SoundSource.MASTER, 1.0f, 1.0f + this.refuel$getBatterySoundPitchLevel());
        }
    }

    @Unique
    public void refuel$playCrashSound() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_6263_(null, (double)this.m_20183_().m_123341_() + 0.5, (double)this.m_20183_().m_123342_() + 0.5, (double)this.m_20183_().m_123343_() + 0.5, SoundEvents.f_11668_, SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    @Override
    @Unique
    public float refuel$getModifier() {
        float multiplier = ServerConfig.getRoadBlockMultiplier(this.m_20075_());
        if (multiplier > 0.0f) {
            return multiplier;
        }
        return ((Double)ServerConfig.offroadSpeed.get()).floatValue();
    }

    @Unique
    public float refuel$getRollResistance() {
        return ((Double)ServerConfig.rollResistance.get()).floatValue();
    }

    @Unique
    public void refuel$setForward(boolean forward) {
        this.f_19804_.m_135381_(refuel$FORWARD, (Object)forward);
    }

    @Unique
    public void refuel$setBackward(boolean backward) {
        this.f_19804_.m_135381_(refuel$BACKWARD, (Object)backward);
    }

    @Unique
    public void refuel$setLeft(boolean left) {
        this.f_19804_.m_135381_(refuel$LEFT, (Object)left);
    }

    @Unique
    public void refuel$setRight(boolean right) {
        this.f_19804_.m_135381_(refuel$RIGHT, (Object)right);
    }

    @Override
    @Unique
    public boolean refuel$isForward() {
        return this.refuel$getDriver() != null && this.refuel$canPlayerDriveCar(this.refuel$getDriver()) && (Boolean)this.f_19804_.m_135370_(refuel$FORWARD) != false;
    }

    @Override
    @Unique
    public boolean refuel$isBackward() {
        return this.refuel$getDriver() != null && this.refuel$canPlayerDriveCar(this.refuel$getDriver()) && (Boolean)this.f_19804_.m_135370_(refuel$BACKWARD) != false;
    }

    @Override
    @Unique
    public boolean refuel$isLeft() {
        return this.refuel$getDriver() != null && this.refuel$canPlayerDriveCar(this.refuel$getDriver()) && (Boolean)this.f_19804_.m_135370_(refuel$LEFT) != false;
    }

    @Override
    @Unique
    public boolean refuel$isRight() {
        return this.refuel$getDriver() != null && this.refuel$canPlayerDriveCar(this.refuel$getDriver()) && (Boolean)this.f_19804_.m_135370_(refuel$RIGHT) != false;
    }

    @Unique
    private Player refuel$getDriver() {
        Player player;
        Entity firstPassenger = this.m_146895_();
        return firstPassenger instanceof Player ? (player = (Player)firstPassenger) : null;
    }

    @Unique
    private void refuel$handleInput() {
        Player driver;
        if (!this.m_20160_()) {
            this.refuel$setForward(false);
            this.refuel$setBackward(false);
            this.refuel$setLeft(false);
            this.refuel$setRight(false);
        }
        MobEffectInstance nausea = (driver = this.refuel$getDriver()) == null || !this.refuel$canPlayerDriveCar(driver) ? null : driver.m_21124_(MobEffects.f_19604_);
        int amp = -1;
        if (nausea != null) {
            amp = nausea.m_19564_();
            if (this.f_19797_ % (this.f_19796_.m_188503_(amp) + 1) == 0) {
                this.refuel$randomInputs = new boolean[]{this.f_19796_.m_188503_(10 + Mth.m_14143_((float)(driver.m_21233_() / 10.0f)) - Math.min(amp, 9 + Mth.m_14143_((float)(driver.m_21233_() / 10.0f)))) == 0 ? this.f_19796_.m_188499_() : this.refuel$isLeft(), this.f_19796_.m_188503_(10 + Mth.m_14143_((float)(driver.m_21233_() / 10.0f)) - Math.min(amp, 9 + Mth.m_14143_((float)(driver.m_21233_() / 10.0f)))) == 0 ? this.f_19796_.m_188499_() : this.refuel$isRight()};
            }
        } else {
            this.refuel$drunkTicks = new int[4];
        }
        float turnMod = 1.0f;
        float maxSp = this.refuel$getMaxSpeed() * this.refuel$getModifier();
        float maxBackSp = this.refuel$getMaxReverseSpeed() * this.refuel$getModifier();
        float speed = Utils.subtractToZero(this.refuel$getSpeed(), this.refuel$getRollResistance());
        if (amp == -1) {
            if (this.refuel$isForward() && speed <= maxSp) {
                speed = Math.min(speed + this.refuel$getAcceleration(), maxSp);
            }
            if (this.refuel$isBackward()) {
                if (this.m_9236_().f_46443_) {
                    turnMod = -1.0f;
                }
                if (speed >= -maxBackSp) {
                    speed = Math.max(speed - this.refuel$getAcceleration(), -maxBackSp);
                }
            }
        } else {
            if (this.refuel$isForward() != this.refuel$lastTickInputs[0]) {
                this.refuel$drunkTicks[0] = 0;
            }
            if (this.refuel$drunkTicks[0] > amp) {
                this.refuel$lastInputs[0] = this.refuel$isForward();
            } else {
                this.refuel$drunkTicks[0] = this.refuel$drunkTicks[0] + 1;
            }
            if (this.refuel$lastInputs[0] && speed <= maxSp) {
                speed = Math.min(speed + this.refuel$getAcceleration(), maxSp);
            }
            this.refuel$lastTickInputs[0] = this.refuel$isForward();
            if (this.refuel$isBackward() != this.refuel$lastTickInputs[1]) {
                this.refuel$drunkTicks[1] = 0;
            }
            if (this.refuel$drunkTicks[1] > amp) {
                this.refuel$lastInputs[1] = this.refuel$isBackward();
            } else {
                this.refuel$drunkTicks[1] = this.refuel$drunkTicks[1] + 1;
            }
            if (this.refuel$lastInputs[1]) {
                if (this.m_9236_().f_46443_) {
                    turnMod = -1.0f;
                }
                if (speed >= -maxBackSp) {
                    speed = Math.max(speed - this.refuel$getAcceleration(), -maxBackSp);
                }
            }
            this.refuel$lastTickInputs[1] = this.refuel$isBackward();
        }
        this.refuel$setSpeed(speed);
        float rotationSpeed = 0.0f;
        if (Math.abs(speed) > 0.02f) {
            rotationSpeed = Mth.m_14154_((float)(this.refuel$getRotationModifier() / (float)Math.pow(speed, 2.0)));
            rotationSpeed = Mth.m_14036_((float)rotationSpeed, (float)this.refuel$getHighSpeedSteering(), (float)this.refuel$getLowSpeedSteering());
        }
        this.refuel$deltaRotation = 0.0f;
        if (speed < 0.0f) {
            rotationSpeed = -rotationSpeed;
        }
        if (amp == -1) {
            if (this.refuel$isLeft()) {
                this.refuel$deltaRotation -= rotationSpeed;
            }
            if (this.refuel$isRight()) {
                this.refuel$deltaRotation += rotationSpeed;
            }
        } else {
            if (this.refuel$isLeft() != this.refuel$lastTickInputs[2]) {
                this.refuel$drunkTicks[2] = 0;
            }
            if (this.refuel$drunkTicks[2] > amp) {
                this.refuel$lastInputs[2] = this.refuel$randomInputs[0];
            } else {
                this.refuel$drunkTicks[2] = this.refuel$drunkTicks[2] + 1;
            }
            if (this.refuel$lastInputs[2]) {
                this.refuel$deltaRotation -= rotationSpeed;
            }
            this.refuel$lastTickInputs[2] = this.refuel$isLeft();
            if (this.refuel$isRight() != this.refuel$lastTickInputs[3]) {
                this.refuel$drunkTicks[3] = 0;
            }
            if (this.refuel$drunkTicks[3] > amp) {
                this.refuel$lastInputs[3] = this.refuel$randomInputs[1];
            } else {
                this.refuel$drunkTicks[3] = this.refuel$drunkTicks[3] + 1;
            }
            if (this.refuel$lastInputs[3]) {
                this.refuel$deltaRotation += rotationSpeed;
            }
            this.refuel$lastTickInputs[3] = this.refuel$isRight();
        }
        if (this.m_9236_().f_46443_) {
            this.refuel$rotateWheels(this.refuel$deltaRotation * turnMod, rotationSpeed, speed);
        }
        this.m_146922_(this.m_146908_() + this.refuel$deltaRotation);
        float delta = Math.abs(this.m_146908_() - this.f_19859_);
        while (this.m_146908_() > 180.0f) {
            this.m_146922_(this.m_146908_() - 360.0f);
            this.f_19859_ = this.m_146908_() - delta;
        }
        while (this.m_146908_() <= -180.0f) {
            this.m_146922_(this.m_146908_() + 360.0f);
            this.f_19859_ = delta + this.m_146908_();
        }
        this.m_20334_(CarMixin.refuel$calculateMotionX(this.refuel$getSpeed(), this.m_146908_()), this.m_20184_().f_82480_, CarMixin.refuel$calculateMotionZ(this.refuel$getSpeed(), this.m_146908_()));
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void m_8119_() {
        float tempToReach;
        int time;
        Runnable task;
        if (this.m_9236_().f_46443_) {
            this.refuel$updateLastYRot();
            this.refuel$updateClientPos();
            this.refuel$tickLerp();
        }
        super.m_8119_();
        while ((task = (Runnable)this.refuel$tasks.poll()) != null) {
            task.run();
        }
        if (this.refuel$isStarted() && !this.refuel$canEngineStayOn()) {
            this.refuel$setStarted(false);
        }
        this.refuel$updateGravity();
        this.refuel$handleInput();
        if (this.m_20077_() && this.f_19797_ % 2 == 0) {
            this.refuel$addDamage(1.0f);
        }
        if (this.refuel$isStarted() || Utils.getHP(this) <= 1) {
            this.refuel$particles();
        }
        this.refuel$fuelTick();
        this.refuel$checkSlots();
        if (this.m_9236_().f_46443_) {
            this.refuel$updateWheelRotation();
            this.refuel$displayInfo();
            this.refuel$updateSounds();
            if (this.refuel$isStarted()) {
                ++this.refuel$timeSinceStarted;
                if (this.f_19797_ % 2 == 0) {
                    this.refuel$spawnParticles(this.refuel$getSpeed() > 0.1f);
                    this.refuel$spawnParticles(this.refuel$getSpeed() > 0.1f);
                    if (CarMixin.class.equals(Motorcycle.class) || CarMixin.class.equals(SportCar.class)) {
                        this.refuel$spawnParticles(this.refuel$getSpeed() > 0.1f);
                        this.refuel$spawnParticles(this.refuel$getSpeed() > 0.1f);
                    }
                }
            } else {
                this.refuel$timeSinceStarted = 0;
            }
            this.refuel$angleTick();
            return;
        }
        if (this.refuel$isStarting()) {
            this.refuel$setBattery(this.refuel$getBattery() - this.refuel$getBatteryUsage());
            this.refuel$setStartingTime(this.refuel$getStartingTime() + 1);
            if (this.refuel$getBattery() <= 0) {
                this.refuel$setStarting(false, true);
            }
        } else {
            this.refuel$setStartingTime(0);
        }
        if ((time = this.refuel$getStartingTime()) > 0) {
            if (this.refuel$timeToStart <= 0) {
                this.refuel$timeToStart = this.refuel$getTimeToStart();
            }
            if (time > this.refuel$getTimeToStart()) {
                this.refuel$startCarEngine();
                this.refuel$timeToStart = 0;
            }
        }
        if (this.refuel$isStarted()) {
            this.refuel$setStartingTime(0);
            refuel$carStarted = true;
        }
        if (this.f_19797_ % 20 != 0) {
            return;
        }
        float speedPerc = this.refuel$getSpeed() / this.refuel$getMaxSpeed();
        int tempRate = Math.min(Mth.m_14143_((float)speedPerc) * 10 + 1, 5);
        if (this.refuel$isStarted()) {
            this.refuel$setBattery(this.refuel$getBattery() + Mth.m_14143_((float)(speedPerc * 4.0f - (1.0f - speedPerc) * 2.0f)));
        }
        float rate = (float)tempRate * 0.2f + (this.f_19796_.m_188501_() - 0.5f) * 0.1f;
        float temp = this.refuel$getTemperature();
        if (Utils.isInBounds(temp, tempToReach = this.refuel$getTemperatureToReach(), rate)) {
            this.refuel$setTemperature(tempToReach);
        } else {
            if (tempToReach < temp) {
                rate = -rate;
            }
            this.refuel$setTemperature(temp + rate);
        }
    }

    @Override
    public Vec3 refuel$getSeatPosition(Entity player) {
        if (!this.m_20197_().contains(player)) {
            return null;
        }
        return this.refuel$getSeatPositions()[this.m_20197_().indexOf(player)];
    }

    @Unique
    private static double refuel$calculateMotionX(float speed, float rotationYaw) {
        return Mth.m_14031_((float)(-rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    @Unique
    private static double refuel$calculateMotionZ(float speed, float rotationYaw) {
        return Mth.m_14089_((float)(rotationYaw * ((float)Math.PI / 180))) * speed;
    }

    @Override
    public void refuel$onCollision(float speed) {
        if (this.m_9236_().f_46443_) {
            RefueledChannel.sendToServer(new VehicleCrash(this, speed));
        }
        this.refuel$setSpeed(0.0f);
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        float percSpeed = speed / this.refuel$getMaxSpeed();
        float totalDamage = percSpeed * 5.0f;
        this.refuel$playCrashSound();
        this.refuel$setStarted(false);
        if (percSpeed > 1.0f) {
            totalDamage += percSpeed * 5.0f;
        }
        this.refuel$addDamage(totalDamage);
        if (CarMixin.class.equals(Motorcycle.class) && this.refuel$getDriver() != null) {
            this.refuel$getDriver().m_6469_(new DamageSource((Holder)((Registry)this.m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(RefueledRegistry.crashedVehicle), (Entity)this, (Entity)this.refuel$getDriver()), totalDamage / 4.0f);
        }
    }

    @Unique
    public void refuel$setStarted(boolean started) {
        this.refuel$setStarting(false, false);
        this.refuel$setStarted(started, true, false);
    }

    @Unique
    public float refuel$getRotationModifier() {
        return 1.5f;
    }

    @Unique
    public boolean refuel$canPlayerDriveCar(Player player) {
        if (this.refuel$getFuel() <= 0) {
            return false;
        }
        if (player.equals((Object)this.refuel$getDriver()) && this.refuel$isStarted()) {
            return true;
        }
        if (this.m_20069_() || this.m_20077_()) {
            return false;
        }
        return false;
    }

    @Unique
    public int refuel$getStartingTime() {
        return (Integer)this.f_19804_.m_135370_(refuel$STARTING_TIME);
    }

    @Unique
    public void refuel$setStartingTime(int time) {
        this.f_19804_.m_135381_(refuel$STARTING_TIME, (Object)time);
    }

    @Override
    @Unique
    public boolean refuel$isStarting() {
        return (Boolean)this.f_19804_.m_135370_(refuel$STARTING);
    }

    @Unique
    public int refuel$getTimeToStart() {
        int time = this.f_19796_.m_188503_(10) + 5;
        float temp = this.refuel$getTemperature();
        if (temp < 0.0f) {
            time += 40;
        } else if (temp < 10.0f) {
            time += 35;
        } else if (temp < 30.0f) {
            time += 10;
        } else if (temp < 60.0f) {
            time += 5;
        }
        float batteryPerc = (float)this.refuel$getBattery() / (float)this.refuel$getMaxBattery();
        if (batteryPerc < 0.5f) {
            time += 20 + this.f_19796_.m_188503_(10);
        } else if (batteryPerc < 0.75f) {
            time += 10 + this.f_19796_.m_188503_(10);
        }
        if (this.refuel$getHealth() < 5.0f) {
            time += this.f_19796_.m_188503_(25) + 50;
        } else if (this.refuel$getHealth() <= 10.0f) {
            time += this.f_19796_.m_188503_(15) + 30;
        } else if (this.refuel$getHealth() <= 20.0f) {
            time += this.f_19796_.m_188503_(15) + 10;
        } else if (this.refuel$getHealth() <= 50.0f) {
            time += this.f_19796_.m_188503_(10) + 5;
        }
        return time;
    }

    @Unique
    public float refuel$getTemperatureToReach() {
        float biomeTemp = this.refuel$getBiomeTemperatureCelsius();
        if (!this.refuel$isStarted()) {
            return biomeTemp;
        }
        float optimalTemp = this.refuel$getOptimalTemperature();
        if (biomeTemp > 45.0f) {
            optimalTemp = 100.0f;
        } else if (biomeTemp <= 0.0f) {
            optimalTemp = 80.0f;
        }
        return Math.max(biomeTemp, optimalTemp);
    }

    @Unique
    public float refuel$getBiomeTemperatureCelsius() {
        Biome biome = (Biome)this.m_9236_().m_204166_(this.m_20183_()).m_203334_();
        return (((IBiomeAccess)biome).invokeGetTemperature(this.m_20183_()) - 0.3f) * 30.0f;
    }

    @Unique
    public float refuel$getOptimalTemperature() {
        return 90.0f;
    }

    @Unique
    public int refuel$getBatteryUsage() {
        if (!((Boolean)ServerConfig.useBattery.get()).booleanValue()) {
            return 0;
        }
        float temp = this.refuel$getBiomeTemperatureCelsius();
        int baseUsage = 2;
        if (temp < 0.0f) {
            baseUsage += 2;
        } else if (temp < 15.0f) {
            ++baseUsage;
        }
        return baseUsage;
    }

    @Unique
    public void refuel$startCarEngine() {
        Player player = this.refuel$getDriver();
        if (player != null && this.refuel$canStartCarEngine()) {
            this.refuel$setStarted(true);
        }
    }

    @Unique
    public boolean refuel$canStartCarEngine() {
        if (this.refuel$getFuel() <= 0) {
            return false;
        }
        if (this.refuel$getHealth() <= 0.0f) {
            return false;
        }
        return !this.m_20069_() && !this.m_20077_();
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity entity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(entity);
        }
        int[][] offsets = DismountHelper.m_38467_((Direction)direction);
        AABB bb = entity.m_21270_(Pose.STANDING);
        for (int[] offset : offsets) {
            int i = this.m_20197_().size();
            Vec3 dismountPos = new Vec3(this.m_20185_() + this.refuel$getDismountLocations(offset[0], this.m_20205_(), entity.m_20205_())[i], this.m_20186_(), this.m_20189_() + this.refuel$getDismountLocations(offset[1], this.m_20205_(), entity.m_20205_())[i]);
            double y = this.m_9236_().m_45573_(new BlockPos((int)dismountPos.f_82479_, (int)dismountPos.f_82480_, (int)dismountPos.f_82481_));
            if (!DismountHelper.m_38439_((double)y) || !DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)entity, (AABB)bb.m_82383_(dismountPos))) continue;
            return dismountPos;
        }
        return super.m_7688_(entity);
    }

    public boolean m_271807_() {
        return this.m_6084_();
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        if (this.m_9236_().f_46443_ || this.m_20147_() || !this.m_6084_()) {
            return false;
        }
        if (damageSource.m_7639_() != null) {
            if (this.m_20197_().stream().anyMatch(arg_0 -> ((Entity)damageSource.m_7639_()).equals(arg_0))) {
                return false;
            }
        }
        if (!this.refuel$killed) {
            this.m_5834_();
            this.m_146850_(GameEvent.f_223706_);
            this.refuel$addDamage(damage);
            return true;
        }
        return false;
    }

    @Override
    public void refuel$kill() {
        this.refuel$killed = true;
        this.refuel$tasks.add(() -> {
            if (((Boolean)ServerConfig.explodeOnDeath.get()).booleanValue()) {
                this.m_9236_().m_254877_(null, new DamageSource((Holder)((Registry)this.m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(RefueledRegistry.vehicleExplosion), (Entity)this, (Entity)this.refuel$getDriver(), this.m_20182_()), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f * (float)this.refuel$getFuel() / (float)this.refuel$getMaxFuel(), (double)((float)this.refuel$getBattery() / (float)this.refuel$getMaxBattery()) >= 0.75, Level.ExplosionInteraction.MOB);
            }
            this.refuel$convertIntoItems();
            this.m_6074_();
        });
    }

    @Unique
    private void refuel$convertIntoItems() {
        Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this.inventory);
        Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this.refuel$internalInventory);
    }

    @Unique
    private ItemStack refuel$getEgg() {
        ItemStack egg = ((Item)List.of(ItemRegistry.CAR_SPAWN_EGG, ItemRegistry.CLASSIC_SPAWN_EGG, ItemRegistry.TRUCK_SPAWN_EGG, ItemRegistry.SUV_SPAWN_EGG, ItemRegistry.SPORT_CAR_SPAWN_EGG, ItemRegistry.MOTORCYCLE_SPAWN_EGG).get(refuel$type).get()).m_7968_();
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("temperature", this.refuel$getTemperature());
        if (this.refuel$getBattery() > 0) {
            tag.m_128405_("energy", this.refuel$getBattery());
        }
        if (this.refuel$getFuel() > 0) {
            tag.m_128365_("Fluid", (Tag)new FluidStack(this.refuel$getFluid(), this.refuel$getFuel()).writeToNBT(new CompoundTag()));
        }
        if (this.refuel$getHealth() > 0.0f) {
            tag.m_128350_("Health", this.refuel$getHealth());
        }
        if (this.m_8077_()) {
            tag.m_128359_("custom", this.m_7770_().getString());
            egg.m_41714_((Component)Component.m_237113_((String)this.m_7770_().getString()));
        }
        egg.m_41784_().m_128365_("refueled", (Tag)tag);
        return egg;
    }

    @Unique
    public float refuel$getBatterySoundPitchLevel() {
        int startLevel = this.refuel$getMaxBattery() / 3;
        float basePitch = 1.0f - 0.002f * (float)this.refuel$getStartingTime();
        if (this.refuel$getBattery() > startLevel) {
            return basePitch;
        }
        float perc = (float)(startLevel - this.refuel$getBattery()) / (float)startLevel;
        return basePitch - perc / 2.3f;
    }

    @Unique
    private void refuel$addTask(LivingEntity mob, DamageSource source, double amount) {
        this.refuel$tasks.add(() -> {
            if (!ServerConfig.isEntityOnList((Entity)mob)) {
                mob.m_147240_((double)(this.refuel$getSpeed() / this.refuel$getMaxSpeed()) * Math.max(amount - (double)mob.m_21223_(), 1.0), this.m_20185_() - mob.m_20185_(), this.m_20189_() - mob.m_20189_());
            }
            mob.m_6469_(source, (float)amount);
        });
    }

    public boolean m_7337_(@NotNull Entity entity) {
        if (!this.m_9236_().f_46443_ && ((Boolean)ServerConfig.damageEntities.get()).booleanValue() && entity instanceof LivingEntity) {
            LivingEntity mob = (LivingEntity)entity;
            if (!this.m_20197_().contains(entity) && entity.m_20191_().m_82381_(this.m_20191_()) && (double)this.refuel$getSpeed() > 0.3) {
                double damage = this.refuel$getSpeed() * this.refuel$getRamDamage();
                DamageSource source = new DamageSource((Holder)((Registry)this.m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(RefueledRegistry.vehicleCollision), (Entity)this, (Entity)this.refuel$getDriver());
                if (CarMixin.class.equals(Truck.class) && this.m_8077_() && this.m_7770_().getString().equalsIgnoreCase("bergentr\u00fcck") && this.refuel$getDriver() != null && this.refuel$getDriver().m_21120_(InteractionHand.MAIN_HAND).m_41720_() == Items.f_42713_) {
                    damage *= 3.4;
                    source = new DamageSource((Holder)((Registry)this.m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(RefueledRegistry.bergentrucked), (Entity)this, (Entity)this.refuel$getDriver());
                }
                this.refuel$addTask(mob, source, damage);
            }
        }
        boolean onList = ServerConfig.isEntityOnList(entity);
        if (((Boolean)ServerConfig.collideWithEntities.get()).booleanValue()) {
            if (!Utils.isCar(entity) && onList) {
                return true;
            }
        } else if (!Utils.isCar(entity) || onList) {
            return false;
        }
        return (entity.m_5829_() || entity.m_6094_()) && !this.m_20365_(entity);
    }

    @Unique
    public boolean refuel$canEngineStayOn() {
        if (this.m_20069_()) {
            if (this.f_19797_ % 20 == 0) {
                this.refuel$addDamage(25.0f);
            }
            return false;
        }
        return !this.m_20077_() && this.refuel$getFuel() > 0 && this.refuel$getHealth() > 0.0f && this.refuel$getBattery() > 0;
    }

    @Unique
    private void refuel$updateGravity() {
        Vec3 delta = this.m_20184_();
        if (this.m_20068_()) {
            this.m_20334_(delta.f_82479_, 0.0, delta.f_82481_);
            return;
        }
        this.m_20334_(delta.f_82479_, delta.f_82480_ - (this.m_20069_() ? 0.01 : 0.08), delta.f_82481_);
    }

    @Unique
    public void refuel$spawnParticles(boolean driving) {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        Vec3 lookVec = this.m_20154_().m_82541_();
        double lookAngle = this.m_146908_() < 0.0f ? (double)(360.0f + this.m_146908_()) : (double)this.m_146908_();
        int rand = this.f_19796_.m_188503_(4);
        double radius = this.refuel$getExhaust(rand)[0];
        double angle = this.refuel$getExhaust(rand)[1];
        double offX = Math.sin(Math.toRadians(lookAngle)) + radius * Math.sin(angle + Math.toRadians(lookAngle));
        double offY = this.refuel$getExhaust(rand)[2];
        double offZ = Math.cos(Math.toRadians(lookAngle)) * -1.0 - radius * Math.cos(angle + Math.toRadians(lookAngle));
        if (this.refuel$timeSinceStarted > 0 && this.refuel$timeSinceStarted < 20 && this.refuel$getTemperature() < 50.0f) {
            double speedX = lookVec.f_82479_ * -0.1;
            double speedZ = lookVec.f_82481_ * -0.1;
            int health = (int)(this.refuel$getHealth() / this.refuel$getMaxHealth() * 100.0f);
            int count = 1;
            double r = 0.1;
            if (health < 10) {
                count = 6;
                r = 0.7;
            } else if (health < 25) {
                count = 3;
                r = 0.7;
            } else if (health < 50) {
                count = 2;
                r = 0.3;
            }
            for (int i = 0; i <= count; ++i) {
                this.refuel$spawnParticle((ParticleOptions)ParticleTypes.f_123755_, offX, offY, offZ, speedX, speedZ, r);
            }
        } else if (driving) {
            double speedX = lookVec.f_82479_ * -0.2;
            double speedZ = lookVec.f_82481_ * -0.2;
            this.refuel$spawnParticle((ParticleOptions)ParticleTypes.f_123762_, offX, offY, offZ, speedX, speedZ);
        } else {
            double speedX = lookVec.f_82479_ * -0.05;
            double speedZ = lookVec.f_82481_ * -0.05;
            this.refuel$spawnParticle((ParticleOptions)ParticleTypes.f_123762_, offX, offY, offZ, speedX, speedZ);
        }
    }

    @Unique
    private void refuel$spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ, double speedX, double speedZ, double r) {
        this.m_9236_().m_7106_(particleTypes, this.m_20185_() + offX + (this.f_19796_.m_188500_() * r - r / 2.0), this.m_20186_() + offY + (this.f_19796_.m_188500_() * r - r / 2.0) + (double)(this.m_20206_() / 8.0f), this.m_20189_() + offZ + (this.f_19796_.m_188500_() * r - r / 2.0), speedX, 0.0, speedZ);
    }

    @Unique
    private void refuel$spawnParticle(ParticleOptions particleTypes, double offX, double offY, double offZ, double speedX, double speedZ) {
        this.refuel$spawnParticle(particleTypes, offX, offY, offZ, speedX, speedZ, 0.1);
    }

    @Unique
    public void refuel$particles() {
        int amount;
        if (!this.m_9236_().f_46443_) {
            return;
        }
        int health = (int)(this.refuel$getHealth() / this.refuel$getMaxHealth() * 100.0f);
        if (health > 50) {
            return;
        }
        if (health > 30) {
            if (this.f_19796_.m_188503_(10) != 0) {
                return;
            }
            amount = 1;
        } else if (health > 20) {
            if (this.f_19796_.m_188503_(5) != 0) {
                return;
            }
            amount = 1;
        } else {
            amount = health > 10 ? 2 : 3;
        }
        for (int i = 0; i < amount; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    @Override
    @Unique
    public void refuel$initTemperature() {
        this.refuel$setTemperature(this.refuel$getBiomeTemperatureCelsius());
    }

    @Override
    @Unique
    public void refuel$updateControls(boolean forward, boolean backward, boolean left, boolean right, Player player) {
        boolean needsUpdate = false;
        if (this.refuel$isForward() != forward) {
            this.refuel$setForward(forward);
            needsUpdate = true;
        }
        if (this.refuel$isBackward() != backward) {
            this.refuel$setBackward(backward);
            needsUpdate = true;
        }
        if (this.refuel$isLeft() != left) {
            this.refuel$setLeft(left);
            needsUpdate = true;
        }
        if (this.refuel$isRight() != right) {
            this.refuel$setRight(right);
            needsUpdate = true;
        }
        if (this.m_9236_().f_46443_ && needsUpdate) {
            RefueledChannel.sendToServer(new ControlVehicle(forward, backward, left, right, player));
        }
    }

    @Override
    @Unique
    public void refuel$centerCar() {
        Direction facing = this.m_6350_();
        switch (facing) {
            case SOUTH: {
                this.m_146922_(0.0f);
                break;
            }
            case NORTH: {
                this.m_146922_(180.0f);
                break;
            }
            case EAST: {
                this.m_146922_(-90.0f);
                break;
            }
            case WEST: {
                this.m_146922_(90.0f);
            }
        }
    }

    @Override
    @Unique
    public void refuel$openGUI(Player player) {
        if (this.m_9236_().f_46443_) {
            RefueledChannel.sendToServer(new VehicleGUI(player));
        } else if (player instanceof ServerPlayer) {
            ServerPlayer srvrplyr = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)srvrplyr, (MenuProvider)this, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        }
    }

    public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new CarGUI(i, playerInventory, this);
    }

    protected void m_20351_(Entity removedPassenger) {
        if (removedPassenger.m_20202_() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        if (((IEntityAccess)((Object)this)).getPassengers().size() == 1 && ((IEntityAccess)((Object)this)).getPassengers().get(0) == removedPassenger) {
            ((IEntityAccess)((Object)this)).setPassengers((ImmutableList<Entity>)ImmutableList.of());
        } else {
            ((IEntityAccess)((Object)this)).setPassengers((ImmutableList<Entity>)((ImmutableList)((IEntityAccess)((Object)this)).getPassengers().stream().filter(passenger -> passenger != removedPassenger).collect(ImmutableList.toImmutableList())));
        }
        ((IEntityAccess)removedPassenger).setBoardingCooldown(60);
        removedPassenger.m_6210_();
        this.m_146852_(GameEvent.f_268533_, removedPassenger);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (((Boolean)ServerConfig.vehiclePersist.get()).booleanValue() && this.getPersistentData().m_128441_("refueled_last_entity")) {
            CompoundTag tag = this.getPersistentData().m_128469_("refueled_last_entity");
            for (String key : tag.m_128431_()) {
                ServerPlayer player = (ServerPlayer)this.m_9236_().m_46003_(tag.m_128342_(key));
                if (player == null) continue;
                player.m_20329_((Entity)this);
            }
            this.getPersistentData().m_128473_("refueled_last_entity");
        }
    }

    @Override
    public float refuel$getMaxHealth() {
        return ((Number)((List)ServerConfig.vehicleHealth.get()).get(refuel$type)).floatValue();
    }

    @Override
    public int refuel$getMaxBattery() {
        return ((Number)((List)ServerConfig.vehicleBattery.get()).get(refuel$type)).intValue();
    }

    @Override
    public float refuel$getMaxSpeed() {
        return ((Number)((List)ServerConfig.vehicleMaxSpeed.get()).get(refuel$type)).floatValue();
    }

    @Override
    public float refuel$getMaxReverseSpeed() {
        return ((Number)((List)ServerConfig.vehicleMaxRevSpeed.get()).get(refuel$type)).floatValue();
    }

    @Override
    public float refuel$getAcceleration() {
        return ((Number)((List)ServerConfig.vehicleAcc.get()).get(refuel$type)).floatValue();
    }

    @Unique
    public float refuel$getRamDamage() {
        return ((Number)((List)ServerConfig.vehicleRamDamage.get()).get(refuel$type)).floatValue();
    }

    @Unique
    public float refuel$getEfficiency(Fluid fluid) {
        float eff = ServerConfig.getFuelEfficiency(fluid);
        if (eff <= 0.0f) {
            eff = 0.0f;
            this.refuel$setFuel(0);
        }
        return ((Number)((List)ServerConfig.vehicleFuelEff.get()).get(refuel$type)).floatValue() * eff;
    }

    @Unique
    public float refuel$getHighSpeedSteering() {
        return ((Number)((List)((List)ServerConfig.vehicleSteering.get()).get(refuel$type)).get(0)).floatValue();
    }

    @Override
    @Unique
    public float refuel$getLowSpeedSteering() {
        return ((Number)((List)((List)ServerConfig.vehicleSteering.get()).get(refuel$type)).get(1)).floatValue();
    }

    @Override
    public int refuel$getMaxFuel() {
        return ((Number)((List)ServerConfig.vehicleFuel.get()).get(refuel$type)).intValue();
    }

    public float getStepHeight() {
        return ((Number)((List)ServerConfig.vehicleStepHeight.get()).get(refuel$type)).floatValue();
    }

    @Unique
    private void refuel$fuelTick() {
        int fuel = this.refuel$getFuel();
        if (fuel == 0) {
            return;
        }
        double efficiency = this.refuel$getEfficiency(this.refuel$getFluid());
        if (efficiency <= 0.0) {
            return;
        }
        int frequency = Math.max(Mth.m_14107_((double)(20.0 * efficiency)), 5);
        int density = 4 + (10 - Math.min(Mth.m_14107_((double)(20.0 * efficiency)), 5) * 2);
        if (fuel > 0 && (this.refuel$isForward() || this.refuel$isBackward()) && !this.f_19862_ && this.refuel$isStarted()) {
            if (this.f_19797_ % frequency == 0) {
                this.refuel$drainFuel(density);
            }
        } else if (fuel > 0 && this.refuel$isStarted() && this.f_19797_ % (frequency * 100) == 0) {
            this.refuel$drainFuel(density);
        }
    }

    @Unique
    private void refuel$drainFuel(int amount) {
        ItemStack fuelItem = this.refuel$internalInventory.m_8020_(0);
        if (!fuelItem.m_41619_() && !(fuelItem.m_41720_() instanceof BucketItem)) {
            fuelItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(otherHandler -> {
                int remainder;
                if (otherHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getAmount() > 0 && (remainder = amount - otherHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE).getAmount()) > 0) {
                    this.refuel$setFuel(this.refuel$getFuel() - remainder);
                }
            });
        } else {
            this.refuel$setFuel(this.refuel$getFuel() - amount);
        }
    }

    @Unique
    private void refuel$checkSlots() {
        ItemStack repair;
        ItemStack energy;
        ItemStack fuelItem = this.refuel$internalInventory.m_8020_(0);
        if (!fuelItem.m_41619_()) {
            Item item = fuelItem.m_41720_();
            if (item instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item;
                Fluid stored = this.refuel$getFluid();
                if ((stored == Fluids.f_76191_ && ServerConfig.getFuelEfficiency(bucket.getFluid()) > 0.0f || stored == bucket.getFluid()) && this.refuel$getMaxFuel() - this.refuel$getFuel() >= 1000) {
                    ResourceLocation key = ForgeRegistries.FLUIDS.getKey((Object)bucket.getFluid());
                    if (stored == Fluids.f_76191_ && key != null) {
                        this.refuel$setFuelType(key.toString());
                    }
                    this.refuel$setFuel(Math.min(this.refuel$getFuel() + 1000, this.refuel$getMaxFuel()));
                    this.refuel$internalInventory.m_6836_(0, Items.f_42446_.m_7968_());
                }
            } else {
                fuelItem.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(otherHandler -> {
                    if (otherHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getAmount() > 0) {
                        ResourceLocation key = ForgeRegistries.FLUIDS.getKey((Object)otherHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getFluid());
                        if (this.refuel$getFluid() == Fluids.f_76191_ && key != null) {
                            this.refuel$setFuelType(key.toString());
                        }
                        int toDrain = Math.min(Math.max(this.refuel$getMaxFuel() - this.refuel$getFuel(), 0), 50);
                        FluidStack drained = otherHandler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
                        this.refuel$setFuel(Math.min(this.refuel$getFuel() + drained.getAmount(), this.refuel$getMaxFuel()));
                    }
                });
            }
        }
        if (!(energy = this.refuel$internalInventory.m_8020_(1)).m_41619_()) {
            LazyOptional lazyItem = energy.getCapability(ForgeCapabilities.ENERGY);
            lazyItem.ifPresent(itemEnergy -> {
                if (this.refuel$getBattery() < this.refuel$getMaxBattery()) {
                    int received = Math.min(itemEnergy.getEnergyStored(), Math.min(400, Math.max(0, this.refuel$getMaxBattery() - this.refuel$getBattery())));
                    itemEnergy.extractEnergy(received, false);
                    this.refuel$setBattery(this.refuel$getBattery() + received);
                }
            });
            if (energy.m_150930_(Items.f_42451_)) {
                energy.m_41774_(1);
                this.refuel$internalInventory.m_6596_();
                this.refuel$setBattery(this.refuel$getBattery() + 810);
            }
        }
        if (!(repair = this.refuel$internalInventory.m_8020_(2)).m_41619_()) {
            List<String> data = ServerConfig.getRepairItemData(repair);
            if (repair.m_41613_() > Integer.parseInt(data.get(0))) {
                float health = this.refuel$getHealth() + Float.parseFloat(data.get(1));
                repair.m_41774_(Integer.parseInt(data.get(0)));
                this.refuel$internalInventory.m_6596_();
                this.refuel$setHealth(health);
            }
        }
    }

    public void m_6478_(@NotNull MoverType pType, @NotNull Vec3 pPos) {
        if (this.f_19794_) {
            this.m_6034_(this.m_20185_() + pPos.f_82479_, this.m_20186_() + pPos.f_82480_, this.m_20189_() + pPos.f_82481_);
        } else {
            Vec3 vec3;
            double d0;
            this.f_146810_ = this.m_6060_();
            if (pType == MoverType.PISTON && (pPos = this.m_20133_(pPos)).equals((Object)Vec3.f_82478_)) {
                return;
            }
            this.m_9236_().m_46473_().m_6180_("move");
            if (this.f_19865_.m_82556_() > 1.0E-7) {
                pPos = pPos.m_82559_(this.f_19865_);
                this.f_19865_ = Vec3.f_82478_;
                this.m_20256_(Vec3.f_82478_);
            }
            if ((d0 = (vec3 = this.refuel$vehicleCollide(pPos = this.m_5763_(pPos, pType))).m_82556_()) > 1.0E-7) {
                BlockHitResult blockhitresult;
                if (this.f_19789_ != 0.0f && d0 >= 1.0 && (blockhitresult = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(vec3), ClipContext.Block.FALLDAMAGE_RESETTING, ClipContext.Fluid.WATER, (Entity)this))).m_6662_() != HitResult.Type.MISS) {
                    this.m_183634_();
                }
                this.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
            }
            this.m_9236_().m_46473_().m_7238_();
            this.m_9236_().m_46473_().m_6180_("rest");
            boolean flag4 = !Mth.m_14082_((double)pPos.f_82479_, (double)vec3.f_82479_);
            boolean flag = !Mth.m_14082_((double)pPos.f_82481_, (double)vec3.f_82481_);
            this.f_19862_ = flag4 || flag;
            this.f_19863_ = pPos.f_82480_ != vec3.f_82480_;
            this.f_201939_ = this.f_19863_ && pPos.f_82480_ < 0.0;
            this.f_185931_ = this.f_19862_ ? this.m_196406_(vec3) : false;
            this.m_289603_(this.f_201939_, vec3);
            BlockPos blockpos = this.m_216986_(0.2f);
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            this.m_7840_(vec3.f_82480_, this.m_20096_(), blockstate, blockpos);
            if (this.m_213877_()) {
                this.m_9236_().m_46473_().m_7238_();
            } else {
                Entity.MovementEmission entity$movementemission;
                if (this.f_19862_) {
                    Vec3 vec31 = this.m_20184_();
                    this.m_20334_(flag4 ? 0.0 : vec31.f_82479_, vec31.f_82480_, flag ? 0.0 : vec31.f_82481_);
                }
                Block block = blockstate.m_60734_();
                if (pPos.f_82480_ != vec3.f_82480_) {
                    block.m_5548_((BlockGetter)this.m_9236_(), (Entity)this);
                }
                if (this.m_20096_()) {
                    block.m_141947_(this.m_9236_(), blockpos, blockstate, (Entity)this);
                }
                if ((entity$movementemission = this.m_142319_()).m_146944_() && !this.m_20159_()) {
                    boolean flag1;
                    double d1 = vec3.f_82479_;
                    double d2 = vec3.f_82480_;
                    double d3 = vec3.f_82481_;
                    this.f_146794_ = (float)((double)this.f_146794_ + vec3.m_82553_() * 0.6);
                    BlockPos blockpos1 = this.m_20097_();
                    BlockState blockstate1 = this.m_9236_().m_8055_(blockpos1);
                    boolean bl = flag1 = blockstate1.m_204336_(BlockTags.f_13082_) || blockstate1.m_60713_(Blocks.f_152499_);
                    if (!flag1) {
                        d2 = 0.0;
                    }
                    this.f_19787_ += (float)vec3.m_165924_() * 0.6f;
                    this.f_19788_ += (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3) * 0.6f;
                    if (this.f_19788_ > ((IEntityAccess)((Object)this)).getNextStep() && !blockstate1.m_60795_()) {
                        boolean flag2 = blockpos1.equals((Object)blockpos);
                        boolean flag3 = ((IEntityAccess)((Object)this)).invokeVaSEFB(blockpos, blockstate, entity$movementemission.m_146946_(), flag2, pPos);
                        if (!flag2) {
                            flag3 |= ((IEntityAccess)((Object)this)).invokeVaSEFB(blockpos1, blockstate1, false, entity$movementemission.m_146945_(), pPos);
                        }
                        if (flag3) {
                            ((IEntityAccess)((Object)this)).setNextStep(this.m_6059_());
                        } else if (this.m_20069_()) {
                            ((IEntityAccess)((Object)this)).setNextStep(this.m_6059_());
                            if (entity$movementemission.m_146946_()) {
                                this.m_280447_();
                            }
                            if (entity$movementemission.m_146945_()) {
                                this.m_146850_(GameEvent.f_157786_);
                            }
                        }
                    } else if (blockstate1.m_60795_()) {
                        this.m_146874_();
                    }
                }
                this.m_146872_();
                float f = this.m_6041_();
                this.m_20256_(this.m_20184_().m_82542_((double)f, 1.0, (double)f));
                if (this.m_9236_().m_46847_(this.m_20191_().m_82406_(1.0E-6)).noneMatch(p_20127_ -> p_20127_.m_204336_(BlockTags.f_13076_) || p_20127_.m_60713_(Blocks.f_49991_))) {
                    if (this.m_20094_() <= 0) {
                        this.m_7311_(-this.m_6101_());
                    }
                    if (this.f_146810_ && (this.f_146808_ || this.m_20071_() || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType)))) {
                        this.m_146873_();
                    }
                }
                if (this.m_6060_() && (this.f_146808_ || this.m_20071_() || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType)))) {
                    this.m_7311_(-this.m_6101_());
                }
                this.m_9236_().m_46473_().m_7238_();
            }
        }
    }

    @Unique
    private Vec3 refuel$vehicleCollide(Vec3 pVec) {
        AABB aabb = this.m_20191_();
        List list = this.m_9236_().m_183134_((Entity)this, aabb.m_82369_(pVec));
        Vec3 vec3 = pVec.m_82556_() == 0.0 ? pVec : CarMixin.m_198894_((Entity)this, (Vec3)pVec, (AABB)aabb, (Level)this.m_9236_(), (List)list);
        boolean flag = pVec.f_82479_ != vec3.f_82479_;
        boolean flag1 = pVec.f_82480_ != vec3.f_82480_;
        boolean flag2 = pVec.f_82481_ != vec3.f_82481_;
        boolean flag3 = this.m_20096_() || flag1 && pVec.f_82480_ < 0.0;
        float stepHeight = this.getStepHeight();
        if (stepHeight > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vec33;
            Vec3 vec31 = CarMixin.m_198894_((Entity)this, (Vec3)new Vec3(pVec.f_82479_, (double)stepHeight, pVec.f_82481_), (AABB)aabb, (Level)this.m_9236_(), (List)list);
            Vec3 vec32 = CarMixin.m_198894_((Entity)this, (Vec3)new Vec3(0.0, (double)stepHeight, 0.0), (AABB)aabb.m_82363_(pVec.f_82479_, 0.0, pVec.f_82481_), (Level)this.m_9236_(), (List)list);
            if (vec32.f_82480_ < (double)stepHeight && (vec33 = CarMixin.m_198894_((Entity)this, (Vec3)new Vec3(pVec.f_82479_, 0.0, pVec.f_82481_), (AABB)aabb.m_82383_(vec32), (Level)this.m_9236_(), (List)list).m_82549_(vec32)).m_165925_() > vec31.m_165925_()) {
                vec31 = vec33;
            }
            if (vec31.m_165925_() > vec3.m_165925_()) {
                return vec31.m_82549_(CarMixin.m_198894_((Entity)this, (Vec3)new Vec3(0.0, -vec31.f_82480_ + pVec.f_82480_, 0.0), (AABB)aabb.m_82383_(vec31), (Level)this.m_9236_(), (List)list));
            }
        }
        if (this.refuel$sinceCollided > 2) {
            this.refuel$onCollision(this.refuel$getSpeed());
        }
        this.refuel$sinceCollided = this.f_19862_ && (double)(this.refuel$getSpeed() / this.refuel$getMaxSpeed()) > 0.8 && vec3.f_82480_ == 0.0 ? ++this.refuel$sinceCollided : 0;
        return vec3;
    }

    static {
        refuel$carStopped = false;
        refuel$carStarted = false;
    }

    @Mixin(value={Motorcycle.class})
    private static abstract class BikeMixin
    implements IVehicleAccess {
        private BikeMixin() {
        }

        @Override
        public float[] refuel$getExhaust(int rand) {
            double[] modX = new double[]{1.0, -1.0, 1.0, -1.0};
            double[] randomOffY = new double[]{0.5, 0.5, 0.325, 0.325};
            double[] modY = new double[]{1.125, 1.125, 0.975, 0.975};
            double radius = Math.sqrt((modY[rand] - 1.0) * (modY[rand] - 1.0) + 0.04000000000000001);
            double pointDist = Math.sqrt((modY[rand] - (1.0 + radius)) * (modY[rand] - (1.0 + radius)) + 0.04000000000000001);
            double angle = 2.0 * Math.asin(0.5 * pointDist / radius) * modX[rand];
            return new float[]{(float)radius, (float)angle, (float)randomOffY[rand]};
        }

        @Override
        public Vec3[] refuel$getSeatPositions() {
            return new Vec3[]{new Vec3(0.0, 0.56 * sizeFactor, -0.5 * sizeFactor)};
        }

        @Override
        public SoundEvent refuel$getEngineSound() {
            return (SoundEvent)RefueledRegistry.SPORT_ENGINE.get();
        }

        @Redirect(method={"interact"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/network/NetworkHooks;openScreen(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/MenuProvider;)V"))
        private void refuel$mergeInventories(ServerPlayer player, MenuProvider containerSupplier) {
            this.refuel$openGUI((Player)player);
        }
    }

    @Mixin(value={SportCar.class})
    private static abstract class SportMixin
    implements IVehicleAccess {
        private SportMixin() {
        }

        @Override
        public Vec3[] refuel$getSeatPositions() {
            return new Vec3[]{new Vec3(0.7 * sizeFactor, 0.0, 0.1 * sizeFactor), new Vec3(-0.7 * sizeFactor, 0.0, 0.1 * sizeFactor), new Vec3(0.7 * sizeFactor, 0.0, -2.2 * sizeFactor), new Vec3(-0.7 * sizeFactor, 0.0, -2.2 * sizeFactor)};
        }

        @Override
        public float[] refuel$getExhaust(int rand) {
            Double factor = sizeFactor;
            double[] modX = new double[]{1.0, -1.0, 1.0, -1.0};
            double radius = Math.sqrt(1.8 * factor * 1.8 * factor + factor * factor);
            double pointDist = Math.sqrt((1.0 + 1.8 * factor - (1.0 + radius)) * (1.0 + 1.8 * factor - (1.0 + radius)) + factor * factor);
            double angle = 2.0 * Math.asin(0.5 * pointDist / radius) * modX[rand];
            return new float[]{(float)radius, (float)angle, 0.08f * factor.floatValue()};
        }

        @Override
        public SoundEvent refuel$getEngineSound() {
            return (SoundEvent)RefueledRegistry.SPORT_ENGINE.get();
        }
    }

    @Mixin(value={SUV.class})
    private static abstract class SUVMixin
    implements IVehicleAccess {
        private SUVMixin() {
        }

        @Override
        public float refuel$getPitch() {
            return 1.0f + 0.34f * Math.abs(this.refuel$getSpeed()) / this.refuel$getMaxSpeed();
        }

        @Override
        public SoundEvent refuel$getEngineSound() {
            return (SoundEvent)RefueledRegistry.TRUCK_ENGINE.get();
        }
    }

    @Mixin(value={Truck.class})
    private static abstract class TruckMixin
    extends Entity
    implements IVehicleAccess {
        @Shadow(remap=false)
        public SimpleContainer inventory;

        public TruckMixin(EntityType<?> pEntityType, Level pLevel) {
            super(pEntityType, pLevel);
        }

        protected boolean m_7310_(@NotNull Entity pPassenger) {
            int emptyCount = 0;
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                if (!this.inventory.m_8020_(i).m_41619_()) continue;
                ++emptyCount;
            }
            emptyCount = Math.min(48, emptyCount);
            return this.m_20197_().size() < 2 + emptyCount / 24;
        }

        @ModifyArg(method={"createInventory"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/SimpleContainer;<init>(I)V"), index=0)
        private int refuel$increaseSize(int pSize) {
            return 72;
        }

        @Redirect(method={"interact*"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/network/NetworkHooks;openScreen(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/MenuProvider;)V"))
        private void refuel$redirectIntoLargerGUI(ServerPlayer player, MenuProvider containerSupplier) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return this.m_5446_();
                }

                @NotNull
                public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
                    return new TruckGUI(i, playerInventory, (Truck)this);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_20148_()));
        }

        @Override
        public float refuel$getPitch() {
            return 1.0f + 0.34f * Math.abs(this.refuel$getSpeed()) / this.refuel$getMaxSpeed();
        }

        @Override
        public SoundEvent refuel$getEngineSound() {
            return (SoundEvent)RefueledRegistry.TRUCK_ENGINE.get();
        }
    }

    @Mixin(value={Classic.class})
    private static abstract class ClassicMixin
    implements IVehicleAccess {
        private ClassicMixin() {
        }

        @Override
        public Vec3[] refuel$getSeatPositions() {
            return new Vec3[]{new Vec3(0.65 * sizeFactor, 0.1 * sizeFactor, 0.1 * sizeFactor), new Vec3(-0.65 * sizeFactor, 0.1 * sizeFactor, 0.1 * sizeFactor), new Vec3(0.65 * sizeFactor, 0.1 * sizeFactor, -2.2 * sizeFactor), new Vec3(-0.65 * sizeFactor, 0.1 * sizeFactor, -2.2 * sizeFactor)};
        }
    }
}

