/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.mixin.client.vehicle;

import bogdan.refueled.Utils;
import bogdan.refueled.client.accessors.IVehicleAccessClient;
import bogdan.refueled.client.sounds.RefueledHigh;
import bogdan.refueled.client.sounds.RefueledIdle;
import bogdan.refueled.client.sounds.RefueledStart;
import bogdan.refueled.client.sounds.RefueledStarting;
import bogdan.refueled.common.accessors.IVehicleAccess;
import bogdan.refueled.config.ClientConfig;
import bogdan.refueled.mixin.client.access.IBlockBehaviourAccess;
import bogdan.refueled.mixin.client.access.ICameraInvoke;
import com.dragn0007.dragnvehicles.vehicle.car.Car;
import com.dragn0007.dragnvehicles.vehicle.classic.Classic;
import com.dragn0007.dragnvehicles.vehicle.motorcycle.Motorcycle;
import com.dragn0007.dragnvehicles.vehicle.sportcar.SportCar;
import com.dragn0007.dragnvehicles.vehicle.suv.SUV;
import com.dragn0007.dragnvehicles.vehicle.truck.Truck;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Car.class, Classic.class, Truck.class, SUV.class, SportCar.class, Motorcycle.class})
public abstract class CarClientMixin
extends Entity
implements IVehicleAccessClient {
    @Shadow(remap=false)
    private float targetRotation;
    @Shadow(remap=false)
    private float currentRotation;
    @Unique
    private RefueledStart refuel$startLoop;
    @Unique
    private RefueledIdle refuel$idleLoop;
    @Unique
    private RefueledHigh refuel$highLoop;
    @Unique
    private RefueledStarting refuel$startingLoop;
    @Unique
    private boolean refuel$startedLast;
    @Unique
    public double[] refuel$angleOffsets = new double[2];
    @Unique
    public double[] refuel$lastAngleOffsets = new double[2];
    @Unique
    private double refuel$lastYRot = 0.0;
    @Unique
    public float refuel$clientPitch;
    @Unique
    public float refuel$wheelRotation;
    @Shadow(remap=false)
    public Vec3 lastClientPos;
    @Shadow(remap=false)
    private int lerpSteps;
    @Shadow(remap=false)
    private float targetYRot;
    @Shadow(remap=false)
    private double targetX;
    @Shadow(remap=false)
    private double targetY;
    @Shadow(remap=false)
    private double targetZ;

    public CarClientMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void refuel$rotateWheels(float refuel$deltaRotation, float rotationSpeed, float speed) {
        this.currentRotation = this.targetRotation;
        if (Math.abs(this.targetRotation + refuel$deltaRotation) <= this.refuel$getLowSpeedSteering() * 3.0f && this.m_6688_() != null) {
            if (rotationSpeed != 0.0f) {
                this.targetRotation += refuel$deltaRotation;
            } else if (Minecraft.m_91087_().f_91074_ != null) {
                if (!this.refuel$isLeft() && this.refuel$isRight()) {
                    this.targetRotation = this.refuel$getLowSpeedSteering();
                }
                if (!this.refuel$isRight() && this.refuel$isLeft()) {
                    this.targetRotation = -this.refuel$getLowSpeedSteering();
                }
            }
        }
        if (speed != 0.0f && refuel$deltaRotation == 0.0f) {
            this.targetRotation += this.targetRotation < 0.0f ? (this.targetRotation + Math.abs(rotationSpeed) > 0.0f ? this.targetRotation * -1.0f : Math.abs(rotationSpeed)) : (this.targetRotation > 0.0f ? (this.targetRotation - Math.abs(rotationSpeed) < 0.0f ? this.targetRotation * -1.0f : -Math.abs(rotationSpeed)) : 0.0f);
        }
    }

    @Override
    public void refuel$displayInfo() {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        ClientConfig.InfoDisplay type = (ClientConfig.InfoDisplay)((Object)ClientConfig.infoDisplay.get());
        Entity vehicle = Minecraft.m_91087_().f_91074_.m_20202_();
        if (type != ClientConfig.InfoDisplay.NONE && this.equals(vehicle)) {
            MutableComponent info = Component.m_237119_();
            switch (type) {
                case BATTERY: {
                    int energy = this.refuel$getBattery();
                    int maxEnergy = this.refuel$getMaxBattery();
                    info = Component.m_237110_((String)"gui.refueled.battery", (Object[])new Object[]{energy / maxEnergy});
                    if (((Boolean)ClientConfig.displayInUnits.get()).booleanValue()) {
                        info = Component.m_237110_((String)"gui.refueled.battery.unit", (Object[])new Object[]{energy, maxEnergy});
                    }
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)info, true);
                    break;
                }
                case FUEL: {
                    int fuel = this.refuel$getFuel();
                    int maxFuel = this.refuel$getMaxFuel();
                    info = Component.m_237110_((String)"gui.refueled.fuel", (Object[])new Object[]{fuel / maxFuel});
                    if (((Boolean)ClientConfig.displayInUnits.get()).booleanValue()) {
                        info = Component.m_237110_((String)"gui.refueled.fuel.unit", (Object[])new Object[]{fuel, maxFuel});
                    }
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)info, true);
                    break;
                }
                case SPEED: {
                    float speed = this.refuel$getSpeed();
                    String speedInfo = Mth.m_14143_((float)(speed * 20.0f * 60.0f * 60.0f * 0.001f)) + " KM/H";
                    if (((Boolean)ClientConfig.speedImperial.get()).booleanValue()) {
                        speedInfo = Mth.m_14143_((float)(speed * 20.0f * 60.0f * 60.0f * 0.001f / 1.609f)) + " MPH";
                    }
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)speedInfo), true);
                    break;
                }
                case HEALTH: {
                    float health = this.refuel$getHealth();
                    float maxHealth = this.refuel$getMaxHealth();
                    info = Component.m_237110_((String)"gui.refueled.health", (Object[])new Object[]{Float.valueOf(Utils.round(health / maxHealth, 2))});
                    if (((Boolean)ClientConfig.displayInUnits.get()).booleanValue()) {
                        info = Component.m_237110_((String)"gui.refueled.health.unit", (Object[])new Object[]{Float.valueOf(Utils.round(health, 2)), Float.valueOf(Utils.round(maxHealth, 2))});
                    }
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)info, true);
                    break;
                }
                case TEMPERATURE: {
                    float temperature = this.refuel$getTemperature();
                    info = Component.m_237110_((String)"gui.refueled.temperature.celsius", (Object[])new Object[]{Float.valueOf(Utils.round(temperature, 2))});
                    if (((Boolean)ClientConfig.temperatureFahrenheit.get()).booleanValue()) {
                        info = Component.m_237110_((String)"gui.refueled.temperature.fahrenheit", (Object[])new Object[]{Float.valueOf(Utils.round(temperature * 1.8f + 32.0f, 2))});
                    }
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)info, true);
                }
            }
        }
    }

    @Override
    public void refuel$playSoundLoop(AbstractTickableSoundInstance loop, Level level) {
        if (level.f_46443_) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)loop);
        }
    }

    @Unique
    public void refuel$checkIdleLoop() {
        if (!Utils.isSoundPlaying((SoundInstance)this.refuel$idleLoop)) {
            this.refuel$idleLoop = new RefueledIdle(this, this.refuel$getEngineSound(), SoundSource.MASTER);
            this.refuel$playSoundLoop(this.refuel$idleLoop, this.m_9236_());
        }
    }

    @Unique
    public void refuel$checkHighLoop() {
        if (!Utils.isSoundPlaying((SoundInstance)this.refuel$highLoop)) {
            this.refuel$highLoop = new RefueledHigh(this, this.refuel$getEngineSound(), SoundSource.MASTER);
            this.refuel$playSoundLoop(this.refuel$highLoop, this.m_9236_());
        }
    }

    @Unique
    public void refuel$checkStartLoop() {
        if (!Utils.isSoundPlaying((SoundInstance)this.refuel$startLoop)) {
            this.refuel$startLoop = new RefueledStart(this, SoundEvents.f_11874_, SoundSource.MASTER);
            this.refuel$playSoundLoop(this.refuel$startLoop, this.m_9236_());
        }
    }

    @Unique
    public void refuel$checkStartingLoop() {
        if (!Utils.isSoundPlaying((SoundInstance)this.refuel$startingLoop)) {
            this.refuel$startingLoop = new RefueledStarting(this, SoundEvents.f_12512_, SoundSource.MASTER);
            this.refuel$playSoundLoop(this.refuel$startingLoop, this.m_9236_());
        }
    }

    @Override
    public void refuel$updateSounds() {
        if (!this.refuel$isStarted() && this.refuel$isStarting()) {
            this.refuel$checkStartingLoop();
        }
        if (this.refuel$getSpeed() == 0.0f && this.refuel$isStarted()) {
            if (!this.refuel$startedLast) {
                this.refuel$checkStartLoop();
            } else if (!Utils.isSoundPlaying((SoundInstance)this.refuel$startLoop)) {
                if (this.refuel$startLoop != null) {
                    this.refuel$startLoop.setDonePlaying();
                    this.refuel$startLoop = null;
                }
                this.refuel$checkIdleLoop();
            }
        }
        if (this.refuel$getSpeed() != 0.0f && this.refuel$isStarted()) {
            this.refuel$checkHighLoop();
        }
        this.refuel$startedLast = this.refuel$isStarted();
    }

    @Override
    public float refuel$getVerticalOffset(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)((float)this.refuel$lastAngleOffsets[0]), (float)((float)this.refuel$angleOffsets[0]));
    }

    @Override
    public Quaternionf refuel$getRotation(float tickDelta) {
        Quaternionf rot = new Quaternionf();
        Axis.f_252529_.m_252961_((float)this.refuel$lastAngleOffsets[1]).slerp((Quaternionfc)Axis.f_252529_.m_252961_((float)this.refuel$angleOffsets[1]), tickDelta, rot);
        return rot;
    }

    @Override
    public Quaternionf refuel$getPlayerRotation(float partialTick) {
        Quaternionf rot = new Quaternionf();
        new Quaternionf(Math.sin(this.refuel$lastAngleOffsets[1] * 0.5) * Math.cos(Math.toRadians(this.refuel$lastYRot)), 0.0, Math.sin(this.refuel$lastAngleOffsets[1] * 0.5) * Math.sin(Math.toRadians(this.refuel$lastYRot)), Math.cos(this.refuel$lastAngleOffsets[1] * 0.5)).slerp((Quaternionfc)new Quaternionf(Math.sin(this.refuel$angleOffsets[1] * 0.5) * Math.cos(Math.toRadians(this.m_146908_())), 0.0, Math.sin(this.refuel$angleOffsets[1] * 0.5) * Math.sin(Math.toRadians(this.m_146908_())), Math.cos(this.refuel$angleOffsets[1] * 0.5)), partialTick, rot);
        return rot;
    }

    @Override
    public Vec3 refuel$getPlayerOffsets(float partialTick, Player player) {
        Vec3 oPos = this.refuel$getSeatPosition((Entity)player);
        Vec3 lastPos = oPos.m_82520_(0.0, -1.5 * IVehicleAccess.sizeFactor, 0.0).m_82496_((float)(-this.refuel$lastAngleOffsets[1])).m_82520_(0.0, 1.5 * IVehicleAccess.sizeFactor - oPos.f_82480_, -oPos.f_82481_);
        Vec3 newPos = oPos.m_82520_(0.0, -1.5 * IVehicleAccess.sizeFactor, 0.0).m_82496_((float)(-this.refuel$angleOffsets[1])).m_82520_(0.0, 1.5 * IVehicleAccess.sizeFactor - oPos.f_82480_, -oPos.f_82481_);
        lastPos = new Vec3(lastPos.f_82481_ * -Math.sin(Math.toRadians(this.refuel$lastYRot)), lastPos.f_82480_ + this.refuel$lastAngleOffsets[0] * IVehicleAccess.sizeFactor, lastPos.f_82481_ * Math.cos(Math.toRadians(this.refuel$lastYRot)));
        newPos = new Vec3(newPos.f_82481_ * -Math.sin(Math.toRadians(this.m_146908_())), newPos.f_82480_ + this.refuel$angleOffsets[0] * IVehicleAccess.sizeFactor, newPos.f_82481_ * Math.cos(Math.toRadians(this.m_146908_())));
        return lastPos.m_165921_(newPos, (double)partialTick);
    }

    @Override
    public void refuel$offsetCamera(float partialTick, Camera camera) {
        Vec3 oPos = this.refuel$getSeatPosition((Entity)Minecraft.m_91087_().f_91074_);
        if (oPos == null) {
            return;
        }
        Vec3 lastPos = oPos.m_82520_(0.0, -1.5 * IVehicleAccess.sizeFactor, 0.0).m_82496_((float)(-this.refuel$lastAngleOffsets[1])).m_82520_(0.0, 1.5 * IVehicleAccess.sizeFactor - oPos.f_82480_, -oPos.f_82481_);
        Vec3 newPos = oPos.m_82520_(0.0, -1.5 * IVehicleAccess.sizeFactor, 0.0).m_82496_((float)(-this.refuel$angleOffsets[1])).m_82520_(0.0, 1.5 * IVehicleAccess.sizeFactor - oPos.f_82480_, -oPos.f_82481_);
        double hOffset = 1.0518750000000001 * (Minecraft.m_91087_().f_91074_.m_20202_() instanceof Motorcycle ? 1.33 : 1.0);
        lastPos = new Vec3((lastPos.f_82481_ - hOffset * Math.sin(-this.refuel$lastAngleOffsets[1])) * -Math.sin(Math.toRadians(this.refuel$lastYRot)), lastPos.f_82480_ + this.refuel$lastAngleOffsets[0] * IVehicleAccess.sizeFactor - (hOffset - hOffset * Math.cos(-this.refuel$lastAngleOffsets[1])), (lastPos.f_82481_ - hOffset * Math.sin(-this.refuel$lastAngleOffsets[1])) * Math.cos(Math.toRadians(this.refuel$lastYRot)));
        newPos = new Vec3((newPos.f_82481_ - hOffset * Math.sin(-this.refuel$angleOffsets[1])) * -Math.sin(Math.toRadians(this.m_146908_())), newPos.f_82480_ + this.refuel$angleOffsets[0] * IVehicleAccess.sizeFactor - (hOffset - hOffset * Math.cos(-this.refuel$angleOffsets[1])), (newPos.f_82481_ - hOffset * Math.sin(-this.refuel$angleOffsets[1])) * Math.cos(Math.toRadians(this.m_146908_())));
        ((ICameraInvoke)camera).cam$setPosition(camera.m_90583_().m_82549_(lastPos).m_165921_(camera.m_90583_().m_82549_(newPos), (double)partialTick));
    }

    @Override
    public float refuel$getAngle(float yawDeg) {
        return (float)(this.refuel$angleOffsets[1] * Math.abs(Math.cos(yawDeg * ((float)Math.PI / 180))));
    }

    @Override
    public void refuel$angleTick() {
        Vec3[] anchors;
        if (!((Boolean)ClientConfig.sloping.get()).booleanValue()) {
            return;
        }
        this.refuel$lastAngleOffsets = this.refuel$angleOffsets;
        double modelToStackFactor = 0.0625;
        int leftRight = Math.round((float)(-Math.sin(Math.toRadians(this.m_146908_()))));
        int frontBack = Math.round((float)Math.cos(Math.toRadians(this.m_146908_())));
        double wheelRadius = CarClientMixin.class.equals(Motorcycle.class) ? 19.0 : 26.5;
        Function<BlockPos, Double> getMaxY = pos -> {
            VoxelShape shape = this.m_9236_().m_8055_(pos).m_60812_((BlockGetter)this.m_9236_(), pos);
            shape = shape.m_83281_() ? this.m_9236_().m_8055_(pos).m_60771_((BlockGetter)this.m_9236_(), pos, CollisionContext.m_82749_()) : shape;
            return shape.m_83281_() ? 0.0 : shape.m_83297_(Direction.Axis.Y);
        };
        Function<Vec3, BlockPos> find = pos -> {
            AABB area = new AABB(pos.f_82479_ - (double)((float)frontBack * this.m_20205_()) * 0.49, pos.f_82480_, pos.f_82481_ - (double)((float)leftRight * this.m_20205_()) * 0.49, pos.f_82479_ + (double)((float)frontBack * this.m_20205_()) * 0.49, pos.f_82480_, pos.f_82481_ + (double)((float)leftRight * this.m_20205_()) * 0.49);
            List<BlockPos> positions = BlockPos.m_121921_((AABB)area).map(BlockPos::new).toList();
            BlockPos finalPos = null;
            double maxY = 0.0;
            for (BlockPos position : positions) {
                BlockState state = this.m_9236_().m_8055_(position);
                if (state.m_60795_() || !((IBlockBehaviourAccess)state.m_60734_()).hasCollision() || !((Double)getMaxY.apply(position) > maxY)) continue;
                finalPos = position;
                maxY = (Double)getMaxY.apply(position);
            }
            return finalPos;
        };
        Function<Vec3, BlockPos> check = anchorPos -> {
            int searchIndex = 1;
            BlockPos finalPos = null;
            while (searchIndex < 4) {
                Vec3 pos = anchorPos;
                switch (searchIndex) {
                    case 1: {
                        if (find.apply(pos) != null) {
                            searchIndex += 2;
                            break;
                        }
                        ++searchIndex;
                    }
                    case 2: {
                        pos = anchorPos.m_82492_(0.0, 1.0, 0.0);
                        if (find.apply(pos) != null) {
                            finalPos = (BlockPos)find.apply(pos);
                        }
                        ++searchIndex;
                    }
                    case 3: {
                        pos = anchorPos.m_82492_(0.0, 1.0, 0.0);
                        if (find.apply(pos) == null && find.apply(pos = pos.m_82492_(0.0, 1.0, 0.0)) != null) {
                            finalPos = (BlockPos)find.apply(pos);
                        }
                        ++searchIndex;
                    }
                }
            }
            return finalPos;
        };
        int opposite = 1;
        BlockPos foundPos = null;
        anchors = new Vec3[]{new Vec3(this.m_20185_() + (double)leftRight * wheelRadius * IVehicleAccess.sizeFactor * modelToStackFactor, this.m_20186_() + 2.0, this.m_20189_() + (double)frontBack * wheelRadius * modelToStackFactor * IVehicleAccess.sizeFactor), new Vec3(this.m_20185_() - (double)leftRight * wheelRadius * IVehicleAccess.sizeFactor * modelToStackFactor, this.m_20186_() + 2.0, this.m_20189_() - (double)frontBack * wheelRadius * modelToStackFactor * IVehicleAccess.sizeFactor), new Vec3(anchors[0].f_82479_ + (double)leftRight, anchors[0].f_82480_, anchors[0].f_82481_ + (double)frontBack), new Vec3(anchors[1].f_82479_ - (double)leftRight, anchors[1].f_82480_, anchors[1].f_82481_ - (double)frontBack)};
        double globalMaxY = this.m_20186_();
        for (int i = 0; i < 4; ++i) {
            BlockPos pos2 = check.apply(anchors[i]);
            if (check.apply(anchors[i]) == null || !((double)pos2.m_123342_() + getMaxY.apply(pos2) > globalMaxY)) continue;
            foundPos = pos2;
            globalMaxY = (double)pos2.m_123342_() + getMaxY.apply(pos2);
            opposite = i % 2 == 1 ? -1 : 1;
        }
        if (foundPos == null) {
            this.refuel$angleOffsets = new double[2];
            return;
        }
        VoxelShape shape = this.m_9236_().m_8055_(foundPos).m_60812_((BlockGetter)this.m_9236_(), foundPos);
        shape = shape.m_83281_() ? this.m_9236_().m_8055_(foundPos).m_60771_((BlockGetter)this.m_9236_(), foundPos, CollisionContext.m_82749_()) : shape;
        double bodyRadius = wheelRadius * modelToStackFactor * IVehicleAccess.sizeFactor;
        double blockHeight = Math.min(Math.max((double)foundPos.m_123342_() + shape.m_83297_(Direction.Axis.Y) - this.m_20186_(), 0.0), 2.0 * bodyRadius);
        double edgeLengthX = leftRight * opposite > 0 ? shape.m_83288_(Direction.Axis.X) : shape.m_83297_(Direction.Axis.X);
        double edgeLengthZ = frontBack * opposite > 0 ? shape.m_83288_(Direction.Axis.Z) : shape.m_83297_(Direction.Axis.Z);
        double blockDistance = frontBack == 0 ? Math.max(this.m_20185_(), (double)foundPos.m_123341_() + edgeLengthX) - Math.min(this.m_20185_(), (double)foundPos.m_123341_() + edgeLengthX) : Math.max(this.m_20189_(), (double)foundPos.m_123343_() + edgeLengthZ) - Math.min(this.m_20189_(), (double)foundPos.m_123343_() + edgeLengthZ);
        blockDistance = Math.max(Math.abs(blockDistance), bodyRadius);
        double distance = Math.sqrt(Mth.m_144952_((double)(2.0 * bodyRadius)) - Mth.m_144952_((double)(blockHeight / blockDistance * bodyRadius)));
        double radians = Math.acos(distance / (2.0 * bodyRadius));
        double offsetY = modelToStackFactor * wheelRadius * Math.sin(radians) + modelToStackFactor * 17.0 * 0.5 - 1.5 + (1.5 - modelToStackFactor * 17.0 * 0.5) * Math.cos(radians);
        this.refuel$angleOffsets = new double[]{offsetY, -radians * (double)opposite};
    }

    @Override
    public void refuel$updateLastYRot() {
        this.refuel$lastYRot = this.m_146908_();
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.targetYRot = yaw;
        this.refuel$clientPitch = pitch;
        this.lerpSteps = 10;
    }

    @Override
    @Unique
    public void refuel$updateWheelRotation() {
        this.refuel$wheelRotation += 8.5f * this.refuel$getSpeed();
    }

    @Override
    public float refuel$getWheelRotation(float partialTicks) {
        return this.refuel$wheelRotation + 8.5f * this.refuel$getSpeed() * partialTicks;
    }

    @Override
    public void refuel$updateClientPos() {
        this.lastClientPos = this.m_20182_();
    }

    @Override
    @Unique
    public void refuel$tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.targetX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.targetY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.targetZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)((double)this.targetYRot - (double)this.m_146908_()));
            this.m_146922_((float)((double)this.m_146908_() + d3 / (double)this.lerpSteps));
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }
}

