/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.config;

import bogdan.refueled.RefueledMain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ServerConfig SERVER;
    public static ForgeConfigSpec.BooleanValue explodeOnDeath;
    public static ForgeConfigSpec.BooleanValue vehiclePersist;
    public static ForgeConfigSpec.BooleanValue spawnFull;
    public static ForgeConfigSpec.BooleanValue useBattery;
    public static ForgeConfigSpec.BooleanValue damageEntities;
    public static ForgeConfigSpec.BooleanValue collideWithEntities;
    public static ForgeConfigSpec.BooleanValue correctYaw;
    public static ForgeConfigSpec.BooleanValue restrictYaw;
    public static ForgeConfigSpec.IntValue canisterMax;
    public static ForgeConfigSpec.IntValue batteryMax;
    public static ForgeConfigSpec.IntValue gasStationMax;
    public static ForgeConfigSpec.IntValue gasStationTransferMax;
    public static ForgeConfigSpec.DoubleValue offroadSpeed;
    public static ForgeConfigSpec.DoubleValue rollResistance;
    public static ForgeConfigSpec.ConfigValue<List<Number>> vehicleFuel;
    public static ForgeConfigSpec.ConfigValue<List<Number>> vehicleBattery;
    public static ForgeConfigSpec.ConfigValue<List<Number>> vehicleMaxSpeed;
    public static ForgeConfigSpec.ConfigValue<List<Number>> vehicleMaxRevSpeed;
    public static ForgeConfigSpec.ConfigValue<List<Number>> vehicleAcc;
    public static ForgeConfigSpec.ConfigValue<List<Number>> vehicleStepHeight;
    public static ForgeConfigSpec.ConfigValue<List<Number>> vehicleRamDamage;
    public static ForgeConfigSpec.ConfigValue<List<Number>> vehicleFuelEff;
    public static ForgeConfigSpec.ConfigValue<List<Number>> vehicleHealth;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> solidEntities;
    public static ForgeConfigSpec.ConfigValue<List<List<Number>>> vehicleSteering;
    public static ForgeConfigSpec.ConfigValue<List<? extends List<String>>> fuelEff;
    public static ForgeConfigSpec.ConfigValue<List<? extends List<String>>> repairItems;
    public static ForgeConfigSpec.ConfigValue<List<? extends List<String>>> roadBlocks;

    public static void register(FMLJavaModLoadingContext ctx) {
        ctx.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SPEC);
    }

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("vehicles").comment(new String[]{"Each of these configs are represented using an array that affect in order respectively", "Modern cars, Classic cars, Trucks, SUVs, Sport cars, Motorcycles"});
        vehicleMaxSpeed = builder.comment("Maximal speeds the vehicles can reach in blocks per tick").define("speed", List.of(Double.valueOf(0.7649999999999999), Double.valueOf(0.7965), Double.valueOf(0.598), Double.valueOf(0.598), Double.valueOf(1.3392000000000002), Double.valueOf(1.152)), ServerConfig::validateNumber);
        vehicleMaxRevSpeed = builder.comment("Vehicles' top reverse speeds in blocks per tick").define("reverse_speed", List.of(Double.valueOf(0.24), Double.valueOf(0.236), Double.valueOf(0.1725), Double.valueOf(0.1725), Double.valueOf(0.3125), Double.valueOf(0.256)), ServerConfig::validateNumber);
        vehicleAcc = builder.comment("Acceleration for the vehicles").define("acceleration", List.of(Double.valueOf(0.045599999999999995), Double.valueOf(0.0472), Double.valueOf(0.0322), Double.valueOf(0.0322), Double.valueOf(0.0372), Double.valueOf(0.0512)), ServerConfig::validateNumber);
        vehicleHealth = builder.comment("Vehicles' max health").define("health", List.of(Double.valueOf(100.0), Double.valueOf(100.0), Double.valueOf(150.0), Double.valueOf(125.0), Double.valueOf(80.0), Double.valueOf(60.0)), ServerConfig::validateNumber);
        vehicleFuelEff = builder.comment(new String[]{"Vehicles' fuel consumption", "Higher = More efficient"}).define("fuel_efficiency", List.of(Double.valueOf(0.35), Double.valueOf(0.4), Double.valueOf(0.48), Double.valueOf(0.48), Double.valueOf(0.225), Double.valueOf(0.45)), ServerConfig::validateNumber);
        vehicleSteering = builder.comment(new String[]{"How much the vehicles can steer at max speed and almost full stop", "Having both values equal will keep steering constant, irrelevant of speed"}).define("steering", List.of(List.of(Double.valueOf(1.1), Double.valueOf(3.3)), List.of(Double.valueOf(1.1), Double.valueOf(3.3)), List.of(Double.valueOf(1.1), Double.valueOf(3.3)), List.of(Double.valueOf(1.1), Double.valueOf(3.3)), List.of(Double.valueOf(1.1), Double.valueOf(3.3)), List.of(Double.valueOf(1.1), Double.valueOf(4.95))), ServerConfig::validateSteering);
        vehicleStepHeight = builder.comment("Vehicles' max stepping height").define("step_height", List.of(Double.valueOf(1.0), Double.valueOf(1.0), Double.valueOf(2.0), Double.valueOf(1.6), Double.valueOf(0.6), Double.valueOf(2.0)), ServerConfig::validateNumber);
        vehicleRamDamage = builder.comment("Baseline damage to calculate onto mobs hit by the vehicles").define("ram_damage", List.of(Double.valueOf(20.0), Double.valueOf(20.0), Double.valueOf(30.0), Double.valueOf(25.0), Double.valueOf(15.0), Double.valueOf(10.0)), ServerConfig::validateNumber);
        vehicleFuel = builder.comment("Vehicles' fuel capacity").define("fuel_capacity", List.of(Integer.valueOf(1500), Integer.valueOf(1500), Integer.valueOf(2000), Integer.valueOf(2000), Integer.valueOf(1000), Integer.valueOf(1000)), ServerConfig::validateNumber);
        vehicleBattery = builder.comment("Vehicles' fuel capacity").define("battery_capacity", List.of(Integer.valueOf(8000), Integer.valueOf(8000), Integer.valueOf(10000), Integer.valueOf(10000), Integer.valueOf(6000), Integer.valueOf(4000)), ServerConfig::validateNumber);
        builder.pop();
        useBattery = builder.comment("Whether to use the battery").define("use_battery", false);
        damageEntities = builder.comment("Whether to damage any entities in the way of the vehicle").define("damage_entities", true);
        collideWithEntities = builder.comment("Whether to stop the car as if it came in collision with a block when impacting an entity").define("collide_with_entities", false);
        offroadSpeed = builder.comment("Speed modifier for DragN's vehicles on non-road blocks").defineInRange("offroad_speed", 1.0, 0.001, 10.0);
        explodeOnDeath = builder.comment("Whether the vehicle should cause an explosion on death").define("explode", false);
        canisterMax = builder.comment("How much can the canister hold of a fluid, in [mB]").defineInRange("canister_max", 2000, 444, Integer.MAX_VALUE);
        batteryMax = builder.comment("How much the battery can hold FE").defineInRange("battery_max", 10000, 444, Integer.MAX_VALUE);
        vehiclePersist = builder.comment("Whether vehicles should persist in-game when it's only passenger disconnects").define("vehicle_persist", true);
        spawnFull = builder.comment("Whether spawn eggs should spawn full tank and battery vehicles").define("spawn_full", true);
        repairItems = builder.comment(new String[]{"What items should be considered vehicle-repairable, along with how much of said item is required to repair, and how much HP should it repair", "Any starting with '#' are considered an item tag"}).defineList("repair_items", List.of(List.of("minecraft:iron_ingot", "4", "9"), List.of("#forge:ingots/steel", "1", "6")), ServerConfig::validateRepairItem);
        fuelEff = builder.comment("Fluids defined as acceptable fuels for vehicles, along with their efficiency").defineList("fuels", List.of(List.of("minecraft:lava", "1")), ServerConfig::validateFuel);
        solidEntities = builder.comment(new String[]{"Running over entity blacklist", "Having collide_with_entities enabled makes this a whitelist instead"}).defineList("solid_entities", List.of("minecraft:ender_dragon"), ServerConfig::validateEntity);
        gasStationMax = builder.comment("How much fuel can the gas station block hold").defineInRange("gas_station_capacity", 20000, 444, Integer.MAX_VALUE);
        gasStationTransferMax = builder.comment("Defines how fast the gas station can transfer fuel in [mB/t]").defineInRange("gas_station_transfer", 100, 1, Integer.MAX_VALUE);
        correctYaw = builder.comment("Whether players inside the vehicles should have their head rotated along with the vehicle").define("correct_yaw", true);
        restrictYaw = builder.comment("Whether players should be able to turn their head the whole 360 degrees when in a vehicle").define("restrict_yaw", true);
        rollResistance = builder.comment("Vehicles' resistance to roll-overs, increasing it decreases vehicle maneuverability").defineInRange("roll_resist", 0.02, 0.0, 2.147483647E9);
        builder.push("road_blocks");
        roadBlocks = builder.comment(new String[]{"A list of blocks considered on-road for cars", "Any starting with '#' are considered a block tag"}).defineListAllowEmpty("blocks", List.of(List.of("minecraft:smooth_stone", "1.25"), List.of("#refueled:road_blocks", "1.5")), ServerConfig::validateBlock);
        builder.pop();
    }

    private static boolean validateEntity(Object unsureElement) {
        if (unsureElement instanceof String) {
            String resourceLocation = (String)unsureElement;
            return ResourceLocation.m_135830_((String)resourceLocation);
        }
        return false;
    }

    private static boolean validateSteering(Object unsureList) {
        if (unsureList instanceof List) {
            List list = (List)unsureList;
            if (list.size() != 6) {
                if (list.size() < 6) {
                    return ServerConfig.warn("Steering server config list {} below expected size, defaulting.", 6 - list.size());
                }
                RefueledMain.LOGGER.warn("Steering server config list {} above expected size", (Object)(list.size() - 6));
            }
            for (Object unsureValues : list) {
                Object e;
                if (!(unsureValues instanceof List)) continue;
                List values = (List)unsureValues;
                if (values.size() != 2) {
                    if (values.size() < 2) {
                        return ServerConfig.warn("An array in the steering config list is {} below expected size, defaulting.", 6 - list.size());
                    }
                    RefueledMain.LOGGER.warn("An array in the steering config list is {} above expected size.", (Object)(6 - list.size()));
                }
                if (!((e = values.get(0)) instanceof String)) continue;
                String minValue = (String)e;
                e = values.get(1);
                if (!(e instanceof String)) continue;
                String maxValue = (String)e;
                try {
                    if (!(Float.parseFloat(minValue) <= 0.0f) && !(Float.parseFloat(maxValue) <= 0.0f)) continue;
                    RefueledMain.LOGGER.warn("Zero or negative number in the steering server config list, defaulting.");
                    return false;
                }
                catch (NumberFormatException exception) {
                    return ServerConfig.warn("Unparsable number in one of the arrays of the steering server config list, defaulting.", new Object[0]);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean validateNumber(Object unsureList) {
        if (unsureList instanceof List) {
            List list = (List)unsureList;
            if (list.size() != 6) {
                if (list.size() < 6) {
                    return ServerConfig.warn("Server config list {} below expected size, defaulting.", 6 - list.size());
                }
                RefueledMain.LOGGER.warn("Server config list {} above expected size.", (Object)(list.size() - 6));
            }
            for (Object unsureInt : list) {
                if (!(unsureInt instanceof String)) continue;
                String number = (String)unsureInt;
                try {
                    if (!(Double.parseDouble(number) <= 0.0)) continue;
                    RefueledMain.LOGGER.warn("Zero or negative number in one of the server config lists");
                    return false;
                }
                catch (NumberFormatException exception) {
                    return ServerConfig.warn("Unparsable number in one of the server config lists, defaulting.", new Object[0]);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean validateBlock(Object element) {
        if (element instanceof List) {
            List list = (List)element;
            if (list.size() < 2) {
                return ServerConfig.warn("Incomplete server config list value @ road_blocks, discarding.", new Object[0]);
            }
            Object e = list.get(0);
            if (e instanceof String) {
                String block = (String)e;
                e = list.get(1);
                if (e instanceof String) {
                    String multiplier = (String)e;
                    try {
                        if (Double.parseDouble(multiplier) <= 0.0) {
                            return false;
                        }
                    }
                    catch (NumberFormatException exception) {
                        return ServerConfig.warn("Invalid server config value @ road_blocks/{}, discarding.", block);
                    }
                    if (block.startsWith("#")) {
                        block = block.substring(1);
                    }
                    return ResourceLocation.m_135830_((String)block);
                }
            }
        }
        return false;
    }

    private static boolean validateFuel(Object element) {
        if (element instanceof List) {
            List list = (List)element;
            if (list.size() < 2) {
                return ServerConfig.warn("Incomplete server config list value @ fuels, discarding.", new Object[0]);
            }
            Object e = list.get(0);
            if (e instanceof String) {
                String fluid = (String)e;
                e = list.get(1);
                if (e instanceof String) {
                    String efficiency = (String)e;
                    try {
                        if (Double.parseDouble(efficiency) <= 0.0) {
                            return false;
                        }
                    }
                    catch (NumberFormatException exception) {
                        return ServerConfig.warn("Invalid server config value @ fuels/{}, discarding.", fluid);
                    }
                    return ResourceLocation.m_135830_((String)fluid);
                }
            }
        }
        return false;
    }

    private static boolean validateRepairItem(Object element) {
        if (element instanceof List) {
            List list = (List)element;
            if (list.size() < 3) {
                return ServerConfig.warn("Incomplete server config list value in repair_items, discarding.", new Object[0]);
            }
            Object e = list.get(0);
            if (e instanceof String) {
                String itemOrTag = (String)e;
                e = list.get(1);
                if (e instanceof String) {
                    String count = (String)e;
                    e = list.get(2);
                    if (e instanceof String) {
                        String repairValue = (String)e;
                        try {
                            if (Integer.parseInt(count) < 0 || Float.parseFloat(repairValue) <= 0.0f) {
                                return false;
                            }
                        }
                        catch (NumberFormatException exception) {
                            return ServerConfig.warn("Invalid server config value @ repair_items/{}, discarding.", itemOrTag);
                        }
                        if (itemOrTag.startsWith("#")) {
                            itemOrTag = itemOrTag.substring(1);
                        }
                        return ResourceLocation.m_135830_((String)itemOrTag);
                    }
                }
            }
        }
        return false;
    }

    private static boolean warn(String warning, Object ... var) {
        RefueledMain.LOGGER.warn(warning, var);
        return false;
    }

    public static float getRoadBlockMultiplier(BlockState state) {
        for (List list : (List)roadBlocks.get()) {
            ResourceLocation blockKey;
            String block = (String)list.get(0);
            if (!(block.startsWith("#") ? state.m_204343_().anyMatch(blockTag -> blockTag.f_203868_().toString().equals(block.substring(1))) : (blockKey = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_())) != null && blockKey.toString().equals(block))) continue;
            return Float.parseFloat((String)list.get(1));
        }
        return 0.0f;
    }

    public static float getFuelEfficiency(Fluid fluid) {
        ArrayList config = new ArrayList((Collection)fuelEff.get());
        if (fluid != null && fluid != Fluids.f_76191_) {
            ResourceLocation key = ForgeRegistries.FLUIDS.getKey((Object)fluid);
            if (key == null) {
                return 0.0f;
            }
            for (List fuelValue : config) {
                if (!key.toString().equals(fuelValue.get(0))) continue;
                return Float.parseFloat((String)fuelValue.get(1));
            }
        }
        return 0.0f;
    }

    public static List<String> getRepairItemData(ItemStack item) {
        List<String> itemTags = item.m_204131_().map(key -> key.f_203868_().toString()).toList();
        ResourceLocation key2 = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
        String itemKey = key2 == null ? "" : key2.toString();
        for (List list : (List)repairItems.get()) {
            String repairItem = (String)list.get(0);
            if (!(repairItem.startsWith("#") ? itemTags.contains(repairItem.substring(1)) : !itemKey.isEmpty() && itemKey.equals(repairItem))) continue;
            return List.of((String)list.get(1), (String)list.get(2));
        }
        return null;
    }

    public static boolean isEntityOnList(Entity entity) {
        if (entity == null) {
            return false;
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        String entityKey = key == null ? "" : key.toString();
        for (String entityString : (List)solidEntities.get()) {
            if (entityKey.isEmpty() || !entityKey.equals(entityString)) continue;
            return true;
        }
        return false;
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER = (ServerConfig)pair.getLeft();
        SPEC = (ForgeConfigSpec)pair.getRight();
    }
}

