/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.config;

import bogdan.refueled.client.gui.CarGUIScreen;
import net.minecraftforge.common.ForgeConfigSpec;

public class ClientConfig {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.DoubleValue carZoom;
    public static final ForgeConfigSpec.DoubleValue carVolume;
    public static final ForgeConfigSpec.BooleanValue temperatureFahrenheit;
    public static final ForgeConfigSpec.EnumValue<InfoDisplay> infoDisplay;
    public static final ForgeConfigSpec.BooleanValue speedImperial;
    public static final ForgeConfigSpec.BooleanValue displayInUnits;
    public static final ForgeConfigSpec.EnumValue<CarGUIScreen.LabelType> pinnedType;
    public static final ForgeConfigSpec.BooleanValue reminderMessage;
    public static final ForgeConfigSpec.BooleanValue sloping;

    static {
        builder.push("cars");
        carZoom = builder.comment("Amount of zoom when sitting in a vehicle in 3rd person camera").defineInRange("car_zoom", 4.0, 0.0, 20.0);
        carVolume = builder.comment("How loud the sound from the vehicles should be").defineInRange("car_volume", 1.0, 0.0, 1.0);
        temperatureFahrenheit = builder.comment("Whether to display temperature as Fahrenheit").define("fahrenheit_display", false);
        infoDisplay = builder.comment("Which info to display in the action bar while in a running vehicle").defineEnum("info_display", (Enum)InfoDisplay.SPEED);
        speedImperial = builder.comment("If [speed_display] is enabled, to display speed in miles per hour").define("speed_imperial", false);
        displayInUnits = builder.comment("Whether vehicle information in the gui should be display in percentages or units").define("unit_display", false);
        pinnedType = builder.comment("Which stat's level should be shown as default in the meter bar of the vehicles' GUI").defineEnum("pinned_type", (Enum)CarGUIScreen.LabelType.NONE);
        reminderMessage = builder.comment("Whether the player should be reminded how to start or open the vehicle's GUI").define("reminder", true);
        builder.push("experimental");
        sloping = builder.comment(new String[]{"Makes the vehicles angle relative to blocks around it", "Only rotates on one axis"}).define("sloping", false);
        builder.pop();
        SPEC = builder.build();
    }

    public static enum InfoDisplay {
        NONE,
        HEALTH,
        SPEED,
        BATTERY,
        TEMPERATURE,
        FUEL;

    }
}

