/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.common.network;

import bogdan.refueled.RefueledMain;
import bogdan.refueled.Utils;
import bogdan.refueled.common.accessors.IVehicleAccess;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class VehicleStarting {
    private final UUID uuid;
    private final boolean start;
    private final boolean playFailSound;

    public VehicleStarting(boolean start, boolean playFailSound, Player player) {
        this.start = start;
        this.playFailSound = playFailSound;
        this.uuid = player.m_20148_();
    }

    public VehicleStarting(FriendlyByteBuf buf) {
        this.start = buf.readBoolean();
        this.playFailSound = buf.readBoolean();
        this.uuid = buf.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.start);
        buf.writeBoolean(this.playFailSound);
        buf.m_130077_(this.uuid);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer player = supplier.get().getSender();
        if (player == null) {
            RefueledMain.LOGGER.error("null packet sender");
            return false;
        }
        if (!player.m_20148_().equals(this.uuid)) {
            RefueledMain.LOGGER.error("Mismatched sender and packet UUIDs");
            return false;
        }
        Entity car = player.m_20202_();
        if (!Utils.isCar(car)) {
            return false;
        }
        if (player.equals((Object)car.m_6688_())) {
            ((IVehicleAccess)car).refuel$setStarting(this.start, this.playFailSound);
        }
        return true;
    }
}

