/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.common.network;

import bogdan.refueled.RefueledMain;
import bogdan.refueled.Utils;
import bogdan.refueled.common.accessors.IVehicleAccess;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class VehicleCrash {
    private final UUID uuid;
    private final float speed;

    public VehicleCrash(Entity car, float speed) {
        this.uuid = car.m_20148_();
        this.speed = speed;
    }

    public VehicleCrash(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        this.speed = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.writeFloat(this.speed);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer player = supplier.get().getSender();
        if (player == null) {
            RefueledMain.LOGGER.error("Packet sender is null");
            return false;
        }
        Entity car = player.m_20202_();
        if (car == null) {
            RefueledMain.LOGGER.error("null vehicle when processing its crash");
            return false;
        }
        if (!car.m_20148_().equals(this.uuid)) {
            RefueledMain.LOGGER.error("Mismatched packet and vehicle UUID");
            return false;
        }
        if (!Utils.isCar(car)) {
            return false;
        }
        ((IVehicleAccess)car).refuel$onCollision(this.speed);
        return true;
    }
}

