/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.common.network;

import bogdan.refueled.common.network.CenterVehicle;
import bogdan.refueled.common.network.CenterVehicleClient;
import bogdan.refueled.common.network.ControlVehicle;
import bogdan.refueled.common.network.VehicleCrash;
import bogdan.refueled.common.network.VehicleGUI;
import bogdan.refueled.common.network.VehicleStarting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class RefueledChannel {
    private static SimpleChannel INSTANCE;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SimpleChannel net;
        INSTANCE = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"refueled", (String)"refueled")).networkProtocolVersion(() -> "2.1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.messageBuilder(CenterVehicle.class, RefueledChannel.id(), NetworkDirection.PLAY_TO_SERVER).decoder(CenterVehicle::new).encoder(CenterVehicle::toBytes).consumerMainThread(CenterVehicle::handle).add();
        net.messageBuilder(VehicleGUI.class, RefueledChannel.id(), NetworkDirection.PLAY_TO_SERVER).decoder(VehicleGUI::new).encoder(VehicleGUI::toBytes).consumerMainThread(VehicleGUI::handle).add();
        net.messageBuilder(VehicleStarting.class, RefueledChannel.id(), NetworkDirection.PLAY_TO_SERVER).decoder(VehicleStarting::new).encoder(VehicleStarting::toBytes).consumerMainThread(VehicleStarting::handle).add();
        net.messageBuilder(VehicleCrash.class, RefueledChannel.id(), NetworkDirection.PLAY_TO_SERVER).decoder(VehicleCrash::new).encoder(VehicleCrash::toBytes).consumerMainThread(VehicleCrash::handle).add();
        net.messageBuilder(ControlVehicle.class, RefueledChannel.id(), NetworkDirection.PLAY_TO_SERVER).decoder(ControlVehicle::new).encoder(ControlVehicle::toBytes).consumerMainThread(ControlVehicle::handle).add();
        net.messageBuilder(CenterVehicleClient.class, RefueledChannel.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(CenterVehicleClient::new).encoder(CenterVehicleClient::toBytes).consumerMainThread(CenterVehicleClient::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    static {
        packetId = 0;
    }
}

