/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.common.network;

import bogdan.refueled.RefueledMain;
import bogdan.refueled.Utils;
import bogdan.refueled.common.accessors.IVehicleAccess;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ControlVehicle {
    private final boolean forward;
    private final boolean backward;
    private final boolean left;
    private final boolean right;
    private final UUID uuid;

    public ControlVehicle(boolean forward, boolean backward, boolean left, boolean right, Player player) {
        this.forward = forward;
        this.backward = backward;
        this.left = left;
        this.right = right;
        this.uuid = player.m_20148_();
    }

    public ControlVehicle(FriendlyByteBuf buf) {
        this.forward = buf.readBoolean();
        this.backward = buf.readBoolean();
        this.left = buf.readBoolean();
        this.right = buf.readBoolean();
        this.uuid = buf.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.forward);
        buf.writeBoolean(this.backward);
        buf.writeBoolean(this.left);
        buf.writeBoolean(this.right);
        buf.m_130077_(this.uuid);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        if (player == null) {
            RefueledMain.LOGGER.error("Packet sender is null");
            return false;
        }
        if (!player.m_20148_().equals(this.uuid)) {
            RefueledMain.LOGGER.error("Mismatched sender and packet UUID");
            return false;
        }
        Entity car = player.m_20202_();
        if (!Utils.isCar(car)) {
            return false;
        }
        ((IVehicleAccess)car).refuel$updateControls(this.forward, this.backward, this.left, this.right, (Player)player);
        return true;
    }
}

