/*
 * Decompiled with CFR 0.152.
 */
package bogdan.refueled.common.network;

import bogdan.refueled.RefueledMain;
import bogdan.refueled.Utils;
import bogdan.refueled.common.accessors.IVehicleAccess;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class CenterVehicleClient {
    private final UUID uuid;

    public CenterVehicleClient(Player player) {
        this.uuid = player.m_20148_();
    }

    public CenterVehicleClient(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::handleOnClient);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleOnClient() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            RefueledMain.LOGGER.error("Unable to process packet because client player is null");
            return;
        }
        Player driver = player.m_9236_().m_46003_(this.uuid);
        if (driver == null) {
            RefueledMain.LOGGER.error("Could not center vehicle because it's driver is null");
            return;
        }
        if (!driver.m_20148_().equals(this.uuid)) {
            RefueledMain.LOGGER.error("Mismatched sender and packet UUIDs");
            return;
        }
        Entity car = driver.m_20202_();
        if (!Utils.isCar(car)) {
            return;
        }
        if (driver.equals((Object)car.m_6688_())) {
            ((IVehicleAccess)car).refuel$centerCar();
        }
    }
}

